/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.zookeeper.datasource;

import com.github.phantomthief.util.ObjectMapperUtils;
import com.github.phantomthief.util.WeakHolder;
import com.github.phantomthief.zookeeper.AbstractLazyZkBasedNodeResource;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.curator.framework.CuratorFramework;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

public class ZkBasedShardedBasicDataSource
extends AbstractLazyZkBasedNodeResource<RangeMap<Integer, BasicDataSource>> {
    private static WeakHolder<Pattern> shardPattern = WeakHolder.of(() -> Pattern.compile("(\\d+)-(\\d+)"));
    private static ConcurrentMap<DataSource, NamedParameterJdbcTemplate> jdbcTemplateCache = new MapMaker().concurrencyLevel(16).weakKeys().weakValues().makeMap();

    public ZkBasedShardedBasicDataSource(String monitorPath, CuratorFramework client) {
        super(monitorPath, client);
        try {
            Class.forName("com.mysql.jdbc.Driver");
        }
        catch (ClassNotFoundException e) {
            this.logger.error("Ops.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public ZkBasedShardedBasicDataSource(String monitorPath, Supplier<CuratorFramework> clientFactory) {
        super(monitorPath, clientFactory);
        try {
            Class.forName("com.mysql.jdbc.Driver");
        }
        catch (ClassNotFoundException e) {
            this.logger.error("Ops.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    protected RangeMap<Integer, BasicDataSource> initObject(String rawNode) {
        try {
            Map allShard = (Map)ObjectMapperUtils.fromJSON(rawNode, Map.class, String.class, Object.class);
            ImmutableRangeMap.Builder resultBuilder = ImmutableRangeMap.builder();
            for (Map.Entry entry : allShard.entrySet()) {
                Map node = (Map)entry.getValue();
                String url = (String)node.get("url");
                String user = (String)node.get("user");
                String pass = (String)node.get("pass");
                BasicDataSource dataSource = new BasicDataSource();
                dataSource.setUrl(url);
                dataSource.setUsername(user);
                dataSource.setPassword(pass);
                dataSource.setMinIdle(1);
                dataSource.setMaxIdle(10);
                dataSource.setMaxTotal(-1);
                dataSource.setDefaultAutoCommit(Boolean.valueOf(true));
                dataSource.setMinEvictableIdleTimeMillis(TimeUnit.MINUTES.toMillis(1L));
                dataSource.setSoftMinEvictableIdleTimeMillis(TimeUnit.MINUTES.toMillis(1L));
                dataSource.setTestOnBorrow(true);
                dataSource.setTestWhileIdle(true);
                dataSource.setValidationQuery("/* ping */");
                this.logger.info("build datasource for {}, {}", (Object)this.monitorPath, (Object)url);
                BeanUtils.populate((Object)dataSource, (Map)node);
                Matcher matcher = shardPattern.get().matcher((CharSequence)entry.getKey());
                if (matcher.find()) {
                    int start = Integer.parseInt(matcher.group(1));
                    int end = Integer.parseInt(matcher.group(2));
                    resultBuilder.put(Range.closed((Comparable)Integer.valueOf(start), (Comparable)Integer.valueOf(end)), (Object)dataSource);
                    this.postProcessNode(start, end, node);
                    continue;
                }
                this.logger.error("invalid shard config:{}", (Object)rawNode);
            }
            ImmutableRangeMap result = resultBuilder.build();
            int shardSize = ZkBasedShardedBasicDataSource.getShardSize(result);
            for (int i = 0; i < shardSize; ++i) {
                if (result.get((Comparable)Integer.valueOf(i)) != null) continue;
                this.logger.error("error shard config on validate:{}, fail on shard:{}", (Object)rawNode, (Object)i);
            }
            return result;
        }
        catch (Throwable e) {
            this.logger.error("Ops. fail to init shard dataSource:{}", (Object)this.monitorPath, (Object)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Predicate<RangeMap<Integer, BasicDataSource>> doCleanupOperation() {
        return oldResource -> {
            boolean allSuccess = true;
            for (BasicDataSource dataSource : oldResource.asMapOfRanges().values()) {
                if (dataSource.isClosed()) continue;
                try {
                    dataSource.close();
                    if (dataSource.isClosed()) continue;
                    allSuccess = false;
                }
                catch (SQLException e) {
                    this.logger.error("fail to close datasource:{}", (Object)dataSource, (Object)e);
                }
            }
            return allSuccess;
        };
    }

    protected void postProcessNode(int shardStart, int shardEnd, Map<String, Object> node) {
    }

    public BasicDataSource getDataSource(int shard) {
        RangeMap thisObject = (RangeMap)this.getResource();
        return (BasicDataSource)thisObject.get((Comparable)Integer.valueOf(shard % ZkBasedShardedBasicDataSource.getShardSize(thisObject)));
    }

    public BasicDataSource getDataSource(long shard) {
        RangeMap thisObject = (RangeMap)this.getResource();
        return (BasicDataSource)thisObject.get((Comparable)Integer.valueOf((int)(shard % (long)ZkBasedShardedBasicDataSource.getShardSize(thisObject))));
    }

    public String processTableName(String rawTableName, int shard) {
        RangeMap thisObject = (RangeMap)this.getResource();
        return rawTableName + "_" + shard % ZkBasedShardedBasicDataSource.getShardSize(thisObject);
    }

    public String processTableName(String rawTableName, long shard) {
        RangeMap thisObject = (RangeMap)this.getResource();
        return rawTableName + "_" + shard % (long)ZkBasedShardedBasicDataSource.getShardSize(thisObject);
    }

    public int getShard(int shard) {
        RangeMap thisObject = (RangeMap)this.getResource();
        return shard % ZkBasedShardedBasicDataSource.getShardSize(thisObject);
    }

    public int getShard(long shard) {
        RangeMap thisObject = (RangeMap)this.getResource();
        return (int)(shard % (long)ZkBasedShardedBasicDataSource.getShardSize(thisObject));
    }

    private static final <T> int getShardSize(RangeMap<Integer, T> rangeMap) {
        return (Integer)rangeMap.span().upperEndpoint() + 1;
    }

    public static final NamedParameterJdbcTemplate of(DataSource ds) {
        return jdbcTemplateCache.computeIfAbsent(ds, d -> {
            NamedParameterJdbcTemplate r = new NamedParameterJdbcTemplate(d);
            r.setCacheLimit(0);
            return r;
        });
    }
}

