/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.zookeeper.jedis;

import com.github.phantomthief.util.ObjectMapperUtils;
import com.github.phantomthief.zookeeper.AbstractLazyZkBasedNodeResource;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multimap;
import com.google.common.collect.UnmodifiableIterator;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.BaseStream;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.curator.framework.CuratorFramework;
import redis.clients.jedis.BinaryJedisCommands;
import redis.clients.jedis.BinaryShardedJedis;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCommands;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.Response;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.ShardedJedisPipeline;
import redis.clients.jedis.ShardedJedisPool;

public class ZkBasedJedis
extends AbstractLazyZkBasedNodeResource<ShardedJedisPool> {
    public static final int PARTITION_SIZE = 100;
    private static final int POOL_TOTAL_MAX_COUNT = 500;
    private static final int POOL_MAX_COUNT = 10;

    public ZkBasedJedis(String monitorPath, CuratorFramework client) {
        super(monitorPath, client);
    }

    public ZkBasedJedis(String monitorPath, Supplier<CuratorFramework> clientFactory) {
        super(monitorPath, clientFactory);
    }

    @Override
    protected ShardedJedisPool initObject(String rawNode) {
        try {
            Map configs = (Map)ObjectMapperUtils.fromJSON(rawNode, Map.class, String.class, String.class);
            JedisPoolConfig poolConfig = new JedisPoolConfig();
            poolConfig.setTestWhileIdle(true);
            poolConfig.setMaxTotal(500);
            poolConfig.setMaxIdle(10);
            poolConfig.setBlockWhenExhausted(true);
            ArrayList<JedisShardInfo> shards = new ArrayList<JedisShardInfo>(configs.size());
            Splitter valueSplitter = Splitter.on((char)':');
            Splitter keySplitter = Splitter.on((char)'@').limit(2);
            for (Map.Entry entry : configs.entrySet()) {
                List split = valueSplitter.splitToList((CharSequence)entry.getValue());
                List keySplit = keySplitter.splitToList((CharSequence)entry.getKey());
                JedisShardInfo jsi = new JedisShardInfo((String)split.get(0), Integer.parseInt((String)split.get(1)), 0, (String)keySplit.get(0));
                if (keySplit.size() == 2) {
                    jsi.setPassword((String)keySplit.get(1));
                }
                shards.add(jsi);
            }
            this.logger.info("build jedis for {}, {}", (Object)this.monitorPath, shards);
            return new ShardedJedisPool((GenericObjectPoolConfig)poolConfig, shards);
        }
        catch (Throwable e) {
            this.logger.error("Ops. fail to get jedis pool:{}", (Object)this.monitorPath, (Object)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Predicate<ShardedJedisPool> doCleanupOperation() {
        return oldResource -> {
            if (oldResource.isClosed()) {
                return true;
            }
            oldResource.close();
            return oldResource.isClosed();
        };
    }

    public ShardedJedisPool getPool() {
        return (ShardedJedisPool)this.getResource();
    }

    public JedisCommands get() {
        ShardedJedisPool thisPool = this.getPool();
        return (JedisCommands)Proxy.newProxyInstance(ShardedJedis.class.getClassLoader(), ShardedJedis.class.getInterfaces(), (InvocationHandler)new PoolableJedisCommands(thisPool));
    }

    public BinaryJedisCommands getBinary() {
        ShardedJedisPool thisPool = this.getPool();
        return (BinaryJedisCommands)Proxy.newProxyInstance(BinaryShardedJedis.class.getClassLoader(), BinaryShardedJedis.class.getInterfaces(), (InvocationHandler)new PoolableJedisCommands(thisPool));
    }

    public byte[] getToBytes(String key) {
        ShardedJedisPool pool = this.getPool();
        try (ShardedJedis shardedJedis = pool.getResource();){
            byte[] byArray = shardedJedis.get(key.getBytes());
            return byArray;
        }
    }

    public <K> int zremByScore(String key, Collection<Double> scores) {
        int result = 0;
        ShardedJedisPool pool = this.getPool();
        try (ShardedJedis shardedJedis = pool.getResource();){
            for (List list : Iterables.partition(scores, (int)100)) {
                ShardedJedisPipeline pipeline = shardedJedis.pipelined();
                ArrayList<Response> responseList = new ArrayList<Response>();
                for (Double score : list) {
                    responseList.add(pipeline.zremrangeByScore(key, score.doubleValue(), score.doubleValue()));
                }
                pipeline.sync();
                for (Response r : responseList) {
                    result = (int)((long)result + (Long)r.get());
                }
            }
        }
        return result;
    }

    public <K, V> Map<K, V> mget(Collection<K> keys, Function<K, String> keyGenerator, Function<String, V> codec) {
        HashMap result = new HashMap(keys == null ? 0 : keys.size());
        if (keys != null) {
            HashMap<String, K> keyMap = new HashMap<String, K>(keys.size());
            for (K key : keys) {
                keyMap.put(keyGenerator.apply(key), key);
            }
            for (List list : Iterables.partition(keyMap.entrySet(), (int)100)) {
                ShardedJedisPool pool = this.getPool();
                ShardedJedis shardedJedis = pool.getResource();
                Throwable throwable = null;
                try {
                    ShardedJedisPipeline pipeline = shardedJedis.pipelined();
                    HashMap responseMap = new HashMap(list.size());
                    for (Map.Entry entry : list) {
                        responseMap.put(entry.getValue(), pipeline.get((String)entry.getKey()));
                    }
                    pipeline.sync();
                    for (Map.Entry entry : responseMap.entrySet()) {
                        if (((Response)entry.getValue()).get() == null) continue;
                        result.put(entry.getKey(), codec.apply((String)((Response)entry.getValue()).get()));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (shardedJedis == null) continue;
                    if (throwable != null) {
                        try {
                            shardedJedis.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    shardedJedis.close();
                }
            }
        }
        return result;
    }

    public <K, V> Map<K, V> mgetByBytes(Collection<K> keys, Function<K, byte[]> keyGenerator, Function<byte[], V> codec) {
        HashMap result = new HashMap(keys == null ? 0 : keys.size());
        if (keys != null) {
            HashMap<byte[], K> keyMap = new HashMap<byte[], K>(keys.size());
            for (K key : keys) {
                keyMap.put(keyGenerator.apply(key), key);
            }
            for (List list : Iterables.partition(keyMap.entrySet(), (int)100)) {
                ShardedJedisPool pool = this.getPool();
                ShardedJedis shardedJedis = pool.getResource();
                Throwable throwable = null;
                try {
                    ShardedJedisPipeline pipeline = shardedJedis.pipelined();
                    HashMap responseMap = new HashMap(list.size());
                    for (Map.Entry entry : list) {
                        responseMap.put(entry.getValue(), pipeline.get((byte[])entry.getKey()));
                    }
                    pipeline.sync();
                    for (Map.Entry entry : responseMap.entrySet()) {
                        if (((Response)entry.getValue()).get() == null) continue;
                        result.put(entry.getKey(), codec.apply((byte[])((Response)entry.getValue()).get()));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (shardedJedis == null) continue;
                    if (throwable != null) {
                        try {
                            shardedJedis.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    shardedJedis.close();
                }
            }
        }
        return result;
    }

    public <K, V> Map<K, V> hmget(Collection<K> keys, Function<K, String> keyGenerator, Function<Map<String, String>, V> codec) {
        HashMap result = new HashMap(keys == null ? 0 : keys.size());
        if (keys != null) {
            HashMap<String, K> keyMap = new HashMap<String, K>(keys.size());
            for (K key : keys) {
                keyMap.put(keyGenerator.apply(key), key);
            }
            for (List list : Iterables.partition(keyMap.entrySet(), (int)100)) {
                ShardedJedisPool pool = this.getPool();
                ShardedJedis shardedJedis = pool.getResource();
                Throwable throwable = null;
                try {
                    ShardedJedisPipeline pipeline = shardedJedis.pipelined();
                    HashMap responseMap = new HashMap(list.size());
                    for (Map.Entry entry : list) {
                        responseMap.put(entry.getValue(), pipeline.hgetAll((String)entry.getKey()));
                    }
                    pipeline.sync();
                    for (Map.Entry entry : responseMap.entrySet()) {
                        if (((Response)entry.getValue()).get() == null) continue;
                        result.put(entry.getKey(), codec.apply((Map<String, String>)((Response)entry.getValue()).get()));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (shardedJedis == null) continue;
                    if (throwable != null) {
                        try {
                            shardedJedis.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    shardedJedis.close();
                }
            }
        }
        return result;
    }

    public <K, V> void mset(Map<K, V> map, Function<K, String> keyGenerator, Function<V, String> codec) {
        this.mset(map, keyGenerator, codec, 0);
    }

    public <K, V> void mset(Map<K, V> map, Function<K, String> keyGenerator, Function<V, String> codec, int expireSeconds) {
        if (MapUtils.isNotEmpty(map)) {
            Map<String, String> dataMap = map.entrySet().stream().collect(Collectors.toMap(entry -> (String)keyGenerator.apply(entry.getKey()), entry -> (String)codec.apply(entry.getValue())));
            for (List list : Iterables.partition(dataMap.entrySet(), (int)100)) {
                ShardedJedisPool pool = this.getPool();
                ShardedJedis shardedJedis = pool.getResource();
                Throwable throwable = null;
                try {
                    ShardedJedisPipeline pipeline = shardedJedis.pipelined();
                    for (Map.Entry entry2 : list) {
                        if (entry2.getKey() == null || entry2.getValue() == null) continue;
                        if (expireSeconds > 0) {
                            pipeline.setex((String)entry2.getKey(), expireSeconds, (String)entry2.getValue());
                            continue;
                        }
                        pipeline.set((String)entry2.getKey(), (String)entry2.getValue());
                    }
                    pipeline.sync();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (shardedJedis == null) continue;
                    if (throwable != null) {
                        try {
                            shardedJedis.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    shardedJedis.close();
                }
            }
        }
    }

    public <K, V, E extends BaseStream<K, E>> Map<K, V> pipeline(E keys, BiFunction<ShardedJedisPipeline, K, Response<V>> function) {
        HashMap result = new HashMap();
        if (keys != null) {
            UnmodifiableIterator partition;
            UnmodifiableIterator iterator = partition = Iterators.partition(keys.iterator(), (int)100);
            while (iterator.hasNext()) {
                List list = (List)iterator.next();
                ShardedJedisPool pool = this.getPool();
                ShardedJedis shardedJedis = pool.getResource();
                Throwable throwable = null;
                try {
                    ShardedJedisPipeline pipeline = shardedJedis.pipelined();
                    HashMap thisMap = new HashMap(list.size());
                    for (Object e : list) {
                        Response<V> apply = function.apply(pipeline, e);
                        thisMap.put(e, apply);
                    }
                    pipeline.sync();
                    for (Map.Entry entry : thisMap.entrySet()) {
                        if (entry.getValue() == null) continue;
                        result.put(entry.getKey(), ((Response)entry.getValue()).get());
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (shardedJedis == null) continue;
                    if (throwable != null) {
                        try {
                            shardedJedis.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    shardedJedis.close();
                }
            }
        }
        return result;
    }

    public <K, V> Map<K, V> pipeline(Iterable<K> keys, BiFunction<ShardedJedisPipeline, K, Response<V>> function) {
        int size = keys != null && keys instanceof Collection ? ((Collection)keys).size() : 16;
        HashMap result = new HashMap(size);
        if (keys != null) {
            Iterable partition = Iterables.partition(keys, (int)100);
            for (List list : partition) {
                ShardedJedisPool pool = this.getPool();
                ShardedJedis shardedJedis = pool.getResource();
                Throwable throwable = null;
                try {
                    ShardedJedisPipeline pipeline = shardedJedis.pipelined();
                    HashMap thisMap = new HashMap(list.size());
                    for (Object e : list) {
                        Response<V> apply = function.apply(pipeline, e);
                        thisMap.put(e, apply);
                    }
                    pipeline.sync();
                    for (Map.Entry entry : thisMap.entrySet()) {
                        if (entry.getValue() == null) continue;
                        result.put(entry.getKey(), ((Response)entry.getValue()).get());
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (shardedJedis == null) continue;
                    if (throwable != null) {
                        try {
                            shardedJedis.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    shardedJedis.close();
                }
            }
        }
        return result;
    }

    public <K, V, T> Map<K, T> pipeline(Iterable<K> keys, BiFunction<ShardedJedisPipeline, K, Response<V>> function, Function<V, T> decoder) {
        int size = keys != null && keys instanceof Collection ? ((Collection)keys).size() : 16;
        HashMap result = new HashMap(size);
        if (keys != null) {
            Iterable partition = Iterables.partition(keys, (int)100);
            for (List list : partition) {
                ShardedJedisPool pool = this.getPool();
                ShardedJedis shardedJedis = pool.getResource();
                Throwable throwable = null;
                try {
                    ShardedJedisPipeline pipeline = shardedJedis.pipelined();
                    HashMap thisMap = new HashMap(list.size());
                    for (Object e : list) {
                        Response<V> apply = function.apply(pipeline, e);
                        thisMap.put(e, apply);
                    }
                    pipeline.sync();
                    for (Map.Entry entry : thisMap.entrySet()) {
                        if (entry.getValue() == null) continue;
                        result.put(entry.getKey(), decoder.apply(((Response)entry.getValue()).get()));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (shardedJedis == null) continue;
                    if (throwable != null) {
                        try {
                            shardedJedis.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    shardedJedis.close();
                }
            }
        }
        return result;
    }

    public Multimap<String, String> keys(String keyPattern) {
        ShardedJedisPool r = (ShardedJedisPool)this.getResource();
        try (ShardedJedis shardedJedis = r.getResource();){
            HashMultimap result = HashMultimap.create();
            Collection allShards = shardedJedis.getAllShards();
            for (Jedis jedis : allShards) {
                result.putAll((Object)(jedis.getClient().getHost() + ":" + jedis.getClient().getPort()), (Iterable)jedis.keys(keyPattern));
            }
            HashMultimap hashMultimap = result;
            return hashMultimap;
        }
    }

    public static BitSet fromRedisBitSet(byte[] bytes) {
        BitSet bits = new BitSet();
        if (bytes != null && bytes.length > 0) {
            for (int i = 0; i < bytes.length * 8; ++i) {
                if ((bytes[i / 8] & 1 << 7 - i % 8) == 0) continue;
                bits.set(i);
            }
        }
        return bits;
    }

    private final class PoolableJedisCommands
    implements InvocationHandler {
        private ShardedJedisPool jedis;

        PoolableJedisCommands(ShardedJedisPool jedis) {
            this.jedis = jedis;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try (ShardedJedis resource = this.jedis.getResource();){
                Object invoke;
                Object object = invoke = method.invoke((Object)resource, args);
                return object;
            }
        }
    }
}

