/*
 * Decompiled with CFR 0.152.
 */
package smile.data;

import java.io.IOException;
import java.io.LineNumberReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Scanner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import smile.data.Dataset;
import smile.data.Instance;
import smile.data.SparseDatasetImpl;
import smile.math.MathEx;
import smile.math.matrix.SparseMatrix;
import smile.util.SparseArray;

public interface SparseDataset
extends Dataset<SparseArray> {
    public int nz();

    public int nz(int var1);

    default public int nrow() {
        return this.size();
    }

    public int ncol();

    default public double get(int i, int j) {
        if (i < 0 || i >= this.size() || j < 0 || j >= this.ncol()) {
            throw new IllegalArgumentException("Invalid index: i = " + i + " j = " + j);
        }
        for (SparseArray.Entry e : (SparseArray)this.get(i)) {
            if (e.i != j) continue;
            return e.x;
        }
        return 0.0;
    }

    default public void unitize() {
        this.stream().forEach(x -> {
            double sum = 0.0;
            for (SparseArray.Entry e : x) {
                sum += MathEx.pow2(e.x);
            }
            sum = Math.sqrt(sum);
            for (SparseArray.Entry e : x) {
                e.update(e.x / sum);
            }
        });
    }

    default public void unitize1() {
        this.stream().forEach(x -> {
            double sum = 0.0;
            for (SparseArray.Entry e : x) {
                sum += Math.abs(e.x);
            }
            for (SparseArray.Entry e : x) {
                e.update(e.x / sum);
            }
        });
    }

    default public SparseMatrix toMatrix() {
        int nz = this.nz();
        int ncol = this.ncol();
        int[] pos = new int[ncol];
        int[] colIndex = new int[ncol + 1];
        for (int i = 0; i < ncol; ++i) {
            colIndex[i + 1] = colIndex[i] + this.nz(i);
        }
        int nrow = this.size();
        int[] rowIndex = new int[nz];
        double[] x = new double[nz];
        for (int i = 0; i < nrow; ++i) {
            for (SparseArray.Entry e : (SparseArray)this.get(i)) {
                int j = e.i;
                int k = colIndex[j] + pos[j];
                rowIndex[k] = i;
                x[k] = e.x;
                int n = j;
                pos[n] = pos[n] + 1;
            }
        }
        return new SparseMatrix(nrow, ncol, x, rowIndex, colIndex);
    }

    public static SparseDataset of(Stream<SparseArray> data) {
        return SparseDataset.of(data.collect(Collectors.toList()));
    }

    public static SparseDataset of(Collection<SparseArray> data) {
        return new SparseDatasetImpl(data);
    }

    public static SparseDataset of(Collection<SparseArray> data, int ncol) {
        return new SparseDatasetImpl(data, ncol);
    }

    public static SparseDataset of(Dataset<Instance<SparseArray>> data) {
        return SparseDataset.of(data.stream().map(Instance::x).collect(Collectors.toList()));
    }

    public static SparseDataset from(Path path) throws IOException, ParseException {
        return SparseDataset.from(path, 0);
    }

    public static SparseDataset from(Path path, int arrayIndexOrigin) throws IOException, ParseException {
        try (LineNumberReader reader = new LineNumberReader(Files.newBufferedReader(path));){
            Scanner scanner = new Scanner(reader);
            try {
                int nrow = scanner.nextInt();
                int ncol = scanner.nextInt();
                int nz = scanner.nextInt();
                ArrayList<SparseArray> rows = new ArrayList<SparseArray>(nrow);
                for (int i = 0; i < nrow; ++i) {
                    rows.add(new SparseArray());
                }
                scanner.nextLine();
                do {
                    String line;
                    String[] tokens;
                    if ((tokens = (line = scanner.nextLine()).trim().split("\\s+")).length != 3) {
                        throw new ParseException("Invalid line: " + line, reader.getLineNumber());
                    }
                    int i = Integer.parseInt(tokens[0]) - arrayIndexOrigin;
                    int j = Integer.parseInt(tokens[1]) - arrayIndexOrigin;
                    double x = Double.parseDouble(tokens[2]);
                    SparseArray row = (SparseArray)rows.get(i);
                    row.set(j, x);
                } while (scanner.hasNextLine());
                SparseDataset sparseDataset = SparseDataset.of(rows);
                scanner.close();
                return sparseDataset;
            }
            catch (Throwable throwable) {
                try {
                    scanner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }
}

