/*
 * Decompiled with CFR 0.152.
 */
package smile.data.type;

import java.util.Arrays;
import smile.data.type.DataType;
import smile.data.type.DataTypes;

public class ArrayType
implements DataType {
    static ArrayType BooleanArrayType = new ArrayType(DataTypes.BooleanType);
    static ArrayType CharArrayType = new ArrayType(DataTypes.CharType);
    static ArrayType ByteArrayType = new ArrayType(DataTypes.ByteType);
    static ArrayType ShortArrayType = new ArrayType(DataTypes.ShortType);
    static ArrayType IntegerArrayType = new ArrayType(DataTypes.IntegerType);
    static ArrayType LongArrayType = new ArrayType(DataTypes.LongType);
    static ArrayType FloatArrayType = new ArrayType(DataTypes.FloatType);
    static ArrayType DoubleArrayType = new ArrayType(DataTypes.DoubleType);
    private final DataType type;

    ArrayType(DataType type) {
        this.type = type;
    }

    public DataType getComponentType() {
        return this.type;
    }

    @Override
    public String name() {
        return String.format("Array%s", this.type.name());
    }

    @Override
    public DataType.ID id() {
        return DataType.ID.Array;
    }

    public String toString() {
        return String.format("%s[]", this.type);
    }

    @Override
    public String toString(Object o) {
        switch (this.type.id()) {
            case Boolean: {
                return Arrays.toString((boolean[])o);
            }
            case Byte: {
                return Arrays.toString((byte[])o);
            }
            case Char: {
                return Arrays.toString((char[])o);
            }
            case Short: {
                return Arrays.toString((short[])o);
            }
            case Integer: {
                return Arrays.toString((int[])o);
            }
            case Long: {
                return Arrays.toString((long[])o);
            }
            case Float: {
                return Arrays.toString((float[])o);
            }
            case Double: {
                return Arrays.toString((double[])o);
            }
        }
        return Arrays.toString((Object[])o);
    }

    public Object[] valueOf(String s) {
        String[] elements = s.substring(1, s.length() - 1).split(",");
        Object[] array = new Object[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            array[i] = this.type.valueOf(elements[i]);
        }
        return array;
    }

    public boolean equals(Object o) {
        if (o instanceof ArrayType) {
            return this.type == ((ArrayType)o).getComponentType();
        }
        return false;
    }
}

