/*
 * Decompiled with CFR 0.152.
 */
package smile.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.io.InputFile;
import smile.io.LocalInputFile;

public interface HadoopInput {
    public static BufferedReader reader(String path) throws IOException, URISyntaxException {
        return new BufferedReader(new InputStreamReader(HadoopInput.stream(path)));
    }

    public static BufferedReader reader(String path, Charset charset) throws IOException, URISyntaxException {
        return new BufferedReader(new InputStreamReader(HadoopInput.stream(path), charset));
    }

    public static InputStream stream(String path) throws IOException, URISyntaxException {
        URI uri = new URI(path);
        if (uri.getScheme() == null) {
            return Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]);
        }
        switch (uri.getScheme().toLowerCase()) {
            case "file": {
                return Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]);
            }
            case "s3": 
            case "s3a": 
            case "s3n": 
            case "hdfs": {
                Configuration conf = new Configuration();
                FileSystem fs = FileSystem.get((Configuration)conf);
                return fs.open(new Path(path));
            }
        }
        return uri.toURL().openStream();
    }

    public static InputFile file(String path) throws IOException, URISyntaxException {
        URI uri = new URI(path);
        if (uri.getScheme() == null) {
            return new LocalInputFile(Paths.get(path, new String[0]));
        }
        switch (uri.getScheme().toLowerCase()) {
            case "file": {
                return new LocalInputFile(Paths.get(path, new String[0]));
            }
            case "s3": 
            case "s3a": 
            case "s3n": 
            case "hdfs": {
                Configuration conf = new Configuration();
                FileSystem fs = FileSystem.get((Configuration)conf);
                return HadoopInputFile.fromPath((Path)new Path(path), (Configuration)conf);
            }
        }
        throw new IllegalArgumentException("Unsupported URI schema for Parquet files: " + path);
    }
}

