/*
 * Decompiled with CFR 0.152.
 */
package smile.math;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.math.DifferentiableFunction;
import smile.math.Function;
import smile.math.MathEx;

public class Root {
    private static final Logger logger = LoggerFactory.getLogger(Root.class);

    private Root() {
    }

    public static double find(Function func, double x1, double x2, double tol, int maxIter) {
        if (tol <= 0.0) {
            throw new IllegalArgumentException("Invalid tolerance: " + tol);
        }
        if (maxIter <= 0) {
            throw new IllegalArgumentException("Invalid maximum number of iterations: " + maxIter);
        }
        double a = x1;
        double b = x2;
        double c = x2;
        double d = 0.0;
        double e = 0.0;
        double fa = func.apply(a);
        double fb = func.apply(b);
        if (fa > 0.0 && fb > 0.0 || fa < 0.0 && fb < 0.0) {
            throw new IllegalArgumentException("Root must be bracketed.");
        }
        double fc = fb;
        for (int iter = 1; iter <= maxIter; ++iter) {
            if (fb > 0.0 && fc > 0.0 || fb < 0.0 && fc < 0.0) {
                c = a;
                fc = fa;
                e = d = b - a;
            }
            if (Math.abs(fc) < Math.abs(fb)) {
                a = b;
                b = c;
                c = a;
                fa = fb;
                fb = fc;
                fc = fa;
            }
            tol = 2.0 * MathEx.EPSILON * Math.abs(b) + 0.5 * tol;
            double xm = 0.5 * (c - b);
            if (iter % 10 == 0) {
                logger.info(String.format("Brent: the root after %3d iterations: %.5g, error = %.5g", iter, b, xm));
            }
            if (Math.abs(xm) <= tol || fb == 0.0) {
                logger.info(String.format("Brent finds the root after %d iterations: %.5g, error = %.5g", iter, b, xm));
                return b;
            }
            if (Math.abs(e) >= tol && Math.abs(fa) > Math.abs(fb)) {
                double min2;
                double min1;
                double q;
                double p;
                double s = fb / fa;
                if (a == c) {
                    p = 2.0 * xm * s;
                    q = 1.0 - s;
                } else {
                    q = fa / fc;
                    double r = fb / fc;
                    p = s * (2.0 * xm * q * (q - r) - (b - a) * (r - 1.0));
                    q = (q - 1.0) * (r - 1.0) * (s - 1.0);
                }
                if (p > 0.0) {
                    q = -q;
                }
                if (2.0 * (p = Math.abs(p)) < Math.min(min1 = 3.0 * xm * q - Math.abs(tol * q), min2 = Math.abs(e * q))) {
                    e = d;
                    d = p / q;
                } else {
                    e = d = xm;
                }
            } else {
                e = d = xm;
            }
            a = b;
            fa = fb;
            b = Math.abs(d) > tol ? (b += d) : (b += Math.copySign(tol, xm));
            fb = func.apply(b);
        }
        logger.error("Brent exceeded the maximum number of iterations.");
        return b;
    }

    public static double find(DifferentiableFunction func, double x1, double x2, double tol, int maxIter) {
        double dxold;
        double xh;
        double xl;
        if (tol <= 0.0) {
            throw new IllegalArgumentException("Invalid tolerance: " + tol);
        }
        if (maxIter <= 0) {
            throw new IllegalArgumentException("Invalid maximum number of iterations: " + maxIter);
        }
        double fl = func.apply(x1);
        double fh = func.apply(x2);
        if (fl > 0.0 && fh > 0.0 || fl < 0.0 && fh < 0.0) {
            throw new IllegalArgumentException("Root must be bracketed in rtsafe");
        }
        if (fl == 0.0) {
            return x1;
        }
        if (fh == 0.0) {
            return x2;
        }
        if (fl < 0.0) {
            xl = x1;
            xh = x2;
        } else {
            xh = x1;
            xl = x2;
        }
        double rts = 0.5 * (x1 + x2);
        double dx = dxold = Math.abs(x2 - x1);
        double f = func.apply(rts);
        double df = func.g(rts);
        for (int iter = 1; iter <= maxIter; ++iter) {
            if (((rts - xh) * df - f) * ((rts - xl) * df - f) > 0.0 || Math.abs(2.0 * f) > Math.abs(dxold * df)) {
                dxold = dx;
                dx = 0.5 * (xh - xl);
                rts = xl + dx;
                if (xl == rts) {
                    logger.info(String.format("Newton-Raphson finds the root after %d iterations: %.5g, error = %.5g", iter, rts, dx));
                    return rts;
                }
            } else {
                dxold = dx;
                double temp = rts;
                dx = f / df;
                if (temp == (rts -= dx)) {
                    logger.info(String.format("Newton-Raphson finds the root after %d iterations: %.5g, error = %.5g", iter, rts, dx));
                    return rts;
                }
            }
            if (iter % 10 == 0) {
                logger.info(String.format("Newton-Raphson: the root after %3d iterations: %.5g, error = %.5g", iter, rts, dx));
            }
            if (Math.abs(dx) < tol) {
                logger.info(String.format("Newton-Raphson finds the root after %d iterations: %.5g, error = %.5g", iter, rts, dx));
                return rts;
            }
            f = func.apply(rts);
            df = func.g(rts);
            if (f < 0.0) {
                xl = rts;
                continue;
            }
            xh = rts;
        }
        logger.error("Newton-Raphson exceeded the maximum number of iterations.");
        return rts;
    }
}

