/*
 * Decompiled with CFR 0.152.
 */
package smile.math.blas;

import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import org.bytedeco.javacpp.DoublePointer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.math.blas.Diag;
import smile.math.blas.Layout;
import smile.math.blas.Side;
import smile.math.blas.Transpose;
import smile.math.blas.UPLO;
import smile.math.blas.openblas.OpenBLAS;

public interface BLAS {
    public static final BLAS engine = BLAS.getInstance();

    public static BLAS getInstance() {
        BLAS mkl = BLAS.MKL();
        return mkl != null ? mkl : new OpenBLAS();
    }

    public static BLAS MKL() {
        Logger logger = LoggerFactory.getLogger(BLAS.class);
        try {
            Class<?> clazz = Class.forName("smile.math.blas.mkl.MKL");
            logger.info("smile-mkl module is available.");
            return (BLAS)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            logger.debug("Failed to create MKL instance: ", (Throwable)e);
            return null;
        }
    }

    public double asum(int var1, double[] var2, int var3);

    public float asum(int var1, float[] var2, int var3);

    default public double asum(double[] x) {
        return this.asum(x.length, x, 1);
    }

    default public float asum(float[] x) {
        return this.asum(x.length, x, 1);
    }

    public void axpy(int var1, double var2, double[] var4, int var5, double[] var6, int var7);

    public void axpy(int var1, float var2, float[] var3, int var4, float[] var5, int var6);

    default public void axpy(double alpha, double[] x, double[] y) {
        this.axpy(x.length, alpha, x, 1, y, 1);
    }

    default public void axpy(float alpha, float[] x, float[] y) {
        this.axpy(x.length, alpha, x, 1, y, 1);
    }

    public double dot(int var1, double[] var2, int var3, double[] var4, int var5);

    public float dot(int var1, float[] var2, int var3, float[] var4, int var5);

    default public double dot(double[] x, double[] y) {
        return this.dot(x.length, x, 1, y, 1);
    }

    default public float dot(float[] x, float[] y) {
        return this.dot(x.length, x, 1, y, 1);
    }

    public double nrm2(int var1, double[] var2, int var3);

    public float nrm2(int var1, float[] var2, int var3);

    default public double nrm2(double[] x) {
        return this.nrm2(x.length, x, 1);
    }

    default public float nrm2(float[] x) {
        return this.nrm2(x.length, x, 1);
    }

    public void scal(int var1, double var2, double[] var4, int var5);

    public void scal(int var1, float var2, float[] var3, int var4);

    default public void scal(double alpha, double[] x) {
        this.scal(x.length, alpha, x, 1);
    }

    default public void scal(float alpha, float[] x) {
        this.scal(x.length, alpha, x, 1);
    }

    public void swap(int var1, double[] var2, int var3, double[] var4, int var5);

    public void swap(int var1, float[] var2, int var3, float[] var4, int var5);

    default public void swap(double[] x, double[] y) {
        this.swap(x.length, x, 1, y, 1);
    }

    default public void swap(float[] x, float[] y) {
        this.swap(x.length, x, 1, y, 1);
    }

    public long iamax(int var1, double[] var2, int var3);

    public long iamax(int var1, float[] var2, int var3);

    default public long iamax(double[] x) {
        return this.iamax(x.length, x, 1);
    }

    default public long iamax(float[] x) {
        return this.iamax(x.length, x, 1);
    }

    public void gemv(Layout var1, Transpose var2, int var3, int var4, double var5, double[] var7, int var8, double[] var9, int var10, double var11, double[] var13, int var14);

    public void gemv(Layout var1, Transpose var2, int var3, int var4, double var5, DoubleBuffer var7, int var8, DoubleBuffer var9, int var10, double var11, DoubleBuffer var13, int var14);

    public void gemv(Layout var1, Transpose var2, int var3, int var4, double var5, DoublePointer var7, int var8, DoublePointer var9, int var10, double var11, DoublePointer var13, int var14);

    public void gemv(Layout var1, Transpose var2, int var3, int var4, float var5, float[] var6, int var7, float[] var8, int var9, float var10, float[] var11, int var12);

    public void gemv(Layout var1, Transpose var2, int var3, int var4, float var5, FloatBuffer var6, int var7, FloatBuffer var8, int var9, float var10, FloatBuffer var11, int var12);

    public void symv(Layout var1, UPLO var2, int var3, double var4, double[] var6, int var7, double[] var8, int var9, double var10, double[] var12, int var13);

    public void symv(Layout var1, UPLO var2, int var3, double var4, DoubleBuffer var6, int var7, DoubleBuffer var8, int var9, double var10, DoubleBuffer var12, int var13);

    public void symv(Layout var1, UPLO var2, int var3, double var4, DoublePointer var6, int var7, DoublePointer var8, int var9, double var10, DoublePointer var12, int var13);

    public void symv(Layout var1, UPLO var2, int var3, float var4, float[] var5, int var6, float[] var7, int var8, float var9, float[] var10, int var11);

    public void symv(Layout var1, UPLO var2, int var3, float var4, FloatBuffer var5, int var6, FloatBuffer var7, int var8, float var9, FloatBuffer var10, int var11);

    public void spmv(Layout var1, UPLO var2, int var3, double var4, double[] var6, double[] var7, int var8, double var9, double[] var11, int var12);

    public void spmv(Layout var1, UPLO var2, int var3, double var4, DoubleBuffer var6, DoubleBuffer var7, int var8, double var9, DoubleBuffer var11, int var12);

    public void spmv(Layout var1, UPLO var2, int var3, float var4, float[] var5, float[] var6, int var7, float var8, float[] var9, int var10);

    public void spmv(Layout var1, UPLO var2, int var3, float var4, FloatBuffer var5, FloatBuffer var6, int var7, float var8, FloatBuffer var9, int var10);

    public void trmv(Layout var1, UPLO var2, Transpose var3, Diag var4, int var5, double[] var6, int var7, double[] var8, int var9);

    public void trmv(Layout var1, UPLO var2, Transpose var3, Diag var4, int var5, DoubleBuffer var6, int var7, DoubleBuffer var8, int var9);

    public void trmv(Layout var1, UPLO var2, Transpose var3, Diag var4, int var5, DoublePointer var6, int var7, DoublePointer var8, int var9);

    public void trmv(Layout var1, UPLO var2, Transpose var3, Diag var4, int var5, float[] var6, int var7, float[] var8, int var9);

    public void trmv(Layout var1, UPLO var2, Transpose var3, Diag var4, int var5, FloatBuffer var6, int var7, FloatBuffer var8, int var9);

    public void tpmv(Layout var1, UPLO var2, Transpose var3, Diag var4, int var5, double[] var6, double[] var7, int var8);

    public void tpmv(Layout var1, UPLO var2, Transpose var3, Diag var4, int var5, DoubleBuffer var6, DoubleBuffer var7, int var8);

    public void tpmv(Layout var1, UPLO var2, Transpose var3, Diag var4, int var5, float[] var6, float[] var7, int var8);

    public void tpmv(Layout var1, UPLO var2, Transpose var3, Diag var4, int var5, FloatBuffer var6, FloatBuffer var7, int var8);

    public void gbmv(Layout var1, Transpose var2, int var3, int var4, int var5, int var6, double var7, double[] var9, int var10, double[] var11, int var12, double var13, double[] var15, int var16);

    public void gbmv(Layout var1, Transpose var2, int var3, int var4, int var5, int var6, double var7, DoubleBuffer var9, int var10, DoubleBuffer var11, int var12, double var13, DoubleBuffer var15, int var16);

    public void gbmv(Layout var1, Transpose var2, int var3, int var4, int var5, int var6, float var7, float[] var8, int var9, float[] var10, int var11, float var12, float[] var13, int var14);

    public void gbmv(Layout var1, Transpose var2, int var3, int var4, int var5, int var6, float var7, FloatBuffer var8, int var9, FloatBuffer var10, int var11, float var12, FloatBuffer var13, int var14);

    public void sbmv(Layout var1, UPLO var2, int var3, int var4, double var5, double[] var7, int var8, double[] var9, int var10, double var11, double[] var13, int var14);

    public void sbmv(Layout var1, UPLO var2, int var3, int var4, double var5, DoubleBuffer var7, int var8, DoubleBuffer var9, int var10, double var11, DoubleBuffer var13, int var14);

    public void sbmv(Layout var1, UPLO var2, int var3, int var4, float var5, float[] var6, int var7, float[] var8, int var9, float var10, float[] var11, int var12);

    public void sbmv(Layout var1, UPLO var2, int var3, int var4, float var5, FloatBuffer var6, int var7, FloatBuffer var8, int var9, float var10, FloatBuffer var11, int var12);

    public void ger(Layout var1, int var2, int var3, double var4, double[] var6, int var7, double[] var8, int var9, double[] var10, int var11);

    public void ger(Layout var1, int var2, int var3, double var4, DoubleBuffer var6, int var7, DoubleBuffer var8, int var9, DoubleBuffer var10, int var11);

    public void ger(Layout var1, int var2, int var3, double var4, DoublePointer var6, int var7, DoublePointer var8, int var9, DoublePointer var10, int var11);

    public void ger(Layout var1, int var2, int var3, float var4, float[] var5, int var6, float[] var7, int var8, float[] var9, int var10);

    public void ger(Layout var1, int var2, int var3, float var4, FloatBuffer var5, int var6, FloatBuffer var7, int var8, FloatBuffer var9, int var10);

    public void syr(Layout var1, UPLO var2, int var3, double var4, double[] var6, int var7, double[] var8, int var9);

    public void syr(Layout var1, UPLO var2, int var3, double var4, DoubleBuffer var6, int var7, DoubleBuffer var8, int var9);

    public void syr(Layout var1, UPLO var2, int var3, double var4, DoublePointer var6, int var7, DoublePointer var8, int var9);

    public void syr(Layout var1, UPLO var2, int var3, float var4, float[] var5, int var6, float[] var7, int var8);

    public void syr(Layout var1, UPLO var2, int var3, float var4, FloatBuffer var5, int var6, FloatBuffer var7, int var8);

    public void spr(Layout var1, UPLO var2, int var3, double var4, double[] var6, int var7, double[] var8);

    public void spr(Layout var1, UPLO var2, int var3, double var4, DoubleBuffer var6, int var7, DoubleBuffer var8);

    public void spr(Layout var1, UPLO var2, int var3, float var4, float[] var5, int var6, float[] var7);

    public void spr(Layout var1, UPLO var2, int var3, float var4, FloatBuffer var5, int var6, FloatBuffer var7);

    public void gemm(Layout var1, Transpose var2, Transpose var3, int var4, int var5, int var6, double var7, double[] var9, int var10, double[] var11, int var12, double var13, double[] var15, int var16);

    public void gemm(Layout var1, Transpose var2, Transpose var3, int var4, int var5, int var6, double var7, DoubleBuffer var9, int var10, DoubleBuffer var11, int var12, double var13, DoubleBuffer var15, int var16);

    public void gemm(Layout var1, Transpose var2, Transpose var3, int var4, int var5, int var6, double var7, DoublePointer var9, int var10, DoublePointer var11, int var12, double var13, DoublePointer var15, int var16);

    public void gemm(Layout var1, Transpose var2, Transpose var3, int var4, int var5, int var6, float var7, float[] var8, int var9, float[] var10, int var11, float var12, float[] var13, int var14);

    public void gemm(Layout var1, Transpose var2, Transpose var3, int var4, int var5, int var6, float var7, FloatBuffer var8, int var9, FloatBuffer var10, int var11, float var12, FloatBuffer var13, int var14);

    public void symm(Layout var1, Side var2, UPLO var3, int var4, int var5, double var6, double[] var8, int var9, double[] var10, int var11, double var12, double[] var14, int var15);

    public void symm(Layout var1, Side var2, UPLO var3, int var4, int var5, double var6, DoubleBuffer var8, int var9, DoubleBuffer var10, int var11, double var12, DoubleBuffer var14, int var15);

    public void symm(Layout var1, Side var2, UPLO var3, int var4, int var5, double var6, DoublePointer var8, int var9, DoublePointer var10, int var11, double var12, DoublePointer var14, int var15);

    public void symm(Layout var1, Side var2, UPLO var3, int var4, int var5, float var6, float[] var7, int var8, float[] var9, int var10, float var11, float[] var12, int var13);

    public void symm(Layout var1, Side var2, UPLO var3, int var4, int var5, float var6, FloatBuffer var7, int var8, FloatBuffer var9, int var10, float var11, FloatBuffer var12, int var13);
}

