/*
 * Decompiled with CFR 0.152.
 */
package smile.math.matrix.fp32;

import java.util.Arrays;
import org.bytedeco.arpackng.global.arpack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.math.matrix.fp32.IMatrix;
import smile.math.matrix.fp32.Matrix;

public class ARPACK {
    private static final Logger logger = LoggerFactory.getLogger(ARPACK.class);

    private ARPACK() {
    }

    public static Matrix.EVD syev(IMatrix A, SymmOption which, int nev) {
        return ARPACK.syev(A, which, nev, Math.min(3 * nev, A.nrow()), 1.0E-6f);
    }

    public static Matrix.EVD syev(IMatrix A, SymmOption which, int nev, int ncv, float tol) {
        if (A.nrow() != A.ncol()) {
            throw new IllegalArgumentException(String.format("Matrix is not square: %d x %d", A.nrow(), A.ncol()));
        }
        int n = A.nrow();
        if (nev <= 0 || nev >= n) {
            throw new IllegalArgumentException("Invalid NEV: " + nev);
        }
        int[] ido = new int[]{0};
        int[] info = new int[]{0};
        byte[] bmat = new byte[]{73};
        String swhich = which.name();
        byte[] bwhich = swhich.getBytes();
        int[] iparam = new int[11];
        iparam[0] = 1;
        iparam[2] = 10 * n;
        iparam[6] = 1;
        int[] ipntr = new int[11];
        float[] workd = new float[3 * n];
        float[] workl = new float[ncv * (ncv + 8)];
        float[] resid = new float[n];
        float[] V = new float[n * ncv];
        int ldv = n;
        do {
            arpack.ssaupd_c((int[])ido, (byte[])bmat, (int)n, (byte[])bwhich, (int)nev, (float)tol, (float[])resid, (int)ncv, (float[])V, (int)ldv, (int[])iparam, (int[])ipntr, (float[])workd, (float[])workl, (int)workl.length, (int[])info);
            if (ido[0] != -1 && ido[0] != 1) continue;
            A.mv(workd, ipntr[0] - 1, ipntr[1] - 1);
        } while (ido[0] == -1 || ido[0] == 1);
        if (info[0] < 0) {
            throw new IllegalStateException("ARPACK DSAUPD error code: " + info[0]);
        }
        info[0] = 0;
        byte[] howmny = new byte[]{65};
        float[] d = new float[ncv * 2];
        int[] select = new int[ncv];
        float sigma = 0.0f;
        int rvec = 1;
        arpack.sseupd_c((int)rvec, (byte[])howmny, (int[])select, (float[])d, (float[])V, (int)ldv, (float)sigma, (byte[])bmat, (int)n, (byte[])bwhich, (int)nev, (float)tol, (float[])resid, (int)ncv, (float[])V, (int)ldv, (int[])iparam, (int[])ipntr, (float[])workd, (float[])workl, (int)workl.length, (int[])info);
        if (info[0] != 0) {
            String error = "ARPACK DSEUPD error code: " + info[0];
            if (info[0] == 1) {
                error = "ARPACK DSEUPD error: Maximum number of iterations reached.";
            } else if (info[0] == 3) {
                error = "ARPACK DSEUPD error: No shifts could be applied during implicit Arnoldi update, try increasing NCV.";
            }
            throw new IllegalStateException(error);
        }
        nev = iparam[4];
        logger.info("ARPACK computed " + nev + " eigenvalues");
        d = Arrays.copyOfRange(d, 0, nev);
        V = Arrays.copyOfRange(V, 0, n * nev);
        Matrix.EVD eig = new Matrix.EVD(d, new Matrix(n, nev, ldv, V));
        return eig.sort();
    }

    public static Matrix.EVD eigen(IMatrix A, AsymmOption which, int nev) {
        return ARPACK.eigen(A, which, nev, Math.min(3 * nev, A.nrow()), 1.0E-6f);
    }

    public static Matrix.EVD eigen(IMatrix A, AsymmOption which, int nev, int ncv, float tol) {
        if (A.nrow() != A.ncol()) {
            throw new IllegalArgumentException(String.format("Matrix is not square: %d x %d", A.nrow(), A.ncol()));
        }
        int n = A.nrow();
        if (nev <= 0 || nev >= n) {
            throw new IllegalArgumentException("Invalid NEV: " + nev);
        }
        int[] ido = new int[]{0};
        int[] info = new int[]{0};
        byte[] bmat = new byte[]{73};
        String swhich = which.name();
        byte[] bwhich = new byte[]{(byte)swhich.charAt(0), (byte)swhich.charAt(1)};
        int[] iparam = new int[11];
        iparam[0] = 1;
        iparam[2] = 10 * n;
        iparam[6] = 1;
        int[] ipntr = new int[14];
        float[] workd = new float[3 * n];
        float[] workev = new float[3 * ncv];
        float[] workl = new float[3 * ncv * ncv + 6 * ncv];
        float[] resid = new float[n];
        float[] V = new float[n * ncv];
        int ldv = n;
        do {
            arpack.snaupd_c((int[])ido, (byte[])bmat, (int)n, (byte[])bwhich, (int)nev, (float)tol, (float[])resid, (int)ncv, (float[])V, (int)ldv, (int[])iparam, (int[])ipntr, (float[])workd, (float[])workl, (int)workl.length, (int[])info);
            if (ido[0] != -1 && ido[0] != 1) continue;
            A.mv(workd, ipntr[0] - 1, ipntr[1] - 1);
        } while (ido[0] == -1 || ido[0] == 1);
        if (info[0] < 0) {
            throw new IllegalStateException("ARPACK DNAUPD error code: " + info[0]);
        }
        info[0] = 0;
        byte[] howmny = new byte[]{65};
        float[] wr = new float[ncv * 2];
        float[] wi = new float[ncv * 2];
        int[] select = new int[ncv];
        float sigmar = 0.0f;
        float sigmai = 0.0f;
        int rvec = 1;
        arpack.sneupd_c((int)rvec, (byte[])howmny, (int[])select, (float[])wr, (float[])wi, (float[])V, (int)ldv, (float)sigmar, (float)sigmai, (float[])workev, (byte[])bmat, (int)n, (byte[])bwhich, (int)nev, (float)tol, (float[])resid, (int)ncv, (float[])V, (int)ldv, (int[])iparam, (int[])ipntr, (float[])workd, (float[])workl, (int)workl.length, (int[])info);
        if (info[0] != 0) {
            String error = "ARPACK DNEUPD error code: " + info[0];
            if (info[0] == 1) {
                error = "ARPACK DNEUPD error: Maximum number of iterations reached.";
            } else if (info[0] == 3) {
                error = "ARPACK DNEUPD error: No shifts could be applied during implicit Arnoldi update, try increasing NCV.";
            }
            throw new IllegalStateException(error);
        }
        nev = iparam[4];
        logger.info("ARPACK computed " + nev + " eigenvalues");
        wr = Arrays.copyOfRange(wr, 0, nev);
        wi = Arrays.copyOfRange(wi, 0, nev);
        V = Arrays.copyOfRange(V, 0, n * nev);
        Matrix.EVD eig = new Matrix.EVD(wr, wi, null, new Matrix(n, nev, ldv, V));
        return eig.sort();
    }

    public static Matrix.SVD svd(IMatrix A, int k) {
        return ARPACK.svd(A, k, Math.min(3 * k, Math.min(A.nrow(), A.ncol())), 1.0E-6f);
    }

    public static Matrix.SVD svd(IMatrix A, int k, int ncv, float tol) {
        int m = A.nrow();
        int n = A.ncol();
        IMatrix ata = A.square();
        Matrix.EVD eigen = ARPACK.syev(ata, SymmOption.LM, k, ncv, tol);
        float[] s = eigen.wr;
        for (int i = 0; i < s.length; ++i) {
            s[i] = (float)Math.sqrt(s[i]);
        }
        if (m >= n) {
            Matrix V = eigen.Vr;
            float[] Av = new float[m];
            float[] v = new float[n];
            Matrix U = new Matrix(m, s.length);
            for (int j = 0; j < s.length; ++j) {
                int i;
                for (i = 0; i < n; ++i) {
                    v[i] = V.get(i, j);
                }
                A.mv(v, Av);
                for (i = 0; i < m; ++i) {
                    U.set(i, j, Av[i] / s[j]);
                }
            }
            return new Matrix.SVD(s, U, V);
        }
        Matrix U = eigen.Vr;
        float[] Atu = new float[n];
        float[] u = new float[m];
        Matrix V = new Matrix(n, s.length);
        for (int j = 0; j < s.length; ++j) {
            int i;
            for (i = 0; i < m; ++i) {
                u[i] = U.get(i, j);
            }
            A.tv(u, Atu);
            for (i = 0; i < n; ++i) {
                V.set(i, j, Atu[i] / s[j]);
            }
        }
        return new Matrix.SVD(s, U, V);
    }

    public static enum SymmOption {
        LA,
        SA,
        LM,
        SM,
        BE;

    }

    public static enum AsymmOption {
        LM,
        SM,
        LR,
        SR,
        LI,
        SI;

    }
}

