/*
 * Decompiled with CFR 0.152.
 */
package smile.neighbor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import smile.math.distance.Metric;
import smile.neighbor.Neighbor;
import smile.neighbor.RNNSearch;

public class BKTree<K, V>
implements RNNSearch<K, V>,
Serializable {
    private static final long serialVersionUID = 2L;
    private Node root;
    private final Metric<K> distance;
    private int count = 0;

    public BKTree(Metric<K> distance) {
        this.distance = distance;
    }

    public static <T> BKTree<T, T> of(T[] data, Metric<T> distance) {
        BKTree<T, T> tree = new BKTree<T, T>(distance);
        for (T key : data) {
            tree.add(key, key);
        }
        return tree;
    }

    public static <T> BKTree<T, T> of(List<T> data, Metric<T> distance) {
        BKTree<T, T> tree = new BKTree<T, T>(distance);
        for (T key : data) {
            tree.add(key, key);
        }
        return tree;
    }

    public String toString() {
        return String.format("BK-Tree (%s)", this.distance);
    }

    public void add(K key, V value) {
        if (this.root == null) {
            this.root = new Node(this.count++, key, value);
        } else {
            this.root.add(key, value);
        }
    }

    public void add(Map<K, V> data) {
        for (Map.Entry<K, V> entry : data.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void search(K q, double radius, List<Neighbor<K, V>> neighbors) {
        if (radius <= 0.0 || radius != (double)((int)radius)) {
            throw new IllegalArgumentException("The parameter radius has to be an integer: " + radius);
        }
        this.root.search(q, (int)radius, neighbors);
    }

    public void search(K q, int radius, List<Neighbor<K, V>> neighbors) {
        this.root.search(q, radius, neighbors);
    }

    class Node
    implements Serializable {
        K key;
        V value;
        int index;
        ArrayList<Node> children;

        Node(int index, K key, V value) {
            this.index = index;
            this.key = key;
            this.value = value;
        }

        private void add(K key, V value) {
            int d = (int)BKTree.this.distance.d(this.key, key);
            if (d == 0) {
                return;
            }
            if (this.children == null) {
                this.children = new ArrayList();
            }
            while (this.children.size() <= d) {
                this.children.add(null);
            }
            Node child = this.children.get(d);
            if (child == null) {
                Node node = new Node(BKTree.this.count++, key, value);
                this.children.set(d, node);
            } else {
                child.add(key, value);
            }
        }

        private void search(K q, int k, List<Neighbor<K, V>> neighbors) {
            int d = (int)BKTree.this.distance.d(this.key, q);
            if (d <= k && this.key != q) {
                neighbors.add(new Neighbor(this.key, this.value, this.index, d));
            }
            if (this.children != null) {
                int start = Math.max(1, d - k);
                int end = Math.min(this.children.size(), d + k + 1);
                for (int i = start; i < end; ++i) {
                    Node child = this.children.get(i);
                    if (child == null) continue;
                    child.search(q, k, neighbors);
                }
            }
        }
    }
}

