/*
 * Decompiled with CFR 0.152.
 */
package smile.stat.distribution;

import smile.math.special.Beta;
import smile.math.special.Gamma;
import smile.stat.distribution.AbstractDistribution;

public class FDistribution
extends AbstractDistribution {
    private static final long serialVersionUID = 2L;
    public final int nu1;
    public final int nu2;
    private final double fac;

    public FDistribution(int nu1, int nu2) {
        if (nu1 < 1) {
            throw new IllegalArgumentException("Invalid nu1 = " + nu1);
        }
        if (nu2 < 1) {
            throw new IllegalArgumentException("Invalid nu2 = " + nu2);
        }
        this.nu1 = nu1;
        this.nu2 = nu2;
        this.fac = 0.5 * ((double)nu1 * Math.log(nu1) + (double)nu2 * Math.log(nu2)) + Gamma.lgamma(0.5 * (double)(nu1 + nu2)) - Gamma.lgamma(0.5 * (double)nu1) - Gamma.lgamma(0.5 * (double)nu2);
    }

    @Override
    public int length() {
        return 2;
    }

    @Override
    public double mean() {
        return (double)this.nu2 / ((double)this.nu2 - 2.0);
    }

    @Override
    public double variance() {
        return 2.0 * (double)this.nu2 * (double)this.nu2 * (double)(this.nu1 + this.nu2 - 2) / (double)(this.nu1 * (this.nu2 - 2) * (this.nu2 - 2) * (this.nu2 - 4));
    }

    @Override
    public double entropy() {
        throw new UnsupportedOperationException("F-distribution does not support entropy()");
    }

    public String toString() {
        return String.format("F-distribution(%d, %d)", this.nu1, this.nu2);
    }

    @Override
    public double rand() {
        return this.inverseTransformSampling();
    }

    @Override
    public double p(double x) {
        if (x <= 0.0) {
            throw new IllegalArgumentException("Invalid x: " + x);
        }
        return Math.exp((0.5 * (double)this.nu1 - 1.0) * Math.log(x) - 0.5 * (double)(this.nu1 + this.nu2) * Math.log((double)this.nu2 + (double)this.nu1 * x) + this.fac);
    }

    @Override
    public double logp(double x) {
        if (x <= 0.0) {
            throw new IllegalArgumentException("Invalid x: " + x);
        }
        return (0.5 * (double)this.nu1 - 1.0) * Math.log(x) - 0.5 * (double)(this.nu1 + this.nu2) * Math.log((double)this.nu2 + (double)this.nu1 * x) + this.fac;
    }

    @Override
    public double cdf(double x) {
        if (x < 0.0) {
            throw new IllegalArgumentException("Invalid x: " + x);
        }
        return Beta.regularizedIncompleteBetaFunction(0.5 * (double)this.nu1, 0.5 * (double)this.nu2, (double)this.nu1 * x / ((double)this.nu2 + (double)this.nu1 * x));
    }

    @Override
    public double quantile(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("Invalid p: " + p);
        }
        double x = Beta.inverseRegularizedIncompleteBetaFunction(0.5 * (double)this.nu1, 0.5 * (double)this.nu2, p);
        return (double)this.nu2 * x / ((double)this.nu1 * (1.0 - x));
    }
}

