/*
 * Decompiled with CFR 0.152.
 */
package smile.stat.distribution;

import smile.math.MathEx;
import smile.math.special.Gamma;
import smile.stat.distribution.DiscreteDistribution;
import smile.stat.distribution.DiscreteExponentialFamily;
import smile.stat.distribution.DiscreteMixture;

public class PoissonDistribution
extends DiscreteDistribution
implements DiscreteExponentialFamily {
    private static final long serialVersionUID = 2L;
    public final double lambda;
    private final double entropy;
    private RandomNumberGenerator rng;

    public PoissonDistribution(double lambda) {
        if (lambda < 0.0) {
            throw new IllegalArgumentException("Invalid lambda: " + lambda);
        }
        this.lambda = lambda;
        this.entropy = (Math.log(17.079468445347132) + Math.log(lambda)) / 2.0 - 1.0 / (12.0 * lambda) - 1.0 / (24.0 * lambda * lambda) - 19.0 / (360.0 * lambda * lambda * lambda);
    }

    public static PoissonDistribution fit(int[] data) {
        for (int datum : data) {
            if (datum >= 0) continue;
            throw new IllegalArgumentException("Samples contain negative values.");
        }
        double lambda = MathEx.mean(data);
        return new PoissonDistribution(lambda);
    }

    @Override
    public int length() {
        return 1;
    }

    @Override
    public double mean() {
        return this.lambda;
    }

    @Override
    public double variance() {
        return this.lambda;
    }

    @Override
    public double sd() {
        return Math.sqrt(this.lambda);
    }

    @Override
    public double entropy() {
        return this.entropy;
    }

    public String toString() {
        return String.format("Poisson Distribution(%.4f)", this.lambda);
    }

    @Override
    public double p(int k) {
        if (k < 0) {
            return 0.0;
        }
        return Math.pow(this.lambda, k) * Math.exp(-this.lambda) / MathEx.factorial(k);
    }

    @Override
    public double logp(int k) {
        if (k < 0) {
            return Double.NEGATIVE_INFINITY;
        }
        return (double)k * Math.log(this.lambda) - this.lambda - MathEx.lfactorial(k);
    }

    @Override
    public double cdf(double k) {
        if (this.lambda == 0.0) {
            if (k >= 0.0) {
                return 1.0;
            }
            return 0.0;
        }
        if (k < 0.0) {
            return 0.0;
        }
        return Gamma.regularizedUpperIncompleteGamma(Math.floor(k + 1.0), this.lambda);
    }

    @Override
    public double quantile(double p) {
        int nu;
        int nl;
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("Invalid p: " + p);
        }
        if (p < Math.exp(-this.lambda)) {
            return 0.0;
        }
        int n = (int)Math.max(Math.sqrt(this.lambda), 5.0);
        int inc = 1;
        if (p < this.cdf(n)) {
            do {
                n = Math.max(n - inc, 0);
                inc *= 2;
            } while (p < this.cdf(n) && n > 0);
            nl = n;
            nu = n + inc / 2;
        } else {
            while (p > this.cdf(n += (inc *= 2))) {
            }
            nu = n;
            nl = n - inc / 2;
        }
        return this.quantile(p, nl, nu);
    }

    @Override
    public DiscreteMixture.Component M(int[] x, double[] posteriori) {
        double alpha = 0.0;
        double mean = 0.0;
        for (int i = 0; i < x.length; ++i) {
            alpha += posteriori[i];
            mean += (double)x[i] * posteriori[i];
        }
        return new DiscreteMixture.Component(alpha, new PoissonDistribution(mean /= alpha));
    }

    @Override
    public double rand() {
        if (this.lambda > 2.0E9) {
            throw new IllegalArgumentException("Too large lambda for random number generator.");
        }
        if (this.lambda == 0.0) {
            return 0.0;
        }
        if (this.lambda < 1.0E-6) {
            return PoissonDistribution.tinyLambdaRand(this.lambda);
        }
        if (this.rng == null) {
            this.rng = this.lambda < 20.0 ? new ModeSearch() : new Patchwork();
        }
        return this.rng.rand();
    }

    static int tinyLambdaRand(double lambda) {
        double d = Math.sqrt(lambda);
        if (MathEx.random() >= d) {
            return 0;
        }
        double r = MathEx.random() * d;
        if (r > lambda * (1.0 - lambda)) {
            return 0;
        }
        if (r > 0.5 * lambda * lambda * (1.0 - lambda)) {
            return 1;
        }
        return 2;
    }

    private static interface RandomNumberGenerator {
        public int rand();
    }

    private class ModeSearch
    implements RandomNumberGenerator {
        private final double f0Mode;
        private final int upperBound;

        ModeSearch() {
            int mode = (int)PoissonDistribution.this.lambda;
            this.upperBound = (int)Math.floor(PoissonDistribution.this.lambda + 0.5 + 7.0 * (Math.sqrt(PoissonDistribution.this.lambda + PoissonDistribution.this.lambda + 1.0) + 1.5));
            this.f0Mode = Math.exp((double)mode * Math.log(PoissonDistribution.this.lambda) - PoissonDistribution.this.lambda - MathEx.lfactorial(mode));
        }

        @Override
        public int rand() {
            int mode = (int)PoissonDistribution.this.lambda;
            block0: while (true) {
                int x;
                double d;
                double d2;
                double r = MathEx.random();
                r -= this.f0Mode;
                if (d2 <= 0.0) {
                    return mode;
                }
                double c = d = this.f0Mode;
                for (int i = 1; i <= mode; ++i) {
                    double d3;
                    double d4;
                    x = mode - i;
                    r *= PoissonDistribution.this.lambda;
                    d *= PoissonDistribution.this.lambda;
                    r -= (c *= (double)(x + 1));
                    if (d4 <= 0.0) {
                        return x;
                    }
                    x = mode + i;
                    r *= (double)x;
                    c *= (double)x;
                    r -= (d *= PoissonDistribution.this.lambda);
                    if (!(d3 <= 0.0)) continue;
                    return x;
                }
                x = mode + mode + 1;
                while (true) {
                    double d5;
                    if (x > this.upperBound) continue block0;
                    r *= (double)x;
                    r -= (d *= PoissonDistribution.this.lambda);
                    if (d5 <= 0.0) {
                        return x;
                    }
                    ++x;
                }
                break;
            }
        }
    }

    private class Patchwork
    implements RandomNumberGenerator {
        private final int k1;
        private final int k2;
        private final int k4;
        private final int k5;
        private final double dl;
        private final double dr;
        private final double r1;
        private final double r2;
        private final double r4;
        private final double r5;
        private final double ll;
        private final double rr;
        private final double l_my;
        private final double c_pm;
        private final double f1;
        private final double f2;
        private final double f4;
        private final double f5;
        private final double p1;
        private final double p2;
        private final double p3;
        private final double p4;
        private final double p5;
        private final double p6;

        Patchwork() {
            int mode = (int)PoissonDistribution.this.lambda;
            double Ds = Math.sqrt(PoissonDistribution.this.lambda + 0.25);
            this.k2 = (int)Math.ceil(PoissonDistribution.this.lambda - 0.5 - Ds);
            this.k4 = (int)(PoissonDistribution.this.lambda - 0.5 + Ds);
            this.k1 = this.k2 + this.k2 - mode + 1;
            this.k5 = this.k4 + this.k4 - mode;
            this.dl = this.k2 - this.k1;
            this.dr = this.k5 - this.k4;
            this.r1 = PoissonDistribution.this.lambda / (double)this.k1;
            this.r2 = PoissonDistribution.this.lambda / (double)this.k2;
            this.r4 = PoissonDistribution.this.lambda / (double)(this.k4 + 1);
            this.r5 = PoissonDistribution.this.lambda / (double)(this.k5 + 1);
            this.ll = Math.log(this.r1);
            this.rr = -Math.log(this.r5);
            this.l_my = Math.log(PoissonDistribution.this.lambda);
            this.c_pm = (double)mode * this.l_my - MathEx.lfactorial(mode);
            this.f2 = this.f(this.k2, this.l_my, this.c_pm);
            this.f4 = this.f(this.k4, this.l_my, this.c_pm);
            this.f1 = this.f(this.k1, this.l_my, this.c_pm);
            this.f5 = this.f(this.k5, this.l_my, this.c_pm);
            this.p1 = this.f2 * (this.dl + 1.0);
            this.p2 = this.f2 * this.dl + this.p1;
            this.p3 = this.f4 * (this.dr + 1.0) + this.p2;
            this.p4 = this.f4 * this.dr + this.p3;
            this.p5 = this.f1 / this.ll + this.p4;
            this.p6 = this.f5 / this.rr + this.p5;
        }

        @Override
        public int rand() {
            int X;
            while (true) {
                int Y;
                int Dk;
                double W;
                double V;
                double d;
                double U = MathEx.random() * this.p6;
                if (d < this.p2) {
                    double d2;
                    double d3;
                    double d4;
                    V = U - this.p1;
                    if (d4 < 0.0) {
                        return this.k2 + (int)(U / this.f2);
                    }
                    W = V / this.dl;
                    if (d3 < this.f1) {
                        return this.k1 + (int)(V / this.f1);
                    }
                    Dk = (int)(this.dl * MathEx.random()) + 1;
                    if (W <= this.f2 - (double)Dk * (this.f2 - this.f2 / this.r2)) {
                        return this.k2 - Dk;
                    }
                    V = this.f2 + this.f2 - W;
                    if (d2 < 1.0) {
                        Y = this.k2 + Dk;
                        if (V <= this.f2 + (double)Dk * (1.0 - this.f2) / (this.dl + 1.0)) {
                            return Y;
                        }
                        if (V <= this.f(Y, this.l_my, this.c_pm)) {
                            return Y;
                        }
                    }
                    X = this.k2 - Dk;
                } else if (U < this.p4) {
                    double d5;
                    double d6;
                    double d7;
                    V = U - this.p3;
                    if (d7 < 0.0) {
                        return this.k4 - (int)((U - this.p2) / this.f4);
                    }
                    W = V / this.dr;
                    if (d6 < this.f5) {
                        return this.k5 - (int)(V / this.f5);
                    }
                    Dk = (int)(this.dr * MathEx.random()) + 1;
                    if (W <= this.f4 - (double)Dk * (this.f4 - this.f4 * this.r4)) {
                        return this.k4 + Dk;
                    }
                    V = this.f4 + this.f4 - W;
                    if (d5 < 1.0) {
                        Y = this.k4 - Dk;
                        if (V <= this.f4 + (double)Dk * (1.0 - this.f4) / this.dr) {
                            return Y;
                        }
                        if (V <= this.f(Y, this.l_my, this.c_pm)) {
                            return Y;
                        }
                    }
                    X = this.k4 + Dk;
                } else {
                    W = MathEx.random();
                    if (U < this.p5) {
                        Dk = (int)(1.0 - Math.log(W) / this.ll);
                        X = this.k1 - Dk;
                        if ((long)X < 0L) continue;
                        if ((W *= (U - this.p4) * this.ll) <= this.f1 - (double)Dk * (this.f1 - this.f1 / this.r1)) {
                            return X;
                        }
                    } else {
                        Dk = (int)(1.0 - Math.log(W) / this.rr);
                        X = this.k5 + Dk;
                        if ((W *= (U - this.p5) * this.rr) <= this.f5 - (double)Dk * (this.f5 - this.f5 * this.r5)) {
                            return X;
                        }
                    }
                }
                if (Math.log(W) <= (double)X * this.l_my - MathEx.lfactorial(X) - this.c_pm) break;
            }
            return X;
        }

        private double f(int k, double l_nu, double c_pm) {
            return Math.exp((double)k * l_nu - MathEx.lfactorial(k) - c_pm);
        }
    }
}

