/*
 * Decompiled with CFR 0.152.
 */
package smile.data.type;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import smile.data.type.DataType;

public class DateTimeType
implements DataType {
    static DateTimeType instance = new DateTimeType();
    private final String pattern;
    private final DateTimeFormatter formatter;

    DateTimeType() {
        this.pattern = "uuuu-MM-dd'T'HH:mm[:ss]";
        this.formatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
    }

    public DateTimeType(String pattern) {
        this.pattern = pattern;
        this.formatter = DateTimeFormatter.ofPattern(pattern);
    }

    @Override
    public String name() {
        return String.format("DateTime[%s]", this.pattern);
    }

    @Override
    public DataType.ID id() {
        return DataType.ID.DateTime;
    }

    public String toString() {
        return "DateTime";
    }

    @Override
    public String toString(Object o) {
        return this.formatter.format((LocalDateTime)o);
    }

    @Override
    public LocalDateTime valueOf(String s) {
        return LocalDateTime.parse(s, this.formatter);
    }

    public boolean equals(Object o) {
        return o instanceof DateTimeType;
    }
}

