/*
 * Decompiled with CFR 0.152.
 */
package smile.stat.distribution;

import smile.math.MathEx;
import smile.stat.distribution.Distribution;

public abstract class AbstractDistribution
implements Distribution {
    protected double rejection(double pmax, double xmin, double xmax) {
        double y;
        double x;
        do {
            x = xmin + MathEx.random() * (xmax - xmin);
            y = MathEx.random() * pmax;
        } while (this.p(x) < y);
        return x;
    }

    protected double inverseTransformSampling() {
        double u = MathEx.random();
        return this.quantile(u);
    }

    protected double quantile(double p, double xmin, double xmax, double eps) {
        if (eps <= 0.0) {
            throw new IllegalArgumentException("Invalid epsilon: " + eps);
        }
        while (Math.abs(xmax - xmin) > eps) {
            double xmed = (xmax + xmin) / 2.0;
            if (this.cdf(xmed) > p) {
                xmax = xmed;
                continue;
            }
            xmin = xmed;
        }
        return xmin;
    }

    protected double quantile(double p, double xmin, double xmax) {
        return this.quantile(p, xmin, xmax, 1.0E-6);
    }
}

