/*
 * Decompiled with CFR 0.152.
 */
package smile.data.type;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import smile.data.type.DataType;

public class DateType
implements DataType {
    static DateType instance = new DateType();
    private final String pattern;
    private final DateTimeFormatter formatter;

    DateType() {
        this.pattern = "uuuu-MM-dd";
        this.formatter = DateTimeFormatter.ISO_LOCAL_DATE;
    }

    public DateType(String pattern) {
        this.pattern = pattern;
        this.formatter = DateTimeFormatter.ofPattern(pattern);
    }

    @Override
    public String name() {
        return String.format("Date[%s]", this.pattern);
    }

    @Override
    public DataType.ID id() {
        return DataType.ID.Date;
    }

    public String toString() {
        return "Date";
    }

    @Override
    public String toString(Object o) {
        return this.formatter.format((LocalDate)o);
    }

    @Override
    public LocalDate valueOf(String s) {
        return LocalDate.parse(s, this.formatter);
    }

    public boolean equals(Object o) {
        return o instanceof DateType;
    }
}

