/*
 * Decompiled with CFR 0.152.
 */
package smile.graph;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import smile.graph.Graph;
import smile.graph.Visitor;
import smile.math.matrix.SparseMatrix;
import smile.sort.QuickSort;
import smile.util.PriorityQueue;

public class AdjacencyList
implements Graph,
Serializable {
    private static final long serialVersionUID = 2L;
    private final boolean digraph;
    private final LinkedList<Graph.Edge>[] graph;

    public AdjacencyList(int n) {
        this(n, false);
    }

    public AdjacencyList(int n, boolean digraph) {
        this.digraph = digraph;
        this.graph = new LinkedList[n];
        for (int i = 0; i < n; ++i) {
            this.graph[i] = new LinkedList();
        }
    }

    @Override
    public int getNumVertices() {
        return this.graph.length;
    }

    @Override
    public boolean hasEdge(int source, int target) {
        if (this.digraph) {
            for (Graph.Edge edge : this.graph[source]) {
                if (edge.v2 != target) continue;
                return true;
            }
        } else {
            for (Graph.Edge edge : this.graph[source]) {
                if ((edge.v1 != source || edge.v2 != target) && (edge.v2 != source || edge.v1 != target)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public double getWeight(int source, int target) {
        if (this.digraph) {
            for (Graph.Edge edge : this.graph[source]) {
                if (edge.v2 != target) continue;
                return edge.weight;
            }
        } else {
            for (Graph.Edge edge : this.graph[source]) {
                if ((edge.v1 != source || edge.v2 != target) && (edge.v2 != source || edge.v1 != target)) continue;
                return edge.weight;
            }
        }
        return 0.0;
    }

    @Override
    public AdjacencyList setWeight(int source, int target, double weight) {
        if (this.digraph) {
            for (Graph.Edge edge : this.graph[source]) {
                if (edge.v2 != target) continue;
                edge.weight = weight;
                return this;
            }
        } else {
            for (Graph.Edge edge : this.graph[source]) {
                if ((edge.v1 != source || edge.v2 != target) && (edge.v2 != source || edge.v1 != target)) continue;
                edge.weight = weight;
                return this;
            }
        }
        this.addEdge(source, target, weight);
        return this;
    }

    @Override
    public Collection<Graph.Edge> getEdges() {
        HashSet<Graph.Edge> set = new HashSet<Graph.Edge>();
        for (LinkedList<Graph.Edge> edges : this.graph) {
            set.addAll(edges);
        }
        return set;
    }

    @Override
    public Collection<Graph.Edge> getEdges(int vertex) {
        return this.graph[vertex];
    }

    @Override
    public Collection<Graph.Edge> getEdges(int source, int target) {
        LinkedList<Graph.Edge> set = new LinkedList<Graph.Edge>();
        if (this.digraph) {
            for (Graph.Edge edge : this.graph[source]) {
                if (edge.v2 != target) continue;
                set.add(edge);
            }
        } else {
            for (Graph.Edge edge : this.graph[source]) {
                if ((edge.v1 != source || edge.v2 != target) && (edge.v2 != source || edge.v1 != target)) continue;
                set.add(edge);
            }
        }
        return set;
    }

    @Override
    public Graph.Edge getEdge(int source, int target) {
        if (this.digraph) {
            for (Graph.Edge edge : this.graph[source]) {
                if (edge.v2 != target) continue;
                return edge;
            }
        } else {
            for (Graph.Edge edge : this.graph[source]) {
                if ((edge.v1 != source || edge.v2 != target) && (edge.v2 != source || edge.v1 != target)) continue;
                return edge;
            }
        }
        return null;
    }

    @Override
    public void addEdge(int source, int target) {
        this.addEdge(source, target, 1.0);
    }

    @Override
    public void addEdge(int source, int target, double weight) {
        Graph.Edge edge = new Graph.Edge(source, target, weight);
        this.graph[source].add(edge);
        if (!this.digraph && source != target) {
            this.graph[target].add(edge);
        }
    }

    @Override
    public void removeEdges(Collection<Graph.Edge> edges) {
        for (Graph.Edge edge : edges) {
            this.removeEdge(edge);
        }
    }

    @Override
    public void removeEdge(int source, int target) {
        Iterator iter = this.graph[source].iterator();
        if (this.digraph) {
            while (iter.hasNext()) {
                Graph.Edge e = (Graph.Edge)iter.next();
                if (e.v2 != target) continue;
                iter.remove();
            }
        } else {
            Graph.Edge e;
            while (iter.hasNext()) {
                e = (Graph.Edge)iter.next();
                if ((e.v1 != source || e.v2 != target) && (e.v2 != source || e.v1 != target)) continue;
                iter.remove();
            }
            iter = this.graph[target].iterator();
            while (iter.hasNext()) {
                e = (Graph.Edge)iter.next();
                if ((e.v1 != source || e.v2 != target) && (e.v2 != source || e.v1 != target)) continue;
                iter.remove();
            }
        }
    }

    @Override
    public void removeEdge(Graph.Edge edge) {
        Iterator iter = this.graph[edge.v1].iterator();
        while (iter.hasNext()) {
            if (iter.next() != edge) continue;
            iter.remove();
            break;
        }
        if (!this.digraph) {
            iter = this.graph[edge.v2].iterator();
            while (iter.hasNext()) {
                if (iter.next() != edge) continue;
                iter.remove();
                break;
            }
        }
    }

    @Override
    public int getDegree(int vertex) {
        if (this.digraph) {
            return this.getIndegree(vertex) + this.getOutdegree(vertex);
        }
        return this.getOutdegree(vertex);
    }

    @Override
    public int getIndegree(int vertex) {
        int degree = 0;
        int n = this.graph.length;
        for (int i = 0; i < n; ++i) {
            if (!this.hasEdge(i, vertex)) continue;
            ++degree;
        }
        return degree;
    }

    @Override
    public int getOutdegree(int vertex) {
        return this.graph[vertex].size();
    }

    private int dfsearch(int v, int[] pre, int[] ts, int count) {
        pre[v] = 0;
        for (Graph.Edge edge : this.graph[v]) {
            int t2 = edge.v2;
            if (pre[t2] != -1) continue;
            count = this.dfsearch(t2, pre, ts, count);
        }
        ts[count++] = v;
        return count;
    }

    @Override
    public int[] sortdfs() {
        int i;
        if (!this.digraph) {
            throw new UnsupportedOperationException("Topological sort is only meaningful for digraph.");
        }
        int count = 0;
        int n = this.graph.length;
        int[] pre = new int[n];
        int[] ts = new int[n];
        for (i = 0; i < n; ++i) {
            pre[i] = -1;
            ts[i] = -1;
        }
        for (i = 0; i < n; ++i) {
            if (pre[i] != -1) continue;
            count = this.dfsearch(i, pre, ts, count);
        }
        return ts;
    }

    private void dfs(int v, int[] cc, int id) {
        cc[v] = id;
        for (Graph.Edge edge : this.graph[v]) {
            int t2 = edge.v2;
            if (!this.digraph && t2 == v) {
                t2 = edge.v1;
            }
            if (cc[t2] != -1) continue;
            this.dfs(t2, cc, id);
        }
    }

    @Override
    public int[][] dfs() {
        int n = this.graph.length;
        int[] cc = new int[n];
        Arrays.fill(cc, -1);
        int id = 0;
        for (int i = 0; i < n; ++i) {
            if (cc[i] != -1) continue;
            this.dfs(i, cc, id++);
        }
        int[] size = new int[id];
        for (int i = 0; i < n; ++i) {
            int n2 = cc[i];
            size[n2] = size[n2] + 1;
        }
        int[][] components = new int[id][];
        for (int i = 0; i < id; ++i) {
            components[i] = new int[size[i]];
            int k = 0;
            for (int j = 0; j < n; ++j) {
                if (cc[j] != i) continue;
                components[i][k++] = j;
            }
            Arrays.sort(components[i]);
        }
        return components;
    }

    @Override
    public void dfs(Visitor visitor) {
        int n = this.graph.length;
        int[] cc = new int[n];
        Arrays.fill(cc, -1);
        int id = 0;
        for (int i = 0; i < n; ++i) {
            if (cc[i] != -1) continue;
            this.dfs(visitor, i, cc, id++);
        }
    }

    private void dfs(Visitor visitor, int v, int[] cc, int id) {
        visitor.visit(v);
        cc[v] = id;
        for (Graph.Edge edge : this.graph[v]) {
            int t2 = edge.v2;
            if (!this.digraph && t2 == v) {
                t2 = edge.v1;
            }
            if (cc[t2] != -1) continue;
            this.dfs(visitor, t2, cc, id);
        }
    }

    @Override
    public int[] sortbfs() {
        int i;
        if (!this.digraph) {
            throw new UnsupportedOperationException("Topological sort is only meaningful for digraph.");
        }
        int n = this.graph.length;
        int[] in = new int[n];
        int[] ts = new int[n];
        for (int i2 = 0; i2 < n; ++i2) {
            ts[i2] = -1;
            for (Graph.Edge edge : this.graph[i2]) {
                int n2 = edge.v2;
                in[n2] = in[n2] + 1;
            }
        }
        LinkedList<Integer> queue = new LinkedList<Integer>();
        for (i = 0; i < n; ++i) {
            if (in[i] != 0) continue;
            queue.offer(i);
        }
        i = 0;
        while (!queue.isEmpty()) {
            int t2;
            ts[i] = t2 = ((Integer)queue.poll()).intValue();
            for (Graph.Edge edge : this.graph[t2]) {
                int v;
                int n3 = v = edge.v2;
                in[n3] = in[n3] - 1;
                if (in[n3] != 0) continue;
                queue.offer(v);
            }
            ++i;
        }
        return ts;
    }

    private void bfs(int v, int[] cc, int id) {
        cc[v] = id;
        LinkedList<Integer> queue = new LinkedList<Integer>();
        queue.offer(v);
        while (!queue.isEmpty()) {
            int t2 = (Integer)queue.poll();
            for (Graph.Edge edge : this.graph[t2]) {
                int i = edge.v2;
                if (!this.digraph && i == t2) {
                    i = edge.v1;
                }
                if (cc[i] != -1) continue;
                queue.offer(i);
                cc[i] = id;
            }
        }
    }

    @Override
    public int[][] bfs() {
        int n = this.graph.length;
        int[] cc = new int[n];
        Arrays.fill(cc, -1);
        int id = 0;
        for (int i = 0; i < n; ++i) {
            if (cc[i] != -1) continue;
            this.bfs(i, cc, id++);
        }
        int[] size = new int[id];
        for (int i = 0; i < n; ++i) {
            int n2 = cc[i];
            size[n2] = size[n2] + 1;
        }
        int[][] components = new int[id][];
        for (int i = 0; i < id; ++i) {
            components[i] = new int[size[i]];
            int k = 0;
            for (int j = 0; j < n; ++j) {
                if (cc[j] != i) continue;
                components[i][k++] = j;
            }
            Arrays.sort(components[i]);
        }
        return components;
    }

    private void bfs(Visitor visitor, int v, int[] cc, int id) {
        visitor.visit(v);
        cc[v] = id;
        LinkedList<Integer> queue = new LinkedList<Integer>();
        queue.offer(v);
        while (!queue.isEmpty()) {
            int t2 = (Integer)queue.poll();
            for (Graph.Edge edge : this.graph[t2]) {
                int i = edge.v2;
                if (!this.digraph && i == t2) {
                    i = edge.v1;
                }
                if (cc[i] != -1) continue;
                visitor.visit(i);
                queue.offer(i);
                cc[i] = id;
            }
        }
    }

    @Override
    public void bfs(Visitor visitor) {
        int n = this.graph.length;
        int[] cc = new int[n];
        Arrays.fill(cc, -1);
        int id = 0;
        for (int i = 0; i < n; ++i) {
            if (cc[i] != -1) continue;
            this.bfs(visitor, i, cc, id++);
        }
    }

    @Override
    public double[] dijkstra(int s) {
        int v;
        int n = this.graph.length;
        double[] wt = new double[n];
        Arrays.fill(wt, Double.POSITIVE_INFINITY);
        PriorityQueue queue = new PriorityQueue(wt);
        for (v = 0; v < n; ++v) {
            queue.insert(v);
        }
        wt[s] = 0.0;
        queue.lower(s);
        while (!queue.isEmpty()) {
            v = queue.poll();
            if (Double.isInfinite(wt[v])) continue;
            for (Graph.Edge edge : this.graph[v]) {
                double p;
                int w = edge.v2;
                if (!this.digraph && w == v) {
                    w = edge.v1;
                }
                if (!((p = wt[v] + edge.weight) < wt[w])) continue;
                wt[w] = p;
                queue.lower(w);
            }
        }
        return wt;
    }

    @Override
    public AdjacencyList subgraph(int[] vertices) {
        int[] v = (int[])vertices.clone();
        Arrays.sort(v);
        AdjacencyList g = new AdjacencyList(v.length, this.digraph);
        for (int i = 0; i < v.length; ++i) {
            Collection<Graph.Edge> edges = this.getEdges(v[i]);
            for (Graph.Edge edge : edges) {
                int j;
                int n = j = edge.v1 == v[i] ? edge.v2 : edge.v1;
                if ((j = Arrays.binarySearch(v, j)) < 0) continue;
                g.addEdge(i, j, edge.weight);
            }
        }
        return g;
    }

    @Override
    public SparseMatrix toMatrix() {
        int i;
        int size = 0;
        int n = this.graph.length;
        int[] colSize = new int[n];
        int[] colIndex = new int[n + 1];
        for (i = 0; i < n; ++i) {
            LinkedList<Graph.Edge> edges = this.graph[i];
            size += edges.size();
            colSize[i] = edges.size();
        }
        for (i = 0; i < n; ++i) {
            colIndex[i + 1] = colIndex[i] + colSize[i];
        }
        int[] rowIndex = new int[size];
        double[] x = new double[size];
        for (int i2 = 0; i2 < n; ++i2) {
            LinkedList<Graph.Edge> edges = this.graph[i2];
            int ni = edges.size();
            int[] index = new int[ni];
            double[] w = new double[ni];
            int j = 0;
            for (Graph.Edge edge : edges) {
                index[j] = edge.v1 == i2 ? edge.v2 : edge.v1;
                w[j++] = edge.weight;
            }
            QuickSort.sort(index, w);
            int k = colIndex[i2];
            j = 0;
            while (j < ni) {
                rowIndex[k] = index[j];
                x[k] = w[j];
                ++j;
                ++k;
            }
        }
        return new SparseMatrix(n, n, x, rowIndex, colIndex).transpose();
    }

    public static AdjacencyList of(SparseMatrix matrix) {
        int i;
        boolean symmetric = false;
        if (matrix.nrow() == matrix.ncol()) {
            symmetric = true;
            for (int i2 = 0; i2 < matrix.nrow(); ++i2) {
                for (int j = 0; j < i2; ++j) {
                    if (matrix.get(i2, j) == matrix.get(j, i2)) continue;
                    symmetric = false;
                    break;
                }
                if (!symmetric) break;
            }
        }
        if (symmetric) {
            AdjacencyList graph = new AdjacencyList(matrix.nrow());
            for (i = 0; i < matrix.nrow(); ++i) {
                for (int j = 0; j < i; ++j) {
                    double z = matrix.get(i, j);
                    if (z == 0.0) continue;
                    graph.addEdge(i, j, z);
                }
            }
            return graph;
        }
        AdjacencyList graph = new AdjacencyList(matrix.nrow() + matrix.ncol());
        for (i = 0; i < matrix.nrow(); ++i) {
            for (int j = 0; j < matrix.ncol(); ++j) {
                double z = matrix.get(i, j);
                if (z == 0.0) continue;
                graph.addEdge(i, matrix.nrow() + j, z);
            }
        }
        return graph;
    }
}

