/*
 * Decompiled with CFR 0.152.
 */
package smile.math.distance;

import smile.math.MathEx;
import smile.math.distance.Metric;
import smile.util.IntArray2D;

public class EditDistance
implements Metric<String> {
    private static final long serialVersionUID = 1L;
    private IntArray2D weight;
    private double r = -1.0;
    private boolean damerau = false;
    private IntArray2D FKP;
    private BRF brf;

    public EditDistance() {
        this(false);
    }

    public EditDistance(boolean damerau) {
        this.damerau = damerau;
    }

    public EditDistance(int maxStringLength) {
        this(maxStringLength, false);
    }

    public EditDistance(int maxStringLength, boolean damerau) {
        this.damerau = damerau;
        this.FKP = new IntArray2D(2 * maxStringLength + 1, maxStringLength + 2);
        this.brf = damerau ? new DamerauBRF() : new LevenshteinBRF();
    }

    public EditDistance(int[][] weight) {
        this(weight, -1.0);
    }

    public EditDistance(int[][] weight, double radius) {
        this.weight = new IntArray2D(weight);
        this.r = radius;
    }

    public String toString() {
        if (this.damerau) {
            if (this.weight != null) {
                return String.format("Damerau-Levenshtein Distance(radius = %f, weight = %s)", this.r, this.weight.toString());
            }
            return "Damerau-Levenshtein Distance";
        }
        if (this.weight != null) {
            return String.format("Levenshtein Distance(radius = %f, weight = %s)", this.r, this.weight.toString());
        }
        return "Levenshtein Distance";
    }

    @Override
    public double d(String x, String y) {
        if (this.weight != null) {
            return this.weightedEdit(x, y);
        }
        if (this.FKP == null || x.length() == 1 || y.length() == 1) {
            return this.damerau ? (double)EditDistance.damerau(x, y) : (double)EditDistance.levenshtein(x, y);
        }
        return this.br(x, y);
    }

    @Override
    public double d(char[] x, char[] y) {
        if (this.weight != null) {
            return this.weightedEdit(x, y);
        }
        if (this.FKP == null || x.length == 1 || y.length == 1) {
            return this.damerau ? (double)EditDistance.damerau(x, y) : (double)EditDistance.levenshtein(x, y);
        }
        return this.br(x, y);
    }

    private double weightedEdit(char[] x, char[] y) {
        if (x.length < y.length) {
            char[] swap = x;
            x = y;
            y = swap;
        }
        int radius = (int)Math.round(this.r * (double)x.length);
        double[][] d = new double[2][y.length + 1];
        d[0][0] = 0.0;
        for (int j = 1; j <= y.length; ++j) {
            d[0][j] = d[0][j - 1] + (double)this.weight.get(0, y[j]);
        }
        for (int i = 1; i <= x.length; ++i) {
            d[1][0] = d[0][0] + (double)this.weight.get(x[i], 0);
            int start = 1;
            int end = y.length;
            if (radius > 0) {
                start = i - radius;
                if (start > 1) {
                    d[1][start - 1] = Double.POSITIVE_INFINITY;
                } else {
                    start = 1;
                }
                end = i + radius;
                if (end < y.length) {
                    d[1][end + 1] = Double.POSITIVE_INFINITY;
                } else {
                    end = y.length;
                }
            }
            for (int j = start; j <= end; ++j) {
                double cost = this.weight.get(x[i - 1], y[j - 1]);
                d[1][j] = MathEx.min(d[0][j] + (double)this.weight.get(x[i - 1], 0), d[1][j - 1] + (double)this.weight.get(0, y[j - 1]), d[0][j - 1] + cost);
            }
            double[] swap = d[0];
            d[0] = d[1];
            d[1] = swap;
        }
        return d[0][y.length];
    }

    private double weightedEdit(String x, String y) {
        if (x.length() < y.length()) {
            String swap = x;
            x = y;
            y = swap;
        }
        int radius = (int)Math.round(this.r * (double)x.length());
        double[][] d = new double[2][y.length() + 1];
        d[0][0] = 0.0;
        for (int j = 1; j <= y.length(); ++j) {
            d[0][j] = d[0][j - 1] + (double)this.weight.get(0, y.charAt(j));
        }
        for (int i = 1; i <= x.length(); ++i) {
            d[1][0] = d[0][0] + (double)this.weight.get(x.charAt(i), 0);
            int start = 1;
            int end = y.length();
            if (radius > 0) {
                start = i - radius;
                if (start > 1) {
                    d[1][start - 1] = Double.POSITIVE_INFINITY;
                } else {
                    start = 1;
                }
                end = i + radius;
                if (end < y.length()) {
                    d[1][end + 1] = Double.POSITIVE_INFINITY;
                } else {
                    end = y.length();
                }
            }
            for (int j = start; j <= end; ++j) {
                double cost = this.weight.get(x.charAt(i - 1), y.charAt(j - 1));
                d[1][j] = MathEx.min(d[0][j] + (double)this.weight.get(x.charAt(i - 1), 0), d[1][j - 1] + (double)this.weight.get(0, y.charAt(j - 1)), d[0][j - 1] + cost);
            }
            double[] swap = d[0];
            d[0] = d[1];
            d[1] = swap;
        }
        return d[0][y.length()];
    }

    private int br(char[] x, char[] y) {
        int p;
        int k;
        int n;
        if (x.length > y.length) {
            char[] swap = x;
            x = y;
            y = swap;
        }
        int m = x.length;
        int ZERO_K = n = y.length;
        if (n + 2 > this.FKP.ncol()) {
            this.FKP = new IntArray2D(2 * n + 1, n + 2);
        }
        for (k = -ZERO_K; k < 0; ++k) {
            p = -k - 1;
            this.FKP.set(k + ZERO_K, p + 1, Math.abs(k) - 1);
            this.FKP.set(k + ZERO_K, p, Integer.MIN_VALUE);
        }
        this.FKP.set(ZERO_K, 0, -1);
        for (k = 1; k <= ZERO_K; ++k) {
            p = k - 1;
            this.FKP.set(k + ZERO_K, p + 1, -1);
            this.FKP.set(k + ZERO_K, p, Integer.MIN_VALUE);
        }
        int p2 = n - m - 1;
        do {
            int i;
            for (i = (++p2 - (n - m)) / 2; i >= 1; --i) {
                this.brf.f(x, y, this.FKP, ZERO_K, n - m + i, p2 - i);
            }
            for (i = (n - m + p2) / 2; i >= 1; --i) {
                this.brf.f(x, y, this.FKP, ZERO_K, n - m - i, p2 - i);
            }
            this.brf.f(x, y, this.FKP, ZERO_K, n - m, p2);
        } while (this.FKP.get(n - m + ZERO_K, p2) != m);
        return p2 - 1;
    }

    private int br(String x, String y) {
        int p;
        int k;
        int n;
        if (x.length() > y.length()) {
            String swap = x;
            x = y;
            y = swap;
        }
        int m = x.length();
        int ZERO_K = n = y.length();
        if (n + 3 > this.FKP.ncol()) {
            this.FKP = new IntArray2D(2 * n + 1, n + 3);
        }
        for (k = -ZERO_K; k < 0; ++k) {
            p = -k - 1;
            this.FKP.set(k + ZERO_K, p + 1, Math.abs(k) - 1);
            this.FKP.set(k + ZERO_K, p, Integer.MIN_VALUE);
        }
        this.FKP.set(ZERO_K, 0, -1);
        for (k = 1; k <= ZERO_K; ++k) {
            p = k - 1;
            this.FKP.set(k + ZERO_K, p + 1, -1);
            this.FKP.set(k + ZERO_K, p, Integer.MIN_VALUE);
        }
        int p2 = n - m - 1;
        do {
            int i;
            for (i = (++p2 - (n - m)) / 2; i >= 1; --i) {
                this.brf.f(x, y, this.FKP, ZERO_K, n - m + i, p2 - i);
            }
            for (i = (n - m + p2) / 2; i >= 1; --i) {
                this.brf.f(x, y, this.FKP, ZERO_K, n - m - i, p2 - i);
            }
            this.brf.f(x, y, this.FKP, ZERO_K, n - m, p2);
        } while (this.FKP.get(n - m + ZERO_K, p2) != m);
        return p2 - 1;
    }

    public static int levenshtein(String x, String y) {
        if (x.length() < y.length()) {
            String swap = x;
            x = y;
            y = swap;
        }
        int[][] d = new int[2][y.length() + 1];
        for (int j = 0; j <= y.length(); ++j) {
            d[0][j] = j;
        }
        for (int i = 1; i <= x.length(); ++i) {
            d[1][0] = i;
            for (int j = 1; j <= y.length(); ++j) {
                int cost = x.charAt(i - 1) == y.charAt(j - 1) ? 0 : 1;
                d[1][j] = MathEx.min(d[0][j] + 1, d[1][j - 1] + 1, d[0][j - 1] + cost);
            }
            int[] swap = d[0];
            d[0] = d[1];
            d[1] = swap;
        }
        return d[0][y.length()];
    }

    public static int levenshtein(char[] x, char[] y) {
        if (x.length < y.length) {
            char[] swap = x;
            x = y;
            y = swap;
        }
        int[][] d = new int[2][y.length + 1];
        for (int j = 0; j <= y.length; ++j) {
            d[0][j] = j;
        }
        for (int i = 1; i <= x.length; ++i) {
            d[1][0] = i;
            for (int j = 1; j <= y.length; ++j) {
                int cost = x[i - 1] == y[j - 1] ? 0 : 1;
                d[1][j] = MathEx.min(d[0][j] + 1, d[1][j - 1] + 1, d[0][j - 1] + cost);
            }
            int[] swap = d[0];
            d[0] = d[1];
            d[1] = swap;
        }
        return d[0][y.length];
    }

    public static int damerau(String x, String y) {
        if (x.length() < y.length()) {
            String swap = x;
            x = y;
            y = swap;
        }
        int[][] d = new int[3][y.length() + 1];
        for (int j = 0; j <= y.length(); ++j) {
            d[1][j] = j;
        }
        for (int i = 1; i <= x.length(); ++i) {
            d[2][0] = i;
            for (int j = 1; j <= y.length(); ++j) {
                int cost = x.charAt(i - 1) == y.charAt(j - 1) ? 0 : 1;
                d[2][j] = MathEx.min(d[1][j] + 1, d[2][j - 1] + 1, d[1][j - 1] + cost);
                if (i <= 1 || j <= 1 || x.charAt(i - 1) != y.charAt(j - 2) || x.charAt(i - 2) != y.charAt(j - 1)) continue;
                d[2][j] = Math.min(d[2][j], d[0][j - 2] + cost);
            }
            int[] swap = d[0];
            d[0] = d[1];
            d[1] = d[2];
            d[2] = swap;
        }
        return d[1][y.length()];
    }

    public static int damerau(char[] x, char[] y) {
        if (x.length < y.length) {
            char[] swap = x;
            x = y;
            y = swap;
        }
        int[][] d = new int[3][y.length + 1];
        for (int j = 0; j <= y.length; ++j) {
            d[1][j] = j;
        }
        for (int i = 1; i <= x.length; ++i) {
            d[2][0] = i;
            for (int j = 1; j <= y.length; ++j) {
                int cost = x[i - 1] == y[j - 1] ? 0 : 1;
                d[2][j] = MathEx.min(d[1][j] + 1, d[2][j - 1] + 1, d[1][j - 1] + cost);
                if (i <= 1 || j <= 1 || x[i - 1] != y[j - 2] || x[i - 2] != y[j - 1]) continue;
                d[2][j] = Math.min(d[2][j], d[0][j - 2] + cost);
            }
            int[] swap = d[0];
            d[0] = d[1];
            d[1] = d[2];
            d[2] = swap;
        }
        return d[1][y.length];
    }

    private static class DamerauBRF
    implements BRF {
        private DamerauBRF() {
        }

        @Override
        public void f(char[] x, char[] y, IntArray2D FKP, int ZERO_K, int k, int p) {
            int t2 = FKP.get(k + ZERO_K, p) + 1;
            int mnk = Math.min(x.length, y.length - k);
            if (t2 >= 1 && k + t2 >= 1 && t2 < mnk && x[t2 - 1] == y[k + t2] && x[t2] == y[k + t2 - 1]) {
                ++t2;
            }
            for (t2 = MathEx.max(FKP.get(k - 1 + ZERO_K, p), FKP.get(k + 1 + ZERO_K, p) + 1, t2); t2 < mnk && x[t2] == y[t2 + k]; ++t2) {
            }
            FKP.set(k + ZERO_K, p + 1, t2);
        }

        @Override
        public void f(String x, String y, IntArray2D FKP, int ZERO_K, int k, int p) {
            int t2 = FKP.get(k + ZERO_K, p) + 1;
            int mnk = Math.min(x.length(), y.length() - k);
            if (t2 >= 1 && k + t2 >= 1 && t2 < mnk && x.charAt(t2 - 1) == y.charAt(k + t2) && x.charAt(t2) == y.charAt(k + t2 - 1)) {
                ++t2;
            }
            for (t2 = MathEx.max(FKP.get(k - 1 + ZERO_K, p), FKP.get(k + 1 + ZERO_K, p) + 1, t2); t2 < mnk && x.charAt(t2) == y.charAt(t2 + k); ++t2) {
            }
            FKP.set(k + ZERO_K, p + 1, t2);
        }
    }

    private static class LevenshteinBRF
    implements BRF {
        private LevenshteinBRF() {
        }

        @Override
        public void f(char[] x, char[] y, IntArray2D FKP, int ZERO_K, int k, int p) {
            int t2;
            int mnk = Math.min(x.length, y.length - k);
            for (t2 = MathEx.max(FKP.get(k + ZERO_K, p) + 1, FKP.get(k - 1 + ZERO_K, p), FKP.get(k + 1 + ZERO_K, p) + 1); t2 < mnk && x[t2] == y[t2 + k]; ++t2) {
            }
            FKP.set(k + ZERO_K, p + 1, t2);
        }

        @Override
        public void f(String x, String y, IntArray2D FKP, int ZERO_K, int k, int p) {
            int t2;
            int mnk = Math.min(x.length(), y.length() - k);
            for (t2 = MathEx.max(FKP.get(k + ZERO_K, p) + 1, FKP.get(k - 1 + ZERO_K, p), FKP.get(k + 1 + ZERO_K, p) + 1); t2 < mnk && x.charAt(t2) == y.charAt(t2 + k); ++t2) {
            }
            FKP.set(k + ZERO_K, p + 1, t2);
        }
    }

    private static interface BRF {
        public void f(char[] var1, char[] var2, IntArray2D var3, int var4, int var5, int var6);

        public void f(String var1, String var2, IntArray2D var3, int var4, int var5, int var6);
    }
}

