/*
 * Decompiled with CFR 0.152.
 */
package smile.data;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import smile.data.BinarySparseDatasetImpl;
import smile.data.Dataset;
import smile.data.SampleInstance;
import smile.math.matrix.SparseMatrix;

public interface BinarySparseDataset<T>
extends Dataset<int[], T> {
    public int length();

    public int ncol();

    default public int get(int i, int j) {
        if (i < 0 || i >= this.size()) {
            throw new IllegalArgumentException("Invalid index: i = " + i);
        }
        int[] x = (int[])this.get(i).x();
        if (x.length == 0) {
            return 0;
        }
        int low = 0;
        int high = x.length - 1;
        int mid = (low + high) / 2;
        while (j != x[mid] && low <= high) {
            mid = (low + high) / 2;
            if (j < x[mid]) {
                high = mid - 1;
                continue;
            }
            low = mid + 1;
        }
        if (j == x[mid]) {
            return 1;
        }
        return 0;
    }

    public SparseMatrix toMatrix();

    public static <T> BinarySparseDataset<T> of(Collection<SampleInstance<int[], T>> data) {
        return new BinarySparseDatasetImpl<T>(data);
    }

    public static BinarySparseDataset<Void> of(int[][] data) {
        return new BinarySparseDatasetImpl<Void>(Arrays.stream(data).map(x -> new SampleInstance<int[], Object>((int[])x, null)).collect(Collectors.toList()));
    }

    public static BinarySparseDataset<Void> from(Path path) throws IOException, NumberFormatException {
        try (Stream<String> stream = Files.lines(path);){
            List rows = stream.map(line -> {
                String[] s = line.split("\\s+");
                int[] index = new int[s.length];
                for (int i = 0; i < s.length; ++i) {
                    index[i] = Integer.parseInt(s[i]);
                }
                return new SampleInstance<int[], Object>(index, null);
            }).collect(Collectors.toList());
            BinarySparseDatasetImpl<Void> binarySparseDatasetImpl = new BinarySparseDatasetImpl<Void>(rows);
            return binarySparseDatasetImpl;
        }
    }
}

