/*
 * Decompiled with CFR 0.152.
 */
package smile.data;

import java.util.Spliterator;
import java.util.function.Consumer;
import smile.data.DataFrame;
import smile.data.Tuple;

class DataFrameSpliterator
implements Spliterator<Tuple> {
    private final DataFrame data;
    private int characteristics = 17472;
    private int origin;
    private final int fence;

    public DataFrameSpliterator(DataFrame data, int additionalCharacteristics) {
        this.data = data;
        this.characteristics |= additionalCharacteristics;
        this.origin = 0;
        this.fence = data.size();
    }

    public DataFrameSpliterator(DataFrameSpliterator spliterator, int origin, int fence) {
        this.data = spliterator.data;
        this.characteristics = spliterator.characteristics;
        this.origin = origin;
        this.fence = fence;
    }

    @Override
    public boolean tryAdvance(Consumer<? super Tuple> action) {
        if (this.origin < this.fence) {
            action.accept(this.data.get(this.origin));
            ++this.origin;
            return true;
        }
        return false;
    }

    @Override
    public Spliterator<Tuple> trySplit() {
        int lo = this.origin;
        int mid = lo + this.fence >>> 1;
        if (lo < mid) {
            this.origin = mid;
            return new DataFrameSpliterator(this, lo, mid);
        }
        return null;
    }

    @Override
    public long estimateSize() {
        return this.fence - this.origin;
    }

    @Override
    public int characteristics() {
        return this.characteristics;
    }
}

