/*
 * Decompiled with CFR 0.152.
 */
package smile.data.formula;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.ToDoubleBiFunction;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntBiFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongBiFunction;
import java.util.function.ToLongFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import smile.data.Tuple;
import smile.data.formula.Abs;
import smile.data.formula.AbstractBiFunction;
import smile.data.formula.AbstractFunction;
import smile.data.formula.Add;
import smile.data.formula.Constant;
import smile.data.formula.Date;
import smile.data.formula.DateFeature;
import smile.data.formula.Delete;
import smile.data.formula.Div;
import smile.data.formula.Dot;
import smile.data.formula.DoubleFunction;
import smile.data.formula.FactorCrossing;
import smile.data.formula.FactorInteraction;
import smile.data.formula.Feature;
import smile.data.formula.IntFunction;
import smile.data.formula.Intercept;
import smile.data.formula.Mul;
import smile.data.formula.Round;
import smile.data.formula.Sub;
import smile.data.formula.Term;
import smile.data.formula.Variable;
import smile.data.type.DataType;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.type.StructType;
import smile.math.MathEx;

public interface Terms {
    public static Term $(String name) {
        String y;
        switch (name = name.trim()) {
            case ".": {
                return new Dot();
            }
            case "0": {
                return new Intercept(false);
            }
            case "1": {
                return new Intercept(true);
            }
        }
        String[] tokens = name.split(":");
        if (tokens.length > 1) {
            for (int i = 0; i < tokens.length; ++i) {
                tokens[i] = tokens[i].trim();
            }
            return Terms.interact(tokens);
        }
        if (name.startsWith("(") && name.endsWith(")")) {
            String y2 = name.substring(1, name.length() - 1);
            tokens = y2.split("[+]", 2);
            if (tokens.length == 2) {
                return Terms.add(tokens[0], tokens[1]);
            }
            tokens = y2.split("[-]", 2);
            if (tokens.length == 2) {
                return Terms.sub(tokens[0], tokens[1]);
            }
            tokens = y2.split("[*]", 2);
            if (tokens.length == 2) {
                return Terms.mul(tokens[0], tokens[1]);
            }
            tokens = y2.split("[/]", 2);
            if (tokens.length == 2) {
                return Terms.div(tokens[0], tokens[1]);
            }
        }
        Pattern regex = Pattern.compile("\\)(^(\\d+))?$");
        Matcher matcher = regex.matcher(name);
        if (name.startsWith("(") && matcher.find() && (tokens = (y = name.substring(1, matcher.start())).split(" x ")).length > 1) {
            for (int i = 0; i < tokens.length; ++i) {
                tokens[i] = tokens[i].trim();
            }
            String rank = matcher.group(2);
            return Terms.cross(rank == null ? tokens.length : Integer.parseInt(rank), tokens);
        }
        if (name.startsWith("abs(") && name.endsWith(")")) {
            return Terms.abs(name.substring(4, name.length() - 1));
        }
        if (name.startsWith("ceil(") && name.endsWith(")")) {
            return Terms.ceil(name.substring(5, name.length() - 1));
        }
        if (name.startsWith("floor(") && name.endsWith(")")) {
            return Terms.floor(name.substring(6, name.length() - 1));
        }
        if (name.startsWith("round(") && name.endsWith(")")) {
            return Terms.round(name.substring(6, name.length() - 1));
        }
        if (name.startsWith("rint(") && name.endsWith(")")) {
            return Terms.rint(name.substring(5, name.length() - 1));
        }
        if (name.startsWith("exp(") && name.endsWith(")")) {
            return Terms.exp(name.substring(4, name.length() - 1));
        }
        if (name.startsWith("expm1(") && name.endsWith(")")) {
            return Terms.expm1(name.substring(6, name.length() - 1));
        }
        if (name.startsWith("log(") && name.endsWith(")")) {
            return Terms.log(name.substring(4, name.length() - 1));
        }
        if (name.startsWith("log1p(") && name.endsWith(")")) {
            return Terms.log1p(name.substring(6, name.length() - 1));
        }
        if (name.startsWith("log2(") && name.endsWith(")")) {
            return Terms.log2(name.substring(5, name.length() - 1));
        }
        if (name.startsWith("log10(") && name.endsWith(")")) {
            return Terms.log10(name.substring(6, name.length() - 1));
        }
        if (name.startsWith("signum(") && name.endsWith(")")) {
            return Terms.signum(name.substring(7, name.length() - 1));
        }
        if (name.startsWith("sign(") && name.endsWith(")")) {
            return Terms.sign(name.substring(5, name.length() - 1));
        }
        if (name.startsWith("sqrt(") && name.endsWith(")")) {
            return Terms.sqrt(name.substring(5, name.length() - 1));
        }
        if (name.startsWith("cbrt(") && name.endsWith(")")) {
            return Terms.cbrt(name.substring(5, name.length() - 1));
        }
        if (name.startsWith("sin(") && name.endsWith(")")) {
            return Terms.sin(name.substring(4, name.length() - 1));
        }
        if (name.startsWith("cos(") && name.endsWith(")")) {
            return Terms.cos(name.substring(4, name.length() - 1));
        }
        if (name.startsWith("tan(") && name.endsWith(")")) {
            return Terms.tan(name.substring(4, name.length() - 1));
        }
        if (name.startsWith("asin(") && name.endsWith(")")) {
            return Terms.asin(name.substring(5, name.length() - 1));
        }
        if (name.startsWith("acos(") && name.endsWith(")")) {
            return Terms.acos(name.substring(5, name.length() - 1));
        }
        if (name.startsWith("atan(") && name.endsWith(")")) {
            return Terms.atan(name.substring(5, name.length() - 1));
        }
        if (name.startsWith("sinh(") && name.endsWith(")")) {
            return Terms.sinh(name.substring(5, name.length() - 1));
        }
        if (name.startsWith("cosh(") && name.endsWith(")")) {
            return Terms.cosh(name.substring(5, name.length() - 1));
        }
        if (name.startsWith("tanh(") && name.endsWith(")")) {
            return Terms.tanh(name.substring(5, name.length() - 1));
        }
        if (name.startsWith("ulp(") && name.endsWith(")")) {
            return Terms.ulp(name.substring(4, name.length() - 1));
        }
        return new Variable(name);
    }

    public static Dot dot() {
        return new Dot();
    }

    public static FactorInteraction interact(String ... factors) {
        return new FactorInteraction(factors);
    }

    public static FactorCrossing cross(String ... factors) {
        return new FactorCrossing(factors);
    }

    public static FactorCrossing cross(int order, String ... factors) {
        return new FactorCrossing(order, factors);
    }

    public static Term delete(String x) {
        if (x.equals("1")) {
            return new Intercept(false);
        }
        return Terms.delete(Terms.$(x));
    }

    public static Term delete(Term x) {
        if (x instanceof Intercept) {
            return new Intercept(false);
        }
        return new Delete(x);
    }

    public static Date date(String x, DateFeature ... features) {
        return new Date(x, features);
    }

    public static Term add(Term a, Term b) {
        return new Add(a, b);
    }

    public static Term add(String a, String b) {
        return new Add(Terms.$(a), Terms.$(b));
    }

    public static Term add(Term a, String b) {
        return new Add(a, Terms.$(b));
    }

    public static Term add(String a, Term b) {
        return new Add(Terms.$(a), b);
    }

    public static Term sub(Term a, Term b) {
        return new Sub(a, b);
    }

    public static Term sub(String a, String b) {
        return new Sub(Terms.$(a), Terms.$(b));
    }

    public static Term sub(Term a, String b) {
        return new Sub(a, Terms.$(b));
    }

    public static Term sub(String a, Term b) {
        return new Sub(Terms.$(a), b);
    }

    public static Term mul(Term a, Term b) {
        return new Mul(a, b);
    }

    public static Term mul(String a, String b) {
        return new Mul(Terms.$(a), Terms.$(b));
    }

    public static Term mul(Term a, String b) {
        return new Mul(a, Terms.$(b));
    }

    public static Term mul(String a, Term b) {
        return new Mul(Terms.$(a), b);
    }

    public static Term div(Term a, Term b) {
        return new Div(a, b);
    }

    public static Term div(String a, String b) {
        return new Div(Terms.$(a), Terms.$(b));
    }

    public static Term div(Term a, String b) {
        return new Div(a, Terms.$(b));
    }

    public static Term div(String a, Term b) {
        return new Div(Terms.$(a), b);
    }

    public static Abs abs(String x) {
        return Terms.abs(Terms.$(x));
    }

    public static Abs abs(Term x) {
        return new Abs(x);
    }

    public static DoubleFunction ceil(String x) {
        return Terms.ceil(Terms.$(x));
    }

    public static DoubleFunction ceil(Term x) {
        return new DoubleFunction("ceil", x, Math::ceil);
    }

    public static DoubleFunction floor(String x) {
        return Terms.floor(Terms.$(x));
    }

    public static DoubleFunction floor(Term x) {
        return new DoubleFunction("floor", x, Math::floor);
    }

    public static Round round(String x) {
        return Terms.round(Terms.$(x));
    }

    public static Round round(Term x) {
        return new Round(x);
    }

    public static DoubleFunction rint(String x) {
        return Terms.rint(Terms.$(x));
    }

    public static DoubleFunction rint(Term x) {
        return new DoubleFunction("rint", x, Math::rint);
    }

    public static DoubleFunction exp(String x) {
        return Terms.exp(Terms.$(x));
    }

    public static DoubleFunction exp(Term x) {
        return new DoubleFunction("exp", x, Math::exp);
    }

    public static DoubleFunction expm1(String x) {
        return Terms.expm1(Terms.$(x));
    }

    public static DoubleFunction expm1(Term x) {
        return new DoubleFunction("expm1", x, Math::expm1);
    }

    public static DoubleFunction log(String x) {
        return Terms.log(Terms.$(x));
    }

    public static DoubleFunction log(Term x) {
        return new DoubleFunction("log", x, Math::log);
    }

    public static DoubleFunction log1p(String x) {
        return Terms.log1p(Terms.$(x));
    }

    public static DoubleFunction log1p(Term x) {
        return new DoubleFunction("log1p", x, Math::log1p);
    }

    public static DoubleFunction log10(String x) {
        return Terms.log10(Terms.$(x));
    }

    public static DoubleFunction log10(Term x) {
        return new DoubleFunction("log10", x, Math::log10);
    }

    public static DoubleFunction log2(String x) {
        return Terms.log2(Terms.$(x));
    }

    public static DoubleFunction log2(Term x) {
        return new DoubleFunction("log2", x, MathEx::log2);
    }

    public static DoubleFunction signum(String x) {
        return Terms.signum(Terms.$(x));
    }

    public static DoubleFunction signum(Term x) {
        return new DoubleFunction("signum", x, Math::signum);
    }

    public static IntFunction sign(String x) {
        return Terms.sign(Terms.$(x));
    }

    public static IntFunction sign(Term x) {
        return new IntFunction("sign", x, Integer::signum);
    }

    public static DoubleFunction sqrt(String x) {
        return Terms.sqrt(Terms.$(x));
    }

    public static DoubleFunction sqrt(Term x) {
        return new DoubleFunction("sqrt", x, Math::sqrt);
    }

    public static DoubleFunction cbrt(String x) {
        return Terms.cbrt(Terms.$(x));
    }

    public static DoubleFunction cbrt(Term x) {
        return new DoubleFunction("cbrt", x, Math::cbrt);
    }

    public static DoubleFunction sin(String x) {
        return Terms.sin(Terms.$(x));
    }

    public static DoubleFunction sin(Term x) {
        return new DoubleFunction("sin", x, Math::sin);
    }

    public static DoubleFunction cos(String x) {
        return Terms.cos(Terms.$(x));
    }

    public static DoubleFunction cos(Term x) {
        return new DoubleFunction("cos", x, Math::cos);
    }

    public static DoubleFunction tan(String x) {
        return Terms.tan(Terms.$(x));
    }

    public static DoubleFunction tan(Term x) {
        return new DoubleFunction("tan", x, Math::tan);
    }

    public static DoubleFunction sinh(String x) {
        return Terms.sinh(Terms.$(x));
    }

    public static DoubleFunction sinh(Term x) {
        return new DoubleFunction("sinh", x, Math::sinh);
    }

    public static DoubleFunction cosh(String x) {
        return Terms.cosh(Terms.$(x));
    }

    public static DoubleFunction cosh(Term x) {
        return new DoubleFunction("cosh", x, Math::cosh);
    }

    public static DoubleFunction tanh(String x) {
        return Terms.tanh(Terms.$(x));
    }

    public static DoubleFunction tanh(Term x) {
        return new DoubleFunction("tanh", x, Math::tanh);
    }

    public static DoubleFunction asin(String x) {
        return Terms.asin(Terms.$(x));
    }

    public static DoubleFunction asin(Term x) {
        return new DoubleFunction("asin", x, Math::asin);
    }

    public static DoubleFunction acos(String x) {
        return Terms.acos(Terms.$(x));
    }

    public static DoubleFunction acos(Term x) {
        return new DoubleFunction("acos", x, Math::acos);
    }

    public static DoubleFunction atan(String x) {
        return Terms.atan(Terms.$(x));
    }

    public static DoubleFunction atan(Term x) {
        return new DoubleFunction("atan", x, Math::acos);
    }

    public static DoubleFunction ulp(String x) {
        return Terms.ulp(Terms.$(x));
    }

    public static DoubleFunction ulp(Term x) {
        return new DoubleFunction("ulp", x, Math::ulp);
    }

    public static Term val(final boolean x) {
        return new Constant(){

            public String toString() {
                return String.valueOf(x);
            }

            @Override
            public List<Feature> bind(StructType schema) {
                Feature feature = new Feature(){
                    private final StructField field;
                    {
                        this.field = new StructField(String.valueOf(x), DataTypes.BooleanType, null);
                    }

                    @Override
                    public StructField field() {
                        return this.field;
                    }

                    @Override
                    public boolean applyAsBoolean(Tuple o) {
                        return x;
                    }

                    @Override
                    public Object apply(Tuple o) {
                        return x;
                    }
                };
                return Collections.singletonList(feature);
            }
        };
    }

    public static Term val(final char x) {
        return new Constant(){

            public String toString() {
                return String.valueOf(x);
            }

            @Override
            public List<Feature> bind(StructType schema) {
                Feature feature = new Feature(){
                    private final StructField field;
                    {
                        this.field = new StructField(String.valueOf(x), DataTypes.CharType, null);
                    }

                    @Override
                    public StructField field() {
                        return this.field;
                    }

                    @Override
                    public char applyAsChar(Tuple o) {
                        return x;
                    }

                    @Override
                    public Object apply(Tuple o) {
                        return Character.valueOf(x);
                    }
                };
                return Collections.singletonList(feature);
            }
        };
    }

    public static Term val(final byte x) {
        return new Constant(){

            public String toString() {
                return String.valueOf(x);
            }

            @Override
            public List<Feature> bind(StructType schema) {
                Feature feature = new Feature(){
                    private final StructField field;
                    {
                        this.field = new StructField(String.valueOf(x), DataTypes.ByteType, null);
                    }

                    @Override
                    public StructField field() {
                        return this.field;
                    }

                    @Override
                    public byte applyAsByte(Tuple o) {
                        return x;
                    }

                    @Override
                    public short applyAsShort(Tuple o) {
                        return x;
                    }

                    @Override
                    public int applyAsInt(Tuple o) {
                        return x;
                    }

                    @Override
                    public long applyAsLong(Tuple o) {
                        return x;
                    }

                    @Override
                    public float applyAsFloat(Tuple o) {
                        return x;
                    }

                    @Override
                    public double applyAsDouble(Tuple o) {
                        return x;
                    }

                    @Override
                    public Object apply(Tuple o) {
                        return x;
                    }
                };
                return Collections.singletonList(feature);
            }
        };
    }

    public static Term val(final short x) {
        return new Constant(){

            public String toString() {
                return String.valueOf(x);
            }

            @Override
            public List<Feature> bind(StructType schema) {
                Feature feature = new Feature(){
                    private final StructField field;
                    {
                        this.field = new StructField(String.valueOf(x), DataTypes.ShortType, null);
                    }

                    @Override
                    public StructField field() {
                        return this.field;
                    }

                    @Override
                    public short applyAsShort(Tuple o) {
                        return x;
                    }

                    @Override
                    public int applyAsInt(Tuple o) {
                        return x;
                    }

                    @Override
                    public long applyAsLong(Tuple o) {
                        return x;
                    }

                    @Override
                    public float applyAsFloat(Tuple o) {
                        return x;
                    }

                    @Override
                    public double applyAsDouble(Tuple o) {
                        return x;
                    }

                    @Override
                    public Object apply(Tuple o) {
                        return x;
                    }
                };
                return Collections.singletonList(feature);
            }
        };
    }

    public static Term val(final int x) {
        return new Constant(){

            public String toString() {
                return String.valueOf(x);
            }

            @Override
            public List<Feature> bind(StructType schema) {
                Feature feature = new Feature(){
                    private final StructField field;
                    {
                        this.field = new StructField(String.valueOf(x), DataTypes.IntegerType, null);
                    }

                    @Override
                    public StructField field() {
                        return this.field;
                    }

                    @Override
                    public int applyAsInt(Tuple o) {
                        return x;
                    }

                    @Override
                    public long applyAsLong(Tuple o) {
                        return x;
                    }

                    @Override
                    public float applyAsFloat(Tuple o) {
                        return x;
                    }

                    @Override
                    public double applyAsDouble(Tuple o) {
                        return x;
                    }

                    @Override
                    public Object apply(Tuple o) {
                        return x;
                    }
                };
                return Collections.singletonList(feature);
            }
        };
    }

    public static Term val(final long x) {
        return new Constant(){

            public String toString() {
                return String.valueOf(x);
            }

            @Override
            public List<Feature> bind(StructType schema) {
                Feature feature = new Feature(){
                    private final StructField field;
                    {
                        this.field = new StructField(String.valueOf(x), DataTypes.LongType, null);
                    }

                    @Override
                    public StructField field() {
                        return this.field;
                    }

                    @Override
                    public long applyAsLong(Tuple o) {
                        return x;
                    }

                    @Override
                    public float applyAsFloat(Tuple o) {
                        return x;
                    }

                    @Override
                    public double applyAsDouble(Tuple o) {
                        return x;
                    }

                    @Override
                    public Object apply(Tuple o) {
                        return x;
                    }
                };
                return Collections.singletonList(feature);
            }
        };
    }

    public static Term val(final float x) {
        return new Constant(){

            public String toString() {
                return String.valueOf(x);
            }

            @Override
            public List<Feature> bind(StructType schema) {
                Feature feature = new Feature(){
                    private final StructField field;
                    {
                        this.field = new StructField(String.valueOf(x), DataTypes.FloatType, null);
                    }

                    @Override
                    public StructField field() {
                        return this.field;
                    }

                    @Override
                    public float applyAsFloat(Tuple o) {
                        return x;
                    }

                    @Override
                    public double applyAsDouble(Tuple o) {
                        return x;
                    }

                    @Override
                    public Object apply(Tuple o) {
                        return Float.valueOf(x);
                    }
                };
                return Collections.singletonList(feature);
            }
        };
    }

    public static Term val(final double x) {
        return new Constant(){

            public String toString() {
                return String.valueOf(x);
            }

            @Override
            public List<Feature> bind(StructType schema) {
                Feature feature = new Feature(){
                    private final StructField field;
                    {
                        this.field = new StructField(String.valueOf(x), DataTypes.DoubleType, null);
                    }

                    @Override
                    public StructField field() {
                        return this.field;
                    }

                    @Override
                    public double applyAsDouble(Tuple o) {
                        return x;
                    }

                    @Override
                    public Object apply(Tuple o) {
                        return x;
                    }
                };
                return Collections.singletonList(feature);
            }
        };
    }

    public static Term val(final Object x) {
        return new Constant(){

            public String toString() {
                return String.valueOf(x);
            }

            @Override
            public List<Feature> bind(StructType schema) {
                Feature feature = new Feature(){
                    private final StructField field;
                    {
                        this.field = new StructField(String.valueOf(x), DataType.of(x.getClass()), null);
                    }

                    @Override
                    public StructField field() {
                        return this.field;
                    }

                    @Override
                    public Object apply(Tuple o) {
                        return x;
                    }
                };
                return Collections.singletonList(feature);
            }
        };
    }

    public static <T> Term of(String name, String x, ToIntFunction<T> f) {
        return Terms.of(name, Terms.$(x), f);
    }

    public static <T> Term of(String name, Term x, final ToIntFunction<T> f) {
        return new AbstractFunction(name, x){

            @Override
            public List<Feature> bind(StructType schema) {
                ArrayList<Feature> features = new ArrayList<Feature>();
                for (final Feature feature : this.x.bind(schema)) {
                    features.add(new Feature(){
                        private final StructField field;
                        {
                            this.field = new StructField(String.format("%s(%s)", name, feature), DataTypes.IntegerType, null);
                        }

                        @Override
                        public StructField field() {
                            return this.field;
                        }

                        @Override
                        public int applyAsInt(Tuple o) {
                            return f.applyAsInt(feature.apply(o));
                        }

                        @Override
                        public long applyAsLong(Tuple o) {
                            return f.applyAsInt(feature.apply(o));
                        }

                        @Override
                        public float applyAsFloat(Tuple o) {
                            return f.applyAsInt(feature.apply(o));
                        }

                        @Override
                        public double applyAsDouble(Tuple o) {
                            return f.applyAsInt(feature.apply(o));
                        }

                        @Override
                        public Object apply(Tuple o) {
                            return f.applyAsInt(feature.apply(o));
                        }
                    });
                }
                return features;
            }
        };
    }

    public static <T> Term of(String name, String x, ToLongFunction<T> f) {
        return Terms.of(name, Terms.$(x), f);
    }

    public static <T> Term of(String name, Term x, final ToLongFunction<T> f) {
        return new AbstractFunction(name, x){

            @Override
            public List<Feature> bind(StructType schema) {
                ArrayList<Feature> features = new ArrayList<Feature>();
                for (final Feature feature : this.x.bind(schema)) {
                    features.add(new Feature(){
                        private final StructField field;
                        {
                            this.field = new StructField(String.format("%s(%s)", name, feature), DataTypes.LongType, null);
                        }

                        @Override
                        public StructField field() {
                            return this.field;
                        }

                        @Override
                        public long applyAsLong(Tuple o) {
                            return f.applyAsLong(feature.apply(o));
                        }

                        @Override
                        public float applyAsFloat(Tuple o) {
                            return f.applyAsLong(feature.apply(o));
                        }

                        @Override
                        public double applyAsDouble(Tuple o) {
                            return f.applyAsLong(feature.apply(o));
                        }

                        @Override
                        public Object apply(Tuple o) {
                            return f.applyAsLong(feature.apply(o));
                        }
                    });
                }
                return features;
            }
        };
    }

    public static <T> Term of(String name, String x, ToDoubleFunction<T> f) {
        return Terms.of(name, Terms.$(x), f);
    }

    public static <T> Term of(String name, Term x, final ToDoubleFunction<T> f) {
        return new AbstractFunction(name, x){

            @Override
            public List<Feature> bind(StructType schema) {
                ArrayList<Feature> features = new ArrayList<Feature>();
                for (final Feature feature : this.x.bind(schema)) {
                    features.add(new Feature(){
                        private final StructField field;
                        {
                            this.field = new StructField(String.format("%s(%s)", name, feature), DataTypes.DoubleType, null);
                        }

                        @Override
                        public StructField field() {
                            return this.field;
                        }

                        @Override
                        public double applyAsDouble(Tuple o) {
                            return f.applyAsDouble(feature.apply(o));
                        }

                        @Override
                        public Object apply(Tuple o) {
                            return f.applyAsDouble(feature.apply(o));
                        }
                    });
                }
                return features;
            }
        };
    }

    public static <T, R> Term of(String name, String x, Class<R> clazz, Function<T, R> f) {
        return Terms.of(name, Terms.$(x), clazz, f);
    }

    public static <T, R> Term of(String name, Term x, final Class<R> clazz, final Function<T, R> f) {
        return new AbstractFunction(name, x){

            @Override
            public List<Feature> bind(StructType schema) {
                ArrayList<Feature> features = new ArrayList<Feature>();
                for (final Feature feature : this.x.bind(schema)) {
                    features.add(new Feature(){
                        private final StructField field;
                        {
                            this.field = new StructField(String.format("%s(%s)", name, feature), DataTypes.object(clazz), null);
                        }

                        @Override
                        public StructField field() {
                            return this.field;
                        }

                        @Override
                        public Object apply(Tuple o) {
                            return f.apply(feature.apply(o));
                        }
                    });
                }
                return features;
            }
        };
    }

    public static <T, U> Term of(String name, String x, String y, ToIntBiFunction<T, U> f) {
        return Terms.of(name, Terms.$(x), Terms.$(y), f);
    }

    public static <T, U> Term of(String name, Term x, Term y, final ToIntBiFunction<T, U> f) {
        return new AbstractBiFunction(name, x, y){

            @Override
            public List<Feature> bind(StructType schema) {
                ArrayList<Feature> features = new ArrayList<Feature>();
                List<Feature> xfeatures = this.x.bind(schema);
                List<Feature> yfeatures = this.y.bind(schema);
                if (xfeatures.size() != yfeatures.size()) {
                    throw new IllegalStateException(String.format("The features of %s and %s are of different size: %d != %d", this.x, this.y, xfeatures.size(), yfeatures.size()));
                }
                for (int i = 0; i < xfeatures.size(); ++i) {
                    final Feature a = xfeatures.get(i);
                    final StructField xfield = a.field();
                    final Feature b = yfeatures.get(i);
                    final StructField yfield = b.field();
                    features.add(new Feature(){
                        final StructField field;
                        {
                            this.field = new StructField(String.format("%s(%s, %s)", name, xfield.name, yfield.name), DataTypes.IntegerType, null);
                        }

                        @Override
                        public StructField field() {
                            return this.field;
                        }

                        @Override
                        public int applyAsInt(Tuple o) {
                            return f.applyAsInt(a.apply(o), b.apply(o));
                        }

                        @Override
                        public Object apply(Tuple o) {
                            Object x = a.apply(o);
                            Object y = b.apply(o);
                            if (x == null || y == null) {
                                return null;
                            }
                            return f.applyAsInt(a.apply(o), b.apply(o));
                        }
                    });
                }
                return features;
            }
        };
    }

    public static <T, U> Term of(String name, String x, String y, ToLongBiFunction<T, U> f) {
        return Terms.of(name, Terms.$(x), Terms.$(y), f);
    }

    public static <T, U> Term of(String name, Term x, Term y, final ToLongBiFunction<T, U> f) {
        return new AbstractBiFunction(name, x, y){

            @Override
            public List<Feature> bind(StructType schema) {
                ArrayList<Feature> features = new ArrayList<Feature>();
                List<Feature> xfeatures = this.x.bind(schema);
                List<Feature> yfeatures = this.y.bind(schema);
                if (xfeatures.size() != yfeatures.size()) {
                    throw new IllegalStateException(String.format("The features of %s and %s are of different size: %d != %d", this.x, this.y, xfeatures.size(), yfeatures.size()));
                }
                for (int i = 0; i < xfeatures.size(); ++i) {
                    final Feature a = xfeatures.get(i);
                    final StructField xfield = a.field();
                    final Feature b = yfeatures.get(i);
                    final StructField yfield = b.field();
                    features.add(new Feature(){
                        final StructField field;
                        {
                            this.field = new StructField(String.format("%s(%s, %s)", name, xfield.name, yfield.name), DataTypes.LongType, null);
                        }

                        @Override
                        public StructField field() {
                            return this.field;
                        }

                        @Override
                        public long applyAsLong(Tuple o) {
                            return f.applyAsLong(a.apply(o), b.apply(o));
                        }

                        @Override
                        public Object apply(Tuple o) {
                            Object x = a.apply(o);
                            Object y = b.apply(o);
                            if (x == null || y == null) {
                                return null;
                            }
                            return f.applyAsLong(a.apply(o), b.apply(o));
                        }
                    });
                }
                return features;
            }
        };
    }

    public static <T, U> Term of(String name, String x, String y, ToDoubleBiFunction<T, U> f) {
        return Terms.of(name, Terms.$(x), Terms.$(y), f);
    }

    public static <T, U> Term of(String name, Term x, Term y, final ToDoubleBiFunction<T, U> f) {
        return new AbstractBiFunction(name, x, y){

            @Override
            public List<Feature> bind(StructType schema) {
                ArrayList<Feature> features = new ArrayList<Feature>();
                List<Feature> xfeatures = this.x.bind(schema);
                List<Feature> yfeatures = this.y.bind(schema);
                if (xfeatures.size() != yfeatures.size()) {
                    throw new IllegalStateException(String.format("The features of %s and %s are of different size: %d != %d", this.x, this.y, xfeatures.size(), yfeatures.size()));
                }
                for (int i = 0; i < xfeatures.size(); ++i) {
                    final Feature a = xfeatures.get(i);
                    final StructField xfield = a.field();
                    final Feature b = yfeatures.get(i);
                    final StructField yfield = b.field();
                    features.add(new Feature(){
                        final StructField field;
                        {
                            this.field = new StructField(String.format("%s(%s, %s)", name, xfield.name, yfield.name), DataTypes.DoubleType, null);
                        }

                        @Override
                        public StructField field() {
                            return this.field;
                        }

                        @Override
                        public double applyAsDouble(Tuple o) {
                            return f.applyAsDouble(a.apply(o), b.apply(o));
                        }

                        @Override
                        public Object apply(Tuple o) {
                            Object x = a.apply(o);
                            Object y = b.apply(o);
                            if (x == null || y == null) {
                                return null;
                            }
                            return f.applyAsDouble(a.apply(o), b.apply(o));
                        }
                    });
                }
                return features;
            }
        };
    }

    public static <T, U, R> Term of(String name, String x, String y, Class<R> clazz, BiFunction<T, U, R> f) {
        return Terms.of(name, Terms.$(x), Terms.$(y), clazz, f);
    }

    public static <T, U, R> Term of(String name, Term x, Term y, final Class<R> clazz, final BiFunction<T, U, R> f) {
        return new AbstractBiFunction(name, x, y){

            @Override
            public List<Feature> bind(StructType schema) {
                ArrayList<Feature> features = new ArrayList<Feature>();
                List<Feature> xfeatures = this.x.bind(schema);
                List<Feature> yfeatures = this.y.bind(schema);
                if (xfeatures.size() != yfeatures.size()) {
                    throw new IllegalStateException(String.format("The features of %s and %s are of different size: %d != %d", this.x, this.y, xfeatures.size(), yfeatures.size()));
                }
                for (int i = 0; i < xfeatures.size(); ++i) {
                    final Feature a = xfeatures.get(i);
                    final StructField xfield = a.field();
                    final Feature b = yfeatures.get(i);
                    final StructField yfield = b.field();
                    features.add(new Feature(){
                        final StructField field;
                        {
                            this.field = new StructField(String.format("%s(%s, %s)", name, xfield.name, yfield.name), DataTypes.object(clazz), null);
                        }

                        @Override
                        public StructField field() {
                            return this.field;
                        }

                        @Override
                        public Object apply(Tuple o) {
                            Object x = a.apply(o);
                            Object y = b.apply(o);
                            if (x == null || y == null) {
                                return null;
                            }
                            return f.apply(a.apply(o), b.apply(o));
                        }
                    });
                }
                return features;
            }
        };
    }
}

