/*
 * Decompiled with CFR 0.152.
 */
package smile.data.vector;

import java.util.stream.Collectors;
import java.util.stream.IntStream;
import smile.data.type.DataType;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.vector.BaseVector;
import smile.data.vector.IntVectorImpl;

public interface IntVector
extends BaseVector<Integer, Integer, IntStream> {
    @Override
    default public DataType type() {
        return DataTypes.IntegerType;
    }

    public int[] array();

    public IntVector get(int ... var1);

    @Override
    default public boolean getBoolean(int i) {
        return this.getInt(i) != 0;
    }

    @Override
    default public char getChar(int i) {
        return (char)this.getInt(i);
    }

    @Override
    default public byte getByte(int i) {
        return (byte)this.getInt(i);
    }

    @Override
    default public short getShort(int i) {
        return (short)this.getInt(i);
    }

    @Override
    default public long getLong(int i) {
        return this.getInt(i);
    }

    @Override
    default public float getFloat(int i) {
        return this.getInt(i);
    }

    @Override
    default public double getDouble(int i) {
        return this.getInt(i);
    }

    default public String toString(int n) {
        String suffix = n >= this.size() ? "]" : String.format(", ... %,d more]", this.size() - n);
        return ((IntStream)this.stream()).limit(n).mapToObj(this.field()::toString).collect(Collectors.joining(", ", "[", suffix));
    }

    public static IntVector of(String name, int[] vector) {
        return new IntVectorImpl(name, vector);
    }

    public static IntVector of(String name, IntStream stream) {
        return new IntVectorImpl(name, stream.toArray());
    }

    public static IntVector of(StructField field, int[] vector) {
        return new IntVectorImpl(field, vector);
    }

    public static IntVector of(StructField field, IntStream stream) {
        return new IntVectorImpl(field, stream.toArray());
    }
}

