/*
 * Decompiled with CFR 0.152.
 */
package smile.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.csv.CSVFormat;
import smile.data.DataFrame;
import smile.data.SampleInstance;
import smile.data.SparseDataset;
import smile.data.type.StructType;
import smile.io.Arff;
import smile.io.Arrow;
import smile.io.Avro;
import smile.io.CSV;
import smile.io.HadoopInput;
import smile.io.Input;
import smile.io.JSON;
import smile.io.Parquet;
import smile.io.SAS;
import smile.util.SparseArray;
import smile.util.Strings;

public interface Read {
    public static Object object(Path path) throws IOException, ClassNotFoundException {
        InputStream file = Files.newInputStream(path, new OpenOption[0]);
        ObjectInputStream in = new ObjectInputStream(file);
        Object o = in.readObject();
        in.close();
        file.close();
        return o;
    }

    public static DataFrame data(String path) throws IOException, URISyntaxException, ParseException {
        return Read.data(path, null);
    }

    public static DataFrame data(String path, String format) throws IOException, URISyntaxException, ParseException {
        String ext;
        int dotIndex = path.lastIndexOf(".");
        switch (ext = dotIndex < 0 ? "csv" : path.substring(dotIndex + 1)) {
            case "dat": 
            case "txt": 
            case "csv": {
                return Read.csv(path, format);
            }
            case "arff": {
                return Read.arff(path);
            }
            case "json": {
                JSON.Mode mode = format == null ? JSON.Mode.SINGLE_LINE : JSON.Mode.valueOf(format);
                return Read.json(path, mode, null);
            }
            case "sas7bdat": {
                return Read.sas(path);
            }
            case "avro": {
                return Read.avro(path, format);
            }
            case "parquet": {
                return Read.parquet(path);
            }
            case "feather": {
                return Read.arrow(path);
            }
        }
        if (format != null) {
            if (format.equals("csv")) {
                return Read.csv(path);
            }
            if (format.startsWith("csv,")) {
                return Read.csv(path, format.substring(4));
            }
        }
        throw new UnsupportedOperationException("Unsupported data format: " + ext);
    }

    public static DataFrame csv(String path) throws IOException, URISyntaxException {
        return Read.csv(path, CSVFormat.DEFAULT);
    }

    public static DataFrame csv(String path, String format) throws IOException, URISyntaxException {
        CSVFormat.Builder formatBuilder = CSVFormat.Builder.create();
        block14: for (String token : format.split(",")) {
            String[] option = token.split("=");
            if (option.length != 2) {
                throw new IllegalArgumentException("Invalid csv format specifier: " + token);
            }
            switch (option[0].toLowerCase(Locale.ROOT)) {
                case "delimiter": {
                    formatBuilder.setDelimiter(Strings.unescape(option[1]));
                    continue block14;
                }
                case "quote": {
                    String quote = Strings.unescape(option[1]);
                    if (quote.length() != 1) {
                        throw new IllegalArgumentException("Unknown csv quote: " + quote);
                    }
                    formatBuilder.setQuote(quote.charAt(0));
                    continue block14;
                }
                case "escape": {
                    String escape = Strings.unescape(option[1]);
                    if (escape.length() != 1) {
                        throw new IllegalArgumentException("Unknown csv escape: " + escape);
                    }
                    formatBuilder.setEscape(escape.charAt(0));
                    continue block14;
                }
                case "comment": {
                    String comment = Strings.unescape(option[1]);
                    if (comment.length() != 1) {
                        throw new IllegalArgumentException("Unknown csv comment marker: " + comment);
                    }
                    formatBuilder.setCommentMarker(comment.charAt(0));
                    continue block14;
                }
                case "header": {
                    if ("true".equalsIgnoreCase(option[1])) {
                        formatBuilder.setHeader(new String[0]).setSkipHeaderRecord(true);
                        continue block14;
                    }
                    String[] header = option[1].split("\\|");
                    formatBuilder.setHeader(header);
                    continue block14;
                }
                default: {
                    throw new IllegalArgumentException("Unknown csv format specifier: " + option[0]);
                }
            }
        }
        return Read.csv(path, formatBuilder.build());
    }

    public static DataFrame csv(String path, CSVFormat format) throws IOException, URISyntaxException {
        return Read.csv(path, format, null);
    }

    public static DataFrame csv(String path, CSVFormat format, StructType schema) throws IOException, URISyntaxException {
        CSV csv = new CSV(format);
        if (schema != null) {
            csv.schema(schema);
        }
        return csv.read(path);
    }

    public static DataFrame csv(Path path) throws IOException {
        return Read.csv(path, CSVFormat.DEFAULT);
    }

    public static DataFrame csv(Path path, CSVFormat format) throws IOException {
        return Read.csv(path, format, null);
    }

    public static DataFrame csv(Path path, CSVFormat format, StructType schema) throws IOException {
        CSV csv = new CSV(format);
        if (schema != null) {
            csv.schema(schema);
        }
        return csv.read(path);
    }

    public static DataFrame json(String path) throws IOException, URISyntaxException {
        return Read.json(path, JSON.Mode.SINGLE_LINE, null);
    }

    public static DataFrame json(String path, JSON.Mode mode, StructType schema) throws IOException, URISyntaxException {
        JSON json = new JSON().mode(mode);
        if (schema != null) {
            json.schema(schema);
        }
        return json.read(path);
    }

    public static DataFrame json(Path path) throws IOException {
        return Read.json(path, JSON.Mode.SINGLE_LINE, null);
    }

    public static DataFrame json(Path path, JSON.Mode mode, StructType schema) throws IOException {
        JSON json = new JSON().mode(mode);
        if (schema != null) {
            json.schema(schema);
        }
        return json.read(path);
    }

    public static DataFrame arff(String path) throws IOException, ParseException, URISyntaxException {
        try (Arff arff = new Arff(path);){
            DataFrame dataFrame = arff.read();
            return dataFrame;
        }
    }

    public static DataFrame arff(Path path) throws IOException, ParseException {
        try (Arff arff = new Arff(path);){
            DataFrame dataFrame = arff.read();
            return dataFrame;
        }
    }

    public static DataFrame sas(String path) throws IOException, URISyntaxException {
        return SAS.read(path);
    }

    public static DataFrame sas(Path path) throws IOException {
        return SAS.read(path);
    }

    public static DataFrame arrow(String path) throws IOException, URISyntaxException {
        Arrow arrow = new Arrow();
        return arrow.read(path);
    }

    public static DataFrame arrow(Path path) throws IOException {
        Arrow arrow = new Arrow();
        return arrow.read(path);
    }

    public static DataFrame avro(String path, InputStream schema) throws IOException, URISyntaxException {
        Avro avro = new Avro(schema);
        return avro.read(path);
    }

    public static DataFrame avro(String path, String schema) throws IOException, URISyntaxException {
        Avro avro = new Avro(HadoopInput.stream(schema));
        return avro.read(path);
    }

    public static DataFrame avro(Path path, InputStream schema) throws IOException {
        Avro avro = new Avro(schema);
        return avro.read(path);
    }

    public static DataFrame avro(Path path, Path schema) throws IOException {
        Avro avro = new Avro(schema);
        return avro.read(path);
    }

    public static DataFrame parquet(String path) throws IOException, URISyntaxException {
        return Parquet.read(path);
    }

    public static DataFrame parquet(Path path) throws IOException {
        return Parquet.read(path);
    }

    public static SparseDataset<Integer> libsvm(String path) throws IOException, URISyntaxException {
        return Read.libsvm(Input.reader(path));
    }

    public static SparseDataset<Integer> libsvm(Path path) throws IOException {
        return Read.libsvm(Files.newBufferedReader(path));
    }

    public static SparseDataset<Integer> libsvm(BufferedReader reader) throws IOException {
        try (BufferedReader bufferedReader = reader;){
            ArrayList data = new ArrayList();
            String line = reader.readLine();
            while (line != null) {
                String[] tokens = line.trim().split("\\s+");
                int y = Integer.parseInt(tokens[0]);
                SparseArray row = new SparseArray();
                for (int k = 1; k < tokens.length; ++k) {
                    String[] pair = tokens[k].split(":");
                    if (pair.length != 2) {
                        throw new NumberFormatException("Invalid token: " + tokens[k]);
                    }
                    int j = Integer.parseInt(pair[0]) - 1;
                    double x = Double.parseDouble(pair[1]);
                    row.set(j, x);
                }
                data.add(new SampleInstance<SparseArray, Integer>(row, y));
                line = reader.readLine();
            }
            SparseDataset<Integer> sparseDataset = SparseDataset.of(data);
            return sparseDataset;
        }
    }
}

