/*
 * Decompiled with CFR 0.152.
 */
package smile.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.data.BinarySparseDataset;
import smile.data.SampleInstance;
import smile.math.MathEx;
import smile.math.matrix.SparseMatrix;

class BinarySparseDatasetImpl<T>
implements BinarySparseDataset<T> {
    private static final Logger logger = LoggerFactory.getLogger(BinarySparseDatasetImpl.class);
    private final ArrayList<SampleInstance<int[], T>> instances;
    private int n;
    private final int ncol;
    private final int[] colSize;

    public BinarySparseDatasetImpl(Collection<SampleInstance<int[], T>> data) {
        this.instances = new ArrayList<SampleInstance<int[], T>>(data);
        int p = 0;
        for (SampleInstance<int[], T> instance : this.instances) {
            p = Math.max(p, MathEx.max(instance.x()));
        }
        this.ncol = p + 1;
        this.colSize = new int[this.ncol];
        for (SampleInstance<int[], T> instance : this.instances) {
            int[] x = instance.x();
            Arrays.sort(x);
            int prev = -1;
            for (int xi : x) {
                if (xi < 0) {
                    throw new IllegalArgumentException(String.format("Negative index of nonzero element: %d", xi));
                }
                if (xi == prev) {
                    logger.warn("Ignore duplicated indices: {} in {}", (Object)xi, (Object)Arrays.toString(x));
                    continue;
                }
                int n = xi;
                this.colSize[n] = this.colSize[n] + 1;
                ++this.n;
                prev = xi;
            }
        }
    }

    @Override
    public int size() {
        return this.instances.size();
    }

    @Override
    public int length() {
        return this.n;
    }

    @Override
    public int ncol() {
        return this.ncol;
    }

    @Override
    public SampleInstance<int[], T> get(int i) {
        return this.instances.get(i);
    }

    @Override
    public Stream<SampleInstance<int[], T>> stream() {
        return this.instances.stream();
    }

    @Override
    public Iterator<SampleInstance<int[], T>> iterator() {
        return this.instances.iterator();
    }

    @Override
    public SparseMatrix toMatrix() {
        int[] pos = new int[this.ncol];
        int[] colIndex = new int[this.ncol + 1];
        for (int i = 0; i < this.ncol; ++i) {
            colIndex[i + 1] = colIndex[i] + this.colSize[i];
        }
        int nrow = this.instances.size();
        int[] rowIndex = new int[this.n];
        double[] x = new double[this.n];
        for (int i = 0; i < nrow; ++i) {
            for (int j : this.instances.get(i).x()) {
                int k = colIndex[j] + pos[j];
                rowIndex[k] = i;
                x[k] = 1.0;
                int n = j;
                pos[n] = pos[n] + 1;
            }
        }
        return new SparseMatrix(nrow, this.ncol, x, rowIndex, colIndex);
    }
}

