/*
 * Decompiled with CFR 0.152.
 */
package smile.data.vector;

import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import smile.data.type.DataType;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.vector.BaseVector;
import smile.data.vector.DoubleVectorImpl;
import smile.math.MathEx;

public interface DoubleVector
extends BaseVector<Double, Double, DoubleStream> {
    @Override
    default public DataType type() {
        return DataTypes.DoubleType;
    }

    public double[] array();

    public DoubleVector get(int ... var1);

    @Override
    default public boolean getBoolean(int i) {
        return MathEx.isZero(this.getDouble(i));
    }

    @Override
    default public char getChar(int i) {
        return (char)this.getDouble(i);
    }

    @Override
    default public byte getByte(int i) {
        return (byte)this.getDouble(i);
    }

    @Override
    default public short getShort(int i) {
        return (short)this.getDouble(i);
    }

    @Override
    default public int getInt(int i) {
        return (int)this.getDouble(i);
    }

    @Override
    default public long getLong(int i) {
        return (long)this.getDouble(i);
    }

    @Override
    default public float getFloat(int i) {
        return (float)this.getDouble(i);
    }

    default public String toString(int n) {
        String suffix = n >= this.size() ? "]" : String.format(", ... %,d more]", this.size() - n);
        return ((DoubleStream)this.stream()).limit(n).mapToObj(this.field()::toString).collect(Collectors.joining(", ", "[", suffix));
    }

    public void fillna(double var1);

    public static DoubleVector of(String name, double[] vector) {
        return new DoubleVectorImpl(name, vector);
    }

    public static DoubleVector of(String name, DoubleStream stream) {
        return new DoubleVectorImpl(name, stream.toArray());
    }

    public static DoubleVector of(StructField field, double[] vector) {
        return new DoubleVectorImpl(field, vector);
    }

    public static DoubleVector of(StructField field, DoubleStream stream) {
        return new DoubleVectorImpl(field, stream.toArray());
    }
}

