/*
 * Decompiled with CFR 0.152.
 */
package smile.data.vector;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import smile.data.measure.CategoricalMeasure;
import smile.data.measure.NominalScale;
import smile.data.type.StructField;
import smile.data.vector.BaseVector;
import smile.data.vector.StringVectorImpl;
import smile.data.vector.Vector;

public interface StringVector
extends Vector<String> {
    @Override
    public StringVector get(int ... var1);

    @Override
    default public boolean getBoolean(int i) {
        return Boolean.parseBoolean((String)this.get(i));
    }

    @Override
    default public char getChar(int i) {
        String s = (String)this.get(i);
        return s.isEmpty() ? (char)'\u0000' : s.charAt(0);
    }

    @Override
    default public byte getByte(int i) {
        return Byte.parseByte((String)this.get(i));
    }

    @Override
    default public short getShort(int i) {
        return Short.parseShort((String)this.get(i));
    }

    @Override
    default public int getInt(int i) {
        return Integer.parseInt((String)this.get(i));
    }

    @Override
    default public long getLong(int i) {
        return Long.parseLong((String)this.get(i));
    }

    @Override
    default public float getFloat(int i) {
        return Float.parseFloat((String)this.get(i));
    }

    @Override
    default public double getDouble(int i) {
        return Double.parseDouble((String)this.get(i));
    }

    default public Vector<LocalDate> toDate(String pattern) {
        return this.toDate(DateTimeFormatter.ofPattern(pattern));
    }

    public Vector<LocalDate> toDate(DateTimeFormatter var1);

    default public Vector<LocalTime> toTime(String pattern) {
        return this.toTime(DateTimeFormatter.ofPattern(pattern));
    }

    public Vector<LocalTime> toTime(DateTimeFormatter var1);

    default public Vector<LocalDateTime> toDateTime(String pattern) {
        return this.toDateTime(DateTimeFormatter.ofPattern(pattern));
    }

    public Vector<LocalDateTime> toDateTime(DateTimeFormatter var1);

    public NominalScale nominal();

    public BaseVector factorize(CategoricalMeasure var1);

    @Override
    default public String toString(int n) {
        String suffix = n >= this.size() ? "]" : String.format(", ... %,d more]", this.size() - n);
        return ((Stream)this.stream()).limit(n).collect(Collectors.joining(", ", "[", suffix));
    }

    public static StringVector of(String name, String ... vector) {
        return new StringVectorImpl(name, vector);
    }

    public static StringVector of(StructField field, String ... vector) {
        return new StringVectorImpl(field, vector);
    }
}

