/*
 * Decompiled with CFR 0.152.
 */
package smile.data.vector;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import smile.data.type.DataType;
import smile.data.type.StructField;
import smile.data.vector.BaseVector;
import smile.data.vector.VectorImpl;

public interface Vector<T>
extends BaseVector<T, T, Stream<T>> {
    public Vector<T> get(int ... var1);

    public T[] toArray();

    public Vector<LocalDate> toDate();

    public Vector<LocalTime> toTime();

    public Vector<LocalDateTime> toDateTime();

    default public List<T> distinct() {
        return ((Stream)this.stream()).distinct().collect(Collectors.toList());
    }

    @Override
    default public boolean getBoolean(int i) {
        return (Boolean)this.get(i);
    }

    @Override
    default public char getChar(int i) {
        return ((Character)this.get(i)).charValue();
    }

    @Override
    default public byte getByte(int i) {
        return ((Number)this.get(i)).byteValue();
    }

    @Override
    default public short getShort(int i) {
        return ((Number)this.get(i)).shortValue();
    }

    @Override
    default public int getInt(int i) {
        return ((Number)this.get(i)).intValue();
    }

    @Override
    default public long getLong(int i) {
        return ((Number)this.get(i)).longValue();
    }

    @Override
    default public float getFloat(int i) {
        Number x = (Number)this.get(i);
        return x == null ? Float.NaN : x.floatValue();
    }

    @Override
    default public double getDouble(int i) {
        Number x = (Number)this.get(i);
        return x == null ? Double.NaN : x.doubleValue();
    }

    default public boolean isNullAt(int i) {
        return this.get(i) == null;
    }

    default public boolean anyNull() {
        return ((Stream)this.stream()).anyMatch(Objects::isNull);
    }

    default public String toString(int n) {
        String suffix = n >= this.size() ? "]" : String.format(", ... %,d more]", this.size() - n);
        return ((Stream)this.stream()).limit(n).map(this.field()::toString).collect(Collectors.joining(", ", "[", suffix));
    }

    public static <T> Vector<T> of(String name, Class<?> clazz, T[] vector) {
        return new VectorImpl<T>(name, clazz, vector);
    }

    public static <T> Vector<T> of(String name, DataType type, T[] vector) {
        return new VectorImpl<T>(name, type, vector);
    }

    public static <T> Vector<T> of(StructField field, T[] vector) {
        return new VectorImpl<T>(field, vector);
    }
}

