/*
 * Decompiled with CFR 0.152.
 */
package smile.io;

import java.io.IOException;
import java.io.Reader;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import smile.data.DataFrame;
import smile.data.Tuple;
import smile.data.type.DataType;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.type.StructType;
import smile.io.Input;

public class CSV {
    private StructType schema;
    private final CSVFormat format;
    private Charset charset = StandardCharsets.UTF_8;

    public CSV() {
        this(CSVFormat.DEFAULT);
    }

    public CSV(CSVFormat format) {
        this.format = format;
    }

    public CSV schema(StructType schema) {
        this.schema = schema;
        return this;
    }

    public CSV charset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public DataFrame read(String path) throws IOException, URISyntaxException {
        return this.read(path, Integer.MAX_VALUE);
    }

    public DataFrame read(String path, int limit) throws IOException, URISyntaxException {
        if (this.schema == null) {
            this.schema = this.inferSchema(Input.reader(path, this.charset), Math.min(1000, limit));
        }
        return this.read(Input.reader(path, this.charset), limit);
    }

    public DataFrame read(Path path) throws IOException {
        return this.read(path, Integer.MAX_VALUE);
    }

    public DataFrame read(Path path, int limit) throws IOException {
        if (this.schema == null) {
            this.schema = this.inferSchema(Files.newBufferedReader(path, this.charset), Math.min(1000, limit));
        }
        return this.read(Files.newBufferedReader(path, this.charset), limit);
    }

    private DataFrame read(Reader reader, int limit) throws IOException {
        if (this.schema == null) {
            throw new IllegalStateException("The schema is not set or inferred.");
        }
        StructField[] fields = this.schema.fields();
        List<Function<String, Object>> parser = this.schema.parser();
        try (CSVParser csv = CSVParser.parse((Reader)reader, (CSVFormat)this.format);){
            ArrayList<Tuple> rows = new ArrayList<Tuple>();
            for (CSVRecord record : csv) {
                Object[] row = new Object[fields.length];
                for (int i = 0; i < fields.length; ++i) {
                    String s = record.get(i).trim();
                    if (s.isEmpty()) continue;
                    row[i] = parser.get(i).apply(s);
                }
                rows.add(Tuple.of(row, this.schema));
                if (rows.size() < limit) continue;
                break;
            }
            this.schema = this.schema.boxed(rows);
            DataFrame dataFrame = DataFrame.of(rows, this.schema);
            return dataFrame;
        }
    }

    public StructType inferSchema(Reader reader, int limit) throws IOException {
        try (CSVParser parser = CSVParser.parse((Reader)reader, (CSVFormat)this.format);){
            int i;
            DataType[] types;
            String[] names;
            Map header = parser.getHeaderMap();
            if (header != null) {
                names = new String[header.size()];
                types = new DataType[header.size()];
                for (Map.Entry column : header.entrySet()) {
                    names[((Integer)column.getValue()).intValue()] = (String)column.getKey();
                }
            } else {
                Iterator iter = parser.iterator();
                if (!iter.hasNext()) {
                    throw new IOException("Empty file");
                }
                CSVRecord record = (CSVRecord)iter.next();
                names = new String[record.size()];
                types = new DataType[record.size()];
                for (i = 0; i < names.length; ++i) {
                    names[i] = String.format("V%d", i + 1);
                    types[i] = DataType.infer(record.get(i).trim());
                }
            }
            int k = 0;
            for (CSVRecord record : parser) {
                for (int i2 = 0; i2 < names.length; ++i2) {
                    types[i2] = DataType.coerce(types[i2], DataType.infer(record.get(i2).trim()));
                }
                if (++k < limit) continue;
                break;
            }
            StructField[] fields = new StructField[names.length];
            for (i = 0; i < fields.length; ++i) {
                fields[i] = new StructField(names[i], types[i] == null ? DataTypes.StringType : types[i]);
            }
            StructType structType = DataTypes.struct(fields);
            return structType;
        }
    }

    public void write(DataFrame data, Path path) throws IOException {
        int p = data.schema().length();
        String[] header = new String[p];
        for (int i = 0; i < p; ++i) {
            header[i] = data.schema().field((int)i).name;
        }
        ArrayList<String> record = new ArrayList<String>(p);
        try (CSVPrinter printer = this.format.print(path, this.charset);){
            printer.printRecord((Object[])header);
            for (int i = 0; i < data.size(); ++i) {
                Tuple row = data.get(i);
                for (int j = 0; j < p; ++j) {
                    record.add(row.getString(j));
                }
                printer.printRecord(record);
                record.clear();
            }
        }
    }
}

