/*
 * Decompiled with CFR 0.152.
 */
package smile.stat.distribution;

import smile.math.MathEx;
import smile.math.special.Erf;
import smile.stat.distribution.Distribution;
import smile.stat.distribution.GaussianDistribution;

public class LogNormalDistribution
implements Distribution {
    private static final long serialVersionUID = 2L;
    public final double mu;
    public final double sigma;
    public final double mean;
    private final double variance;
    private final double entropy;
    private GaussianDistribution gaussian;

    public LogNormalDistribution(double mu, double sigma) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("Invalid sigma: " + sigma);
        }
        this.mu = mu;
        this.sigma = sigma;
        this.mean = Math.exp(mu + sigma * sigma / 2.0);
        this.variance = (Math.exp(mu * mu) - 1.0) * Math.exp(2.0 * mu + sigma * sigma);
        this.entropy = 0.5 + 0.5 * Math.log(Math.PI * 2 * sigma * sigma) + mu;
    }

    public static LogNormalDistribution fit(double[] data) {
        double[] x = new double[data.length];
        for (int i = 0; i < x.length; ++i) {
            if (data[i] <= 0.0) {
                throw new IllegalArgumentException("Invalid input data: " + data[i]);
            }
            x[i] = Math.log(data[i]);
        }
        double mu = MathEx.mean(x);
        double sigma = MathEx.sd(x);
        return new LogNormalDistribution(mu, sigma);
    }

    @Override
    public int length() {
        return 2;
    }

    @Override
    public double mean() {
        return this.mean;
    }

    @Override
    public double variance() {
        return this.variance;
    }

    @Override
    public double entropy() {
        return this.entropy;
    }

    public String toString() {
        return String.format("Log Normal Distribution(%.4f, %.4f)", this.mu, this.sigma);
    }

    @Override
    public double rand() {
        if (this.gaussian == null) {
            this.gaussian = new GaussianDistribution(this.mu, this.sigma);
        }
        return Math.exp(this.gaussian.rand());
    }

    @Override
    public double p(double x) {
        if (x < 0.0) {
            throw new IllegalArgumentException("Invalid x: " + x);
        }
        if (x == 0.0) {
            return 0.0;
        }
        double t2 = (Math.log(x) - this.mu) / this.sigma;
        return 0.3989422804014327 / (this.sigma * x) * Math.exp(-0.5 * t2 * t2);
    }

    @Override
    public double logp(double x) {
        return Math.log(this.p(x));
    }

    @Override
    public double cdf(double x) {
        if (x < 0.0) {
            throw new IllegalArgumentException("Invalid x: " + x);
        }
        if (x == 0.0) {
            return 0.0;
        }
        return 0.5 * Erf.erfc(-0.7071067811865476 * (Math.log(x) - this.mu) / this.sigma);
    }

    @Override
    public double quantile(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("Invalid p: " + p);
        }
        return Math.exp(-1.4142135623730951 * this.sigma * Erf.inverfc(2.0 * p) + this.mu);
    }
}

