/*
 * Decompiled with CFR 0.152.
 */
package smile.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import smile.sort.QuickSort;
import smile.util.ArrayElementConsumer;
import smile.util.ArrayElementFunction;
import smile.util.DoubleArrayList;
import smile.util.IntArrayList;
import smile.util.Strings;

public class SparseArray
implements Iterable<Entry>,
Serializable {
    private static final long serialVersionUID = 2L;
    private final IntArrayList index;
    private final DoubleArrayList value;

    public SparseArray() {
        this(10);
    }

    public SparseArray(int initialCapacity) {
        this.index = new IntArrayList(initialCapacity);
        this.value = new DoubleArrayList(initialCapacity);
    }

    public SparseArray(Collection<Entry> entries) {
        this.index = new IntArrayList(entries.size());
        this.value = new DoubleArrayList(entries.size());
        for (Entry e : entries) {
            this.index.add(e.index);
            this.value.add(e.value);
        }
    }

    public SparseArray(Stream<Entry> stream) {
        this(stream.collect(Collectors.toList()));
    }

    public String toString() {
        String suffix = this.size() > 10 ? ", ...]" : "]";
        return this.stream().limit(10L).map(Entry::toString).collect(Collectors.joining(", ", "[", suffix));
    }

    public int size() {
        return this.index.size();
    }

    public boolean isEmpty() {
        return this.index.isEmpty();
    }

    public void forEach(ArrayElementConsumer action) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            action.apply(this.index.get(i), this.value.get(i));
        }
    }

    public DoubleStream map(ArrayElementFunction mapper) {
        return IntStream.range(0, this.size()).mapToDouble(i -> mapper.apply(this.index.get(i), this.value.get(i)));
    }

    public void update(ArrayElementFunction mapper) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            this.value.set(i, mapper.apply(this.index.get(i), this.value.get(i)));
        }
    }

    @Override
    public Iterator<Entry> iterator() {
        return new Iterator<Entry>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < SparseArray.this.size();
            }

            @Override
            public Entry next() {
                Entry e = new Entry(SparseArray.this.index.get(this.i), SparseArray.this.value.get(this.i));
                ++this.i;
                return e;
            }
        };
    }

    public Stream<Entry> stream() {
        return IntStream.range(0, this.size()).mapToObj(i -> new Entry(this.index.get(i), this.value.get(i)));
    }

    public IntStream indexStream() {
        return this.index.stream();
    }

    public DoubleStream valueStream() {
        return this.value.stream();
    }

    public void sort() {
        QuickSort.sort(this.index.data, this.value.data, this.size());
    }

    public double get(int i) {
        int length = this.size();
        for (int k = 0; k < length; ++k) {
            if (this.index.get(k) != i) continue;
            return this.value.get(k);
        }
        return 0.0;
    }

    public boolean set(int i, double x) {
        if (x == 0.0) {
            this.remove(i);
            return false;
        }
        int length = this.size();
        for (int k = 0; k < length; ++k) {
            if (this.index.get(k) != i) continue;
            this.value.set(k, x);
            return false;
        }
        this.index.add(i);
        this.value.add(x);
        return true;
    }

    public void append(int i, double x) {
        if (x != 0.0) {
            this.index.add(i);
            this.value.add(x);
        }
    }

    public void remove(int i) {
        int length = this.size();
        for (int k = 0; k < length; ++k) {
            if (this.index.get(k) != i) continue;
            this.index.remove(k);
            this.value.remove(k);
            return;
        }
    }

    public record Entry(int index, double value) implements Comparable<Entry>
    {
        @Override
        public String toString() {
            return String.format("%d:%s", this.index, Strings.format(this.value));
        }

        @Override
        public int compareTo(Entry o) {
            return Double.compare(this.value, o.value);
        }
    }
}

