/*
 * Decompiled with CFR 0.152.
 */
package smile.data;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collector;
import smile.data.DataFrame;
import smile.data.Dataset;
import smile.data.SampleInstance;
import smile.data.Tuple;
import smile.data.type.StructType;
import smile.math.matrix.Matrix;

public interface Collectors {
    public static <D, T> Collector<SampleInstance<D, T>, List<SampleInstance<D, T>>, Dataset<D, T>> toDataset() {
        return Collector.of(ArrayList::new, List::add, (c1, c2) -> {
            c1.addAll(c2);
            return c1;
        }, Dataset::of, new Collector.Characteristics[0]);
    }

    public static <T> Collector<T, List<T>, DataFrame> toDataFrame(Class<T> clazz) {
        return Collector.of(ArrayList::new, List::add, (c1, c2) -> {
            c1.addAll(c2);
            return c1;
        }, container -> DataFrame.of(clazz, container), new Collector.Characteristics[0]);
    }

    public static Collector<Tuple, List<Tuple>, DataFrame> toDataFrame(StructType schema) {
        return Collector.of(ArrayList::new, List::add, (c1, c2) -> {
            c1.addAll(c2);
            return c1;
        }, container -> DataFrame.of(schema, container), new Collector.Characteristics[0]);
    }

    public static Collector<Tuple, List<Tuple>, Matrix> toMatrix() {
        return Collector.of(ArrayList::new, List::add, (c1, c2) -> {
            c1.addAll(c2);
            return c1;
        }, container -> {
            if (container.isEmpty()) {
                throw new IllegalArgumentException("Empty list of tuples");
            }
            int nrow = container.size();
            int ncol = ((Tuple)container.getFirst()).length();
            Matrix m = new Matrix(nrow, ncol);
            for (int i = 0; i < nrow; ++i) {
                for (int j = 0; j < ncol; ++j) {
                    m.set(i, j, ((Tuple)container.get(i)).getDouble(j));
                }
            }
            return m;
        }, new Collector.Characteristics[0]);
    }
}

