/*
 * Decompiled with CFR 0.152.
 */
package smile.data.transform;

import java.util.Map;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import smile.data.AbstractTuple;
import smile.data.DataFrame;
import smile.data.Tuple;
import smile.data.transform.ColumnTransform;
import smile.data.transform.InvertibleTransform;
import smile.data.type.StructField;
import smile.data.type.StructType;
import smile.data.vector.DoubleVector;
import smile.data.vector.ValueVector;
import smile.math.Function;

public class InvertibleColumnTransform
extends ColumnTransform
implements InvertibleTransform {
    private final Map<String, Function> inverses;

    public InvertibleColumnTransform(String name, Map<String, Function> transforms, Map<String, Function> inverses) {
        super(name, transforms);
        this.inverses = inverses;
    }

    @Override
    public Tuple invert(final Tuple x) {
        return new AbstractTuple(x.schema()){

            @Override
            public Object get(int i) {
                Function inverse = InvertibleColumnTransform.this.inverses.get(this.schema.field(i).name());
                if (inverse != null) {
                    return inverse.apply(x.getDouble(i));
                }
                return x.get(i);
            }
        };
    }

    @Override
    public DataFrame invert(DataFrame data) {
        StructType schema = data.schema();
        ValueVector[] vectors = new ValueVector[schema.length()];
        IntStream.range(0, schema.length()).forEach(i -> {
            StructField field = schema.field(i);
            Function inverse = this.inverses.get(field.name());
            if (inverse != null) {
                DoubleStream stream = ((Stream)data.stream().parallel()).mapToDouble(t2 -> inverse.apply(t2.getDouble(i)));
                vectors[i] = new DoubleVector(field, stream.toArray());
            } else {
                vectors[i] = data.column(i);
            }
        });
        return new DataFrame(vectors);
    }
}

