/*
 * Decompiled with CFR 0.152.
 */
package smile.data.type;

import java.io.Serializable;
import java.sql.JDBCType;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.type.StructType;
import smile.util.Regex;
import smile.util.Strings;

public interface DataType
extends Serializable {
    public ID id();

    public String name();

    public Object valueOf(String var1);

    default public String toString(Object o) {
        return o == null ? "null" : o.toString();
    }

    default public boolean isNullable() {
        return true;
    }

    default public boolean isPrimitive() {
        return switch (this.id().ordinal()) {
            case 0, 1, 2, 3, 4, 5, 6, 7 -> true;
            default -> false;
        };
    }

    default public boolean isFloating() {
        return this.isFloat() || this.isDouble();
    }

    default public boolean isIntegral() {
        return this.isInt() || this.isLong() || this.isShort() || this.isByte();
    }

    default public boolean isNumeric() {
        return this.isFloating() || this.isIntegral() || this.isDecimal();
    }

    default public boolean isBoolean() {
        return false;
    }

    default public boolean isChar() {
        return false;
    }

    default public boolean isByte() {
        return false;
    }

    default public boolean isShort() {
        return false;
    }

    default public boolean isInt() {
        return false;
    }

    default public boolean isLong() {
        return false;
    }

    default public boolean isDecimal() {
        return false;
    }

    default public boolean isFloat() {
        return false;
    }

    default public boolean isDouble() {
        return false;
    }

    default public boolean isString() {
        return false;
    }

    default public boolean isObject() {
        return false;
    }

    public static DataType prompt(DataType a, DataType b) {
        if (!(a.isInt() || a.isLong() || a.isFloat() || a.isDouble())) {
            throw new IllegalArgumentException(String.format("Invalid data type for type promotion: %s", a));
        }
        if (!(b.isInt() || b.isLong() || b.isFloat() || b.isDouble())) {
            throw new IllegalArgumentException(String.format("Invalid data type for type promotion: %s", b));
        }
        if (a.isDouble() || b.isDouble()) {
            return a.isNullable() || b.isNullable() ? DataTypes.NullableDoubleType : DataTypes.DoubleType;
        }
        if (a.isFloat() || b.isFloat()) {
            return a.isNullable() || b.isNullable() ? DataTypes.NullableFloatType : DataTypes.FloatType;
        }
        if (a.isLong() || b.isLong()) {
            return a.isNullable() || b.isNullable() ? DataTypes.NullableLongType : DataTypes.LongType;
        }
        return a.isNullable() || b.isNullable() ? DataTypes.NullableIntType : DataTypes.IntType;
    }

    public static DataType coerce(DataType a, DataType b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a.id() == b.id()) {
            return a;
        }
        if (a.id() == ID.Int && b.id() == ID.Double || b.id() == ID.Int && a.id() == ID.Double) {
            return a.isNullable() || b.isNullable() ? DataTypes.NullableDoubleType : DataTypes.DoubleType;
        }
        if (a.id() == ID.Date && b.id() == ID.DateTime || b.id() == ID.Date && a.id() == ID.DateTime) {
            return DataTypes.DateTimeType;
        }
        return DataTypes.StringType;
    }

    public static DataType infer(String s) {
        if (Strings.isNullOrEmpty(s)) {
            return null;
        }
        if (Regex.DATETIME.matcher(s).matches()) {
            return DataTypes.DateTimeType;
        }
        if (Regex.DATE.matcher(s).matches()) {
            return DataTypes.DateType;
        }
        if (Regex.TIME.matcher(s).matches()) {
            return DataTypes.TimeType;
        }
        if (Regex.INTEGER.matcher(s).matches()) {
            return DataTypes.IntType;
        }
        if (Regex.LONG.matcher(s).matches()) {
            return DataTypes.LongType;
        }
        if (Regex.DOUBLE.matcher(s).matches()) {
            return DataTypes.DoubleType;
        }
        if (Regex.BOOLEAN.matcher(s).matches()) {
            return DataTypes.BooleanType;
        }
        return DataTypes.StringType;
    }

    public static DataType of(String s) throws ClassNotFoundException {
        return switch (s) {
            case "boolean" -> DataTypes.BooleanType;
            case "char" -> DataTypes.CharType;
            case "byte" -> DataTypes.ByteType;
            case "short" -> DataTypes.ShortType;
            case "int" -> DataTypes.IntType;
            case "long" -> DataTypes.LongType;
            case "float" -> DataTypes.FloatType;
            case "double" -> DataTypes.DoubleType;
            case "Boolean" -> DataTypes.NullableBooleanType;
            case "Char" -> DataTypes.NullableCharType;
            case "Byte" -> DataTypes.NullableByteType;
            case "Short" -> DataTypes.NullableShortType;
            case "Int" -> DataTypes.NullableIntType;
            case "Long" -> DataTypes.NullableLongType;
            case "Float" -> DataTypes.NullableFloatType;
            case "Double" -> DataTypes.NullableDoubleType;
            case "Decimal" -> DataTypes.DecimalType;
            case "String" -> DataTypes.StringType;
            case "Date" -> DataTypes.DateType;
            case "DateTime" -> DataTypes.DateTimeType;
            case "Time" -> DataTypes.TimeType;
            default -> {
                if (s.startsWith("Class<") && s.endsWith(">")) {
                    yield DataTypes.object(Class.forName(s.substring(6, s.length() - 1)));
                }
                if (s.startsWith("Array[") && s.endsWith("]")) {
                    yield DataTypes.array(DataType.of(s.substring(6, s.length() - 1).trim()));
                }
                if (s.startsWith("Struct(") && s.endsWith(")")) {
                    String[] elements = s.substring(7, s.length() - 1).split(",");
                    StructField[] fields = new StructField[elements.length];
                    for (int i = 0; i < fields.length; ++i) {
                        String[] item = elements[i].split(":");
                        fields[i] = new StructField(item[0].trim(), DataType.of(item[1].trim()));
                    }
                    yield new StructType(fields);
                }
                throw new IllegalArgumentException(String.format("Unknown data type: %s", s));
            }
        };
    }

    public static DataType of(Class<?> clazz) {
        if (clazz == Integer.TYPE) {
            return DataTypes.IntType;
        }
        if (clazz == Double.TYPE) {
            return DataTypes.DoubleType;
        }
        if (clazz == Long.TYPE) {
            return DataTypes.LongType;
        }
        if (clazz == Float.TYPE) {
            return DataTypes.FloatType;
        }
        if (clazz == Boolean.TYPE) {
            return DataTypes.BooleanType;
        }
        if (clazz == Short.TYPE) {
            return DataTypes.ShortType;
        }
        if (clazz == Byte.TYPE) {
            return DataTypes.ByteType;
        }
        if (clazz == Character.TYPE) {
            return DataTypes.CharType;
        }
        if (clazz == Integer.class) {
            return DataTypes.NullableIntType;
        }
        if (clazz == Double.class) {
            return DataTypes.NullableDoubleType;
        }
        if (clazz == Long.class) {
            return DataTypes.NullableLongType;
        }
        if (clazz == Float.class) {
            return DataTypes.NullableFloatType;
        }
        if (clazz == Boolean.class) {
            return DataTypes.NullableBooleanType;
        }
        if (clazz == Short.class) {
            return DataTypes.NullableShortType;
        }
        if (clazz == Byte.class) {
            return DataTypes.NullableByteType;
        }
        if (clazz == Character.class) {
            return DataTypes.NullableCharType;
        }
        if (clazz.isArray()) {
            return DataTypes.array(DataType.of(clazz.getComponentType()));
        }
        if (clazz.isEnum()) {
            return DataTypes.category(clazz.getEnumConstants().length);
        }
        return DataTypes.object(clazz);
    }

    public static DataType of(JDBCType type, boolean nullable, String dbms) {
        return switch (type) {
            case JDBCType.BOOLEAN, JDBCType.BIT -> {
                if (nullable) {
                    yield DataTypes.NullableBooleanType;
                }
                yield DataTypes.BooleanType;
            }
            case JDBCType.TINYINT -> {
                if (nullable) {
                    yield DataTypes.NullableByteType;
                }
                yield DataTypes.ByteType;
            }
            case JDBCType.SMALLINT -> {
                if (nullable) {
                    yield DataTypes.NullableShortType;
                }
                yield DataTypes.ShortType;
            }
            case JDBCType.INTEGER -> {
                if (nullable) {
                    yield DataTypes.NullableIntType;
                }
                yield DataTypes.IntType;
            }
            case JDBCType.BIGINT -> {
                if (nullable) {
                    yield DataTypes.NullableLongType;
                }
                yield DataTypes.LongType;
            }
            case JDBCType.NUMERIC -> {
                if ("SQLite".equals(dbms)) {
                    if (nullable) {
                        yield DataTypes.NullableDoubleType;
                    }
                    yield DataTypes.DoubleType;
                }
                yield DataTypes.DecimalType;
            }
            case JDBCType.DECIMAL -> DataTypes.DecimalType;
            case JDBCType.REAL, JDBCType.FLOAT -> {
                if (nullable) {
                    yield DataTypes.NullableFloatType;
                }
                yield DataTypes.FloatType;
            }
            case JDBCType.DOUBLE -> {
                if (nullable) {
                    yield DataTypes.NullableDoubleType;
                }
                yield DataTypes.DoubleType;
            }
            case JDBCType.CHAR, JDBCType.NCHAR, JDBCType.VARCHAR, JDBCType.NVARCHAR, JDBCType.LONGVARCHAR, JDBCType.LONGNVARCHAR, JDBCType.CLOB -> DataTypes.StringType;
            case JDBCType.DATE -> DataTypes.DateType;
            case JDBCType.TIME -> DataTypes.TimeType;
            case JDBCType.TIMESTAMP -> DataTypes.DateTimeType;
            case JDBCType.BINARY, JDBCType.VARBINARY, JDBCType.LONGVARBINARY, JDBCType.BLOB -> DataTypes.ByteArrayType;
            default -> throw new UnsupportedOperationException(String.format("Unsupported JDBCType: %s", type));
        };
    }

    public static enum ID {
        Boolean,
        Byte,
        Char,
        Short,
        Int,
        Long,
        Float,
        Double,
        Decimal,
        String,
        Date,
        Time,
        DateTime,
        Object,
        Array,
        Struct;

    }
}

