/*
 * Decompiled with CFR 0.152.
 */
package smile.data.type;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import smile.data.type.ArrayType;
import smile.data.type.BooleanType;
import smile.data.type.ByteType;
import smile.data.type.CharType;
import smile.data.type.DataType;
import smile.data.type.DateTimeType;
import smile.data.type.DateType;
import smile.data.type.DecimalType;
import smile.data.type.DoubleType;
import smile.data.type.FloatType;
import smile.data.type.IntType;
import smile.data.type.LongType;
import smile.data.type.ObjectType;
import smile.data.type.ShortType;
import smile.data.type.StringType;
import smile.data.type.TimeType;

public class DataTypes {
    public static final BooleanType BooleanType = new BooleanType(false);
    public static final CharType CharType = new CharType(false);
    public static final ByteType ByteType = new ByteType(false);
    public static final ShortType ShortType = new ShortType(false);
    public static final IntType IntType = new IntType(false);
    public static final LongType LongType = new LongType(false);
    public static final FloatType FloatType = new FloatType(false);
    public static final DoubleType DoubleType = new DoubleType(false);
    public static final BooleanType NullableBooleanType = new BooleanType(true);
    public static final CharType NullableCharType = new CharType(true);
    public static final ByteType NullableByteType = new ByteType(true);
    public static final ShortType NullableShortType = new ShortType(true);
    public static final IntType NullableIntType = new IntType(true);
    public static final LongType NullableLongType = new LongType(true);
    public static final FloatType NullableFloatType = new FloatType(true);
    public static final DoubleType NullableDoubleType = new DoubleType(true);
    public static final DecimalType DecimalType = smile.data.type.DecimalType.instance;
    public static final StringType StringType = smile.data.type.StringType.instance;
    public static final DateType DateType = smile.data.type.DateType.instance;
    public static final DateTimeType DateTimeType = smile.data.type.DateTimeType.instance;
    public static final TimeType TimeType = smile.data.type.TimeType.instance;
    public static final ObjectType ObjectType = smile.data.type.ObjectType.instance;
    public static final ArrayType BooleanArrayType = ArrayType.BooleanArrayType;
    public static final ArrayType CharArrayType = ArrayType.CharArrayType;
    public static final ArrayType ByteArrayType = ArrayType.ByteArrayType;
    public static final ArrayType ShortArrayType = ArrayType.ShortArrayType;
    public static final ArrayType IntArrayType = ArrayType.IntArrayType;
    public static final ArrayType LongArrayType = ArrayType.LongArrayType;
    public static final ArrayType FloatArrayType = ArrayType.FloatArrayType;
    public static final ArrayType DoubleArrayType = ArrayType.DoubleArrayType;

    public static DataType object(Class<?> clazz) {
        if (clazz == BigDecimal.class) {
            return DecimalType;
        }
        if (clazz == String.class) {
            return StringType;
        }
        if (clazz == LocalDate.class) {
            return DateType;
        }
        if (clazz == LocalTime.class || clazz == OffsetTime.class) {
            return TimeType;
        }
        if (clazz == Timestamp.class || clazz == Instant.class || clazz == LocalDateTime.class || clazz == ZonedDateTime.class) {
            return DateTimeType;
        }
        return new ObjectType(clazz);
    }

    public static DataType category(int levels) {
        if (levels <= 128) {
            return ByteType;
        }
        if (levels <= 32768) {
            return ShortType;
        }
        return IntType;
    }

    public static ArrayType array(DataType type) {
        if (type == IntType) {
            return IntArrayType;
        }
        if (type == LongType) {
            return LongArrayType;
        }
        if (type == FloatType) {
            return FloatArrayType;
        }
        if (type == DoubleType) {
            return DoubleArrayType;
        }
        if (type == BooleanType) {
            return BooleanArrayType;
        }
        if (type == CharType) {
            return CharArrayType;
        }
        if (type == ByteType) {
            return ByteArrayType;
        }
        if (type == ShortType) {
            return ShortArrayType;
        }
        return new ArrayType(type);
    }
}

