/*
 * Decompiled with CFR 0.152.
 */
package smile.data.type;

import java.lang.runtime.SwitchBootstraps;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import smile.data.type.DataType;

public class DateTimeType
implements DataType {
    static final DateTimeType instance = new DateTimeType();

    DateTimeType() {
    }

    @Override
    public String name() {
        return "DateTime";
    }

    @Override
    public DataType.ID id() {
        return DataType.ID.DateTime;
    }

    public String toString() {
        return "DateTime";
    }

    @Override
    public String toString(Object o) {
        Object object = o;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Instant.class, LocalDateTime.class, ZonedDateTime.class, OffsetDateTime.class, Timestamp.class}, (Object)object2, n)) {
            case 0 -> {
                Instant d = (Instant)object2;
                yield DateTimeFormatter.ISO_INSTANT.format(d);
            }
            case 1 -> {
                LocalDateTime d = (LocalDateTime)object2;
                yield DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(d);
            }
            case 2 -> {
                ZonedDateTime d = (ZonedDateTime)object2;
                yield DateTimeFormatter.ISO_ZONED_DATE_TIME.format(d);
            }
            case 3 -> {
                OffsetDateTime d = (OffsetDateTime)object2;
                yield DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(d);
            }
            case 4 -> {
                Timestamp d = (Timestamp)object2;
                yield DateTimeFormatter.ISO_INSTANT.format(d.toInstant());
            }
            default -> o.toString();
        };
    }

    @Override
    public LocalDateTime valueOf(String s) {
        return LocalDateTime.parse(s, DateTimeFormatter.ISO_INSTANT);
    }

    public boolean equals(Object o) {
        return o instanceof DateTimeType;
    }
}

