/*
 * Decompiled with CFR 0.152.
 */
package smile.data.type;

import java.util.function.Function;
import smile.data.type.DataType;
import smile.data.type.DataTypes;

public class ObjectType
implements DataType {
    static final ObjectType instance = new ObjectType(Object.class);
    static final ObjectType BooleanObjectType = new ObjectType(Boolean.class);
    static final ObjectType CharObjectType = new ObjectType(Character.class);
    static final ObjectType ByteObjectType = new ObjectType(Byte.class);
    static final ObjectType ShortObjectType = new ObjectType(Short.class);
    static final ObjectType IntegerObjectType = new ObjectType(Integer.class);
    static final ObjectType LongObjectType = new ObjectType(Long.class);
    static final ObjectType FloatObjectType = new ObjectType(Float.class);
    static final ObjectType DoubleObjectType = new ObjectType(Double.class);
    private final Class<?> clazz;
    private final transient Function<Object, String> format;

    ObjectType(Class<?> clazz) {
        this.clazz = clazz;
        this.format = clazz == Float.class ? DataTypes.FloatType::toString : (clazz == Double.class ? DataTypes.DoubleType::toString : (clazz == Integer.class ? DataTypes.IntType::toString : (clazz == Long.class ? DataTypes.IntType::toString : Object::toString)));
    }

    public Class<?> getObjectClass() {
        return this.clazz;
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public boolean isBoolean() {
        return this.clazz == Boolean.class;
    }

    @Override
    public boolean isChar() {
        return this.clazz == Character.class;
    }

    @Override
    public boolean isByte() {
        return this.clazz == Byte.class;
    }

    @Override
    public boolean isShort() {
        return this.clazz == Short.class;
    }

    @Override
    public boolean isInt() {
        return this.clazz == Integer.class;
    }

    @Override
    public boolean isLong() {
        return this.clazz == Long.class;
    }

    @Override
    public boolean isFloat() {
        return this.clazz == Float.class;
    }

    @Override
    public boolean isDouble() {
        return this.clazz == Double.class;
    }

    @Override
    public String name() {
        return String.format("Class<%s>", this.clazz.getName());
    }

    @Override
    public DataType.ID id() {
        return DataType.ID.Object;
    }

    public String toString() {
        return this.clazz.getSimpleName();
    }

    @Override
    public String toString(Object o) {
        return this.format.apply(o);
    }

    @Override
    public Object valueOf(String s) {
        return s;
    }

    public boolean equals(Object o) {
        if (o instanceof ObjectType) {
            ObjectType t2 = (ObjectType)o;
            return this.clazz == t2.getObjectClass();
        }
        return false;
    }
}

