/*
 * Decompiled with CFR 0.152.
 */
package smile.datasets;

import java.io.IOException;
import java.nio.file.Path;
import org.apache.commons.csv.CSVFormat;
import smile.data.CategoricalEncoder;
import smile.data.DataFrame;
import smile.data.formula.Formula;
import smile.data.measure.NominalScale;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.type.StructType;
import smile.io.Read;
import smile.util.Paths;

public record Abalone(DataFrame train, DataFrame test, Formula formula) {
    private static final StructType schema = new StructType(new StructField("sex", DataTypes.ByteType, new NominalScale("F", "M", "I")), new StructField("length", DataTypes.DoubleType), new StructField("diameter", DataTypes.DoubleType), new StructField("height", DataTypes.DoubleType), new StructField("whole weight", DataTypes.DoubleType), new StructField("shucked weight", DataTypes.DoubleType), new StructField("viscera weight", DataTypes.DoubleType), new StructField("shell weight", DataTypes.DoubleType), new StructField("rings", DataTypes.DoubleType));

    public Abalone() throws IOException {
        this(Paths.getTestData("regression/abalone-train.data"), Paths.getTestData("regression/abalone-test.data"));
    }

    public Abalone(Path trainDataPath, Path testDataPath) throws IOException {
        this(Abalone.load(trainDataPath), Abalone.load(testDataPath), Formula.lhs("rings"));
    }

    private static DataFrame load(Path path) throws IOException {
        return Read.csv(path, CSVFormat.DEFAULT, schema);
    }

    public double[][] x() {
        return this.formula.x(this.train).toArray(false, CategoricalEncoder.DUMMY, new String[0]);
    }

    public double[] y() {
        return this.formula.y(this.train).toDoubleArray();
    }

    public double[][] testx() {
        return this.formula.x(this.test).toArray(false, CategoricalEncoder.DUMMY, new String[0]);
    }

    public double[] testy() {
        return this.formula.y(this.test).toDoubleArray();
    }
}

