/*
 * Decompiled with CFR 0.152.
 */
package smile.datasets;

import java.io.IOException;
import java.nio.file.Path;
import org.apache.commons.csv.CSVFormat;
import smile.data.CategoricalEncoder;
import smile.data.DataFrame;
import smile.data.formula.Formula;
import smile.io.Read;
import smile.util.Paths;

public record BreastCancer(DataFrame data, Formula formula) {
    public BreastCancer() throws IOException {
        this(Paths.getTestData("classification/breastcancer.csv"));
    }

    public BreastCancer(Path path) throws IOException {
        this(BreastCancer.load(path), Formula.lhs("diagnosis"));
    }

    private static DataFrame load(Path path) throws IOException {
        CSVFormat format = CSVFormat.Builder.create().setHeader(new String[0]).setSkipHeaderRecord(true).get();
        DataFrame data = Read.csv(path, format);
        data = data.drop("id").factorize("diagnosis");
        return data;
    }

    public double[][] x() {
        return this.formula.x(this.data).toArray(false, CategoricalEncoder.DUMMY, new String[0]);
    }

    public int[] y() {
        return this.formula.y(this.data).toIntArray();
    }
}

