/*
 * Decompiled with CFR 0.152.
 */
package smile.datasets;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import smile.util.Paths;

public record ColonCancer(double[][] x, int[] y) {
    public static ColonCancer load() throws IOException {
        return ColonCancer.load(Paths.getTestData("classification/colon.txt"));
    }

    public static ColonCancer load(Path path) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            int[] y = Arrays.stream(reader.readLine().split(" ")).mapToInt(s -> Integer.parseInt(s) > 0 ? 1 : 0).toArray();
            double[][] x = new double[62][2000];
            for (int i = 0; i < 2000; ++i) {
                String[] tokens = reader.readLine().split(" ");
                for (int j = 0; j < 62; ++j) {
                    x[j][i] = Double.parseDouble(tokens[j]);
                }
            }
            ColonCancer colonCancer = new ColonCancer(x, y);
            return colonCancer;
        }
    }
}

