/*
 * Decompiled with CFR 0.152.
 */
package smile.datasets;

import java.io.IOException;
import java.nio.file.Path;
import org.apache.commons.csv.CSVFormat;
import smile.data.DataFrame;
import smile.io.Read;
import smile.util.Paths;

public record Eurodist(DataFrame data) {
    public Eurodist() throws IOException {
        this(Paths.getTestData("mds/eurodist.txt"));
    }

    public Eurodist(Path path) throws IOException {
        this(Eurodist.load(path));
    }

    private static DataFrame load(Path path) throws IOException {
        CSVFormat format = CSVFormat.Builder.create().setDelimiter('\t').get();
        return Read.csv(path, format);
    }

    public double[][] x() {
        return this.data.drop(0).toArray(new String[0]);
    }
}

