/*
 * Decompiled with CFR 0.152.
 */
package smile.datasets;

import java.io.IOException;
import java.nio.file.Path;
import java.text.ParseException;
import smile.data.CategoricalEncoder;
import smile.data.DataFrame;
import smile.data.formula.Formula;
import smile.io.Read;
import smile.util.Paths;

public record ImageSegmentation(DataFrame train, DataFrame test, Formula formula) {
    public ImageSegmentation() throws IOException, ParseException {
        this(Paths.getTestData("weka/segment-challenge.arff"), Paths.getTestData("weka/segment-test.arff"));
    }

    public ImageSegmentation(Path trainDataPath, Path testDataPath) throws IOException, ParseException {
        this(Read.arff(trainDataPath), Read.arff(testDataPath), Formula.lhs("class"));
    }

    public double[][] x() {
        return this.formula.x(this.train).toArray(false, CategoricalEncoder.DUMMY, new String[0]);
    }

    public int[] y() {
        return this.formula.y(this.train).toIntArray();
    }

    public double[][] testx() {
        return this.formula.x(this.test).toArray(false, CategoricalEncoder.DUMMY, new String[0]);
    }

    public int[] testy() {
        return this.formula.y(this.test).toIntArray();
    }
}

