/*
 * Decompiled with CFR 0.152.
 */
package smile.datasets;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import org.apache.commons.csv.CSVFormat;
import smile.data.CategoricalEncoder;
import smile.data.DataFrame;
import smile.io.Read;
import smile.math.MathEx;
import smile.util.Paths;

public record SwissRoll(double[][] data) {
    public SwissRoll() throws IOException {
        this(Paths.getTestData("manifold/swissroll.txt"));
    }

    public SwissRoll(Path path) throws IOException {
        this(SwissRoll.load(path));
    }

    private static double[][] load(Path path) throws IOException {
        CSVFormat format = CSVFormat.Builder.create().setDelimiter('\t').get();
        DataFrame data = Read.csv(path, format);
        return data.toArray(false, CategoricalEncoder.DUMMY, new String[0]);
    }

    public double[][] distance(int size) {
        return MathEx.pdist((double[][])Arrays.copyOf(this.data, size)).toArray();
    }
}

