/*
 * Decompiled with CFR 0.152.
 */
package smile.datasets;

import java.io.IOException;
import java.nio.file.Path;
import org.apache.commons.csv.CSVFormat;
import smile.data.CategoricalEncoder;
import smile.data.DataFrame;
import smile.io.Read;
import smile.util.Paths;

public record SyntheticControl(DataFrame data) {
    public SyntheticControl() throws IOException {
        this(Paths.getTestData("clustering/synthetic_control.data"));
    }

    public SyntheticControl(Path path) throws IOException {
        this(SyntheticControl.load(path));
    }

    private static DataFrame load(Path path) throws IOException {
        CSVFormat format = CSVFormat.Builder.create().setDelimiter(' ').get();
        return Read.csv(path, format);
    }

    public double[][] x() {
        return this.data.toArray(false, CategoricalEncoder.DUMMY, new String[0]);
    }
}

