/*
 * Decompiled with CFR 0.152.
 */
package smile.datasets;

import java.io.IOException;
import java.nio.file.Path;
import java.text.ParseException;
import smile.data.CategoricalEncoder;
import smile.data.DataFrame;
import smile.data.formula.Formula;
import smile.io.Read;
import smile.util.Paths;

public record Weather(DataFrame data, Formula formula) {
    public Weather() throws IOException, ParseException {
        this(Paths.getTestData("weka/weather.arff"));
    }

    public Weather(Path path) throws IOException, ParseException {
        this(Read.arff(path), Formula.lhs("play"));
    }

    public double[][] level() {
        return this.formula.x(this.data).toArray(false, CategoricalEncoder.LEVEL, new String[0]);
    }

    public double[][] dummy() {
        return this.formula.x(this.data).toArray(false, CategoricalEncoder.DUMMY, new String[0]);
    }

    public double[][] onehot() {
        return this.formula.x(this.data).toArray(false, CategoricalEncoder.ONE_HOT, new String[0]);
    }

    public int[] y() {
        return this.formula.y(this.data).toIntArray();
    }
}

