/*
 * Decompiled with CFR 0.152.
 */
package smile.graph;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.DoubleStream;
import smile.graph.Graph;
import smile.math.matrix.SparseMatrix;
import smile.sort.QuickSort;
import smile.util.ArrayElementConsumer;
import smile.util.ArrayElementFunction;
import smile.util.SparseArray;

public class AdjacencyList
extends Graph
implements Serializable {
    private static final long serialVersionUID = 3L;
    private final SparseArray[] graph;

    public AdjacencyList(int n) {
        this(n, false);
    }

    public AdjacencyList(int n, boolean digraph) {
        super(digraph);
        this.graph = new SparseArray[n];
        for (int i = 0; i < n; ++i) {
            this.graph[i] = new SparseArray();
        }
    }

    public String toString() {
        return String.format("AdjacencyList(%d nodes, digraph=%b)", this.graph.length, this.isDigraph());
    }

    @Override
    public int getVertexCount() {
        return this.graph.length;
    }

    @Override
    public boolean hasEdge(int source, int target) {
        return this.graph[source].get(target) != 0.0;
    }

    @Override
    public double getWeight(int source, int target) {
        return this.graph[source].get(target);
    }

    @Override
    public AdjacencyList setWeight(int source, int target, double weight) {
        this.graph[source].set(target, weight);
        if (!this.isDigraph()) {
            this.graph[target].set(source, weight);
        }
        return this;
    }

    @Override
    public List<Graph.Edge> getEdges(int vertex) {
        return this.graph[vertex].stream().map(e -> new Graph.Edge(vertex, e.index(), e.value())).toList();
    }

    @Override
    public void forEachEdge(int vertex, ArrayElementConsumer action) {
        this.graph[vertex].forEach(action);
    }

    @Override
    public DoubleStream mapEdges(int vertex, ArrayElementFunction mapper) {
        return this.graph[vertex].map(mapper);
    }

    @Override
    public void updateEdges(int vertex, ArrayElementFunction mapper) {
        this.graph[vertex].update(mapper);
    }

    @Override
    public int getInDegree(int vertex) {
        int degree = 0;
        int n = this.graph.length;
        for (int i = 0; i < n; ++i) {
            if (!this.hasEdge(i, vertex)) continue;
            ++degree;
        }
        return degree;
    }

    @Override
    public int getOutDegree(int vertex) {
        return this.graph[vertex].size();
    }

    @Override
    public AdjacencyList subgraph(int[] vertices) {
        int[] v = (int[])vertices.clone();
        Arrays.sort(v);
        AdjacencyList g = new AdjacencyList(v.length, this.isDigraph());
        for (int i = 0; i < v.length; ++i) {
            List<Graph.Edge> edges = this.getEdges(v[i]);
            for (Graph.Edge edge : edges) {
                int j;
                int n = j = edge.u() == v[i] ? edge.v() : edge.u();
                if ((j = Arrays.binarySearch(v, j)) < 0) continue;
                g.addEdge(i, j, edge.weight());
            }
        }
        return g;
    }

    @Override
    public SparseMatrix toMatrix() {
        int i;
        int size = 0;
        int n = this.graph.length;
        int[] colSize = new int[n];
        int[] colIndex = new int[n + 1];
        for (i = 0; i < n; ++i) {
            SparseArray edges = this.graph[i];
            size += edges.size();
            colSize[i] = edges.size();
        }
        for (i = 0; i < n; ++i) {
            colIndex[i + 1] = colIndex[i] + colSize[i];
        }
        int[] rowIndex = new int[size];
        double[] x = new double[size];
        for (int i2 = 0; i2 < n; ++i2) {
            List<Graph.Edge> edges = this.getEdges(i2);
            int ni = edges.size();
            int[] index = new int[ni];
            double[] w = new double[ni];
            int j = 0;
            for (Graph.Edge edge : edges) {
                index[j] = edge.v();
                w[j++] = edge.weight();
            }
            QuickSort.sort(index, w);
            int k = colIndex[i2];
            j = 0;
            while (j < ni) {
                rowIndex[k] = index[j];
                x[k] = w[j];
                ++j;
                ++k;
            }
        }
        return new SparseMatrix(n, n, x, rowIndex, colIndex).transpose();
    }

    public static AdjacencyList of(SparseMatrix matrix) {
        boolean symmetric = false;
        if (matrix.nrow() == matrix.ncol()) {
            symmetric = true;
            block0: for (int i = 0; i < matrix.nrow(); ++i) {
                for (int j = 0; j < i; ++j) {
                    if (matrix.get(i, j) == matrix.get(j, i)) continue;
                    symmetric = false;
                    break block0;
                }
            }
        }
        AdjacencyList graph = new AdjacencyList(symmetric ? matrix.nrow() : matrix.nrow() + matrix.ncol());
        if (symmetric) {
            for (i = 0; i < matrix.nrow(); ++i) {
                for (int j = 0; j < i; ++j) {
                    double z = matrix.get(i, j);
                    if (z == 0.0) continue;
                    graph.addEdge(i, j, z);
                }
            }
        } else {
            for (i = 0; i < matrix.nrow(); ++i) {
                for (int j = 0; j < matrix.ncol(); ++j) {
                    double z = matrix.get(i, j);
                    if (z == 0.0) continue;
                    graph.addEdge(i, matrix.nrow() + j, z);
                }
            }
        }
        return graph;
    }
}

