/*
 * Decompiled with CFR 0.152.
 */
package smile.graph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import smile.graph.Graph;
import smile.math.MathEx;
import smile.math.matrix.Matrix;
import smile.util.ArrayElementConsumer;
import smile.util.ArrayElementFunction;

public class AdjacencyMatrix
extends Graph
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final double[][] graph;

    public AdjacencyMatrix(int n) {
        this(n, false);
    }

    public AdjacencyMatrix(int n, boolean digraph) {
        super(digraph);
        this.graph = new double[n][n];
    }

    public String toString() {
        return String.format("AdjacencyMatrix(%d nodes, digraph=%b)", this.graph.length, this.isDigraph());
    }

    @Override
    public int getVertexCount() {
        return this.graph.length;
    }

    @Override
    public boolean hasEdge(int source, int target) {
        return this.graph[source][target] != 0.0;
    }

    @Override
    public double getWeight(int source, int target) {
        return this.graph[source][target];
    }

    @Override
    public AdjacencyMatrix setWeight(int source, int target, double weight) {
        this.graph[source][target] = weight;
        if (!this.isDigraph()) {
            this.graph[target][source] = weight;
        }
        return this;
    }

    @Override
    public List<Graph.Edge> getEdges(int vertex) {
        ArrayList<Graph.Edge> set = new ArrayList<Graph.Edge>();
        int n = this.graph.length;
        double[] row = this.graph[vertex];
        for (int j = 0; j < n; ++j) {
            if (row[j] == 0.0) continue;
            Graph.Edge edge = new Graph.Edge(vertex, j, row[j]);
            set.add(edge);
        }
        return set;
    }

    private IntStream edges(double[] weights) {
        return IntStream.range(0, weights.length).filter(i -> weights[i] != 0.0);
    }

    @Override
    public void forEachEdge(int vertex, ArrayElementConsumer action) {
        double[] weights = this.graph[vertex];
        this.edges(weights).forEach(i -> action.apply(i, weights[i]));
    }

    @Override
    public DoubleStream mapEdges(int vertex, ArrayElementFunction mapper) {
        double[] weights = this.graph[vertex];
        return this.edges(weights).mapToDouble(i -> mapper.apply(i, weights[i]));
    }

    @Override
    public void updateEdges(int vertex, ArrayElementFunction mapper) {
        double[] weights = this.graph[vertex];
        this.edges(weights).forEach(i -> {
            weights[i] = mapper.apply(i, weights[i]);
        });
    }

    @Override
    public int getInDegree(int vertex) {
        int degree = 0;
        for (double[] edges : this.graph) {
            if (edges[vertex] == 0.0) continue;
            ++degree;
        }
        return degree;
    }

    @Override
    public int getOutDegree(int vertex) {
        int degree = 0;
        int n = this.graph.length;
        for (int j = 0; j < n; ++j) {
            if (this.graph[vertex][j] == 0.0) continue;
            ++degree;
        }
        return degree;
    }

    @Override
    public AdjacencyMatrix subgraph(int[] vertices) {
        int[] v = (int[])vertices.clone();
        Arrays.sort(v);
        AdjacencyMatrix g = new AdjacencyMatrix(v.length, this.isDigraph());
        for (int i = 0; i < v.length; ++i) {
            for (int j = 0; j < v.length; ++j) {
                g.graph[i][j] = this.graph[v[i]][v[j]];
            }
        }
        return g;
    }

    @Override
    public Matrix toMatrix() {
        return Matrix.of(this.graph);
    }

    public double[][] toArray() {
        return MathEx.clone(this.graph);
    }

    private void push(double[][] flow, double[] excess, int u, int v) {
        double send = Math.min(excess[u], this.graph[u][v] - flow[u][v]);
        double[] dArray = flow[u];
        int n = v;
        dArray[n] = dArray[n] + send;
        double[] dArray2 = flow[v];
        int n2 = u;
        dArray2[n2] = dArray2[n2] - send;
        int n3 = u;
        excess[n3] = excess[n3] - send;
        int n4 = v;
        excess[n4] = excess[n4] + send;
    }

    private void relabel(double[][] flow, int[] height, int u) {
        int n = this.graph.length;
        int minHeight = 2 * n;
        for (int v = 0; v < n; ++v) {
            if (!(this.graph[u][v] - flow[u][v] > 0.0)) continue;
            minHeight = Math.min(minHeight, height[v]);
            height[u] = minHeight + 1;
        }
    }

    private void discharge(double[][] flow, double[] excess, int[] height, int[] seen, int u) {
        int n = this.graph.length;
        while (excess[u] > 0.0) {
            if (seen[u] < n) {
                int v = seen[u];
                if (this.graph[u][v] - flow[u][v] > 0.0 && height[u] > height[v]) {
                    this.push(flow, excess, u, v);
                    continue;
                }
                int n2 = u;
                seen[n2] = seen[n2] + 1;
                continue;
            }
            this.relabel(flow, height, u);
            seen[u] = 0;
        }
    }

    private static void moveToFront(int i, int[] array) {
        int temp = array[i];
        for (int j = i; j > 0; --j) {
            array[j] = array[j - 1];
        }
        array[0] = temp;
    }

    public double pushRelabel(double[][] flow, int source, int sink) {
        int n = this.graph.length;
        int[] seen = new int[n];
        int[] queue = new int[n - 2];
        int p = 0;
        for (int i = 0; i < n; ++i) {
            if (i == source || i == sink) continue;
            queue[p++] = i;
        }
        int[] height = new int[n];
        height[source] = n;
        double[] excess = new double[n];
        excess[source] = Double.MAX_VALUE;
        for (int i = 0; i < n; ++i) {
            this.push(flow, excess, source, i);
        }
        int p2 = 0;
        while (p2 < n - 2) {
            int u = queue[p2];
            double oldHeight = height[u];
            this.discharge(flow, excess, height, seen, u);
            if ((double)height[u] > oldHeight) {
                AdjacencyMatrix.moveToFront(p2, queue);
                p2 = 0;
                continue;
            }
            ++p2;
        }
        double maxflow = 0.0;
        for (int i = 0; i < n; ++i) {
            maxflow += flow[source][i];
        }
        return maxflow;
    }
}

