/*
 * Decompiled with CFR 0.152.
 */
package smile.math.matrix;

import java.util.Arrays;
import org.bytedeco.arpackng.global.arpack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.math.matrix.IMatrix;
import smile.math.matrix.Matrix;

public class ARPACK {
    private static final Logger logger = LoggerFactory.getLogger(ARPACK.class);

    private ARPACK() {
    }

    public static Matrix.EVD syev(IMatrix A, SymmOption which, int nev) {
        return ARPACK.syev(A, which, nev, Math.min(3 * nev, A.nrow()), 1.0E-6);
    }

    public static Matrix.EVD syev(IMatrix A, SymmOption which, int nev, int ncv, double tol) {
        if (A.nrow() != A.ncol()) {
            throw new IllegalArgumentException(String.format("Matrix is not square: %d x %d", A.nrow(), A.ncol()));
        }
        int n = A.nrow();
        if (nev <= 0 || nev >= n) {
            throw new IllegalArgumentException("Invalid NEV parameter k: " + nev);
        }
        int[] ido = new int[]{0};
        int[] info = new int[]{0};
        byte[] bmat = new byte[]{73};
        String swhich = which.name();
        byte[] bwhich = new byte[]{(byte)swhich.charAt(0), (byte)swhich.charAt(1)};
        int[] iparam = new int[11];
        iparam[0] = 1;
        iparam[2] = 10 * n;
        iparam[6] = 1;
        int[] ipntr = new int[11];
        double[] workd = new double[3 * n];
        double[] workl = new double[ncv * (ncv + 8)];
        double[] resid = new double[n];
        double[] V = new double[n * ncv];
        int ldv = n;
        do {
            arpack.dsaupd_c((int[])ido, (byte[])bmat, (int)n, (byte[])bwhich, (int)nev, (double)tol, (double[])resid, (int)ncv, (double[])V, (int)ldv, (int[])iparam, (int[])ipntr, (double[])workd, (double[])workl, (int)workl.length, (int[])info);
            if (ido[0] != -1 && ido[0] != 1) continue;
            A.mv(workd, ipntr[0] - 1, ipntr[1] - 1);
        } while (ido[0] == -1 || ido[0] == 1);
        if (info[0] < 0) {
            throw new IllegalStateException("ARPACK DSAUPD error code: " + info[0]);
        }
        info[0] = 0;
        byte[] howmny = new byte[]{65};
        double[] d = new double[ncv * 2];
        int[] select = new int[ncv];
        double sigma = 0.0;
        int rvec = 1;
        arpack.dseupd_c((int)rvec, (byte[])howmny, (int[])select, (double[])d, (double[])V, (int)ldv, (double)sigma, (byte[])bmat, (int)n, (byte[])bwhich, (int)nev, (double)tol, (double[])resid, (int)ncv, (double[])V, (int)ldv, (int[])iparam, (int[])ipntr, (double[])workd, (double[])workl, (int)workl.length, (int[])info);
        if (info[0] != 0) {
            Object error = "ARPACK DSEUPD error code: " + info[0];
            if (info[0] == 1) {
                error = "ARPACK DSEUPD error: Maximum number of iterations reached.";
            } else if (info[0] == 3) {
                error = "ARPACK DSEUPD error: No shifts could be applied during implicit Arnoldi update, try increasing NCV.";
            }
            throw new IllegalStateException((String)error);
        }
        nev = iparam[4];
        logger.info("ARPACK dseupd computed {} eigenvalues", (Object)nev);
        d = Arrays.copyOfRange(d, 0, nev);
        V = Arrays.copyOfRange(V, 0, n * nev);
        Matrix.EVD eig = new Matrix.EVD(d, new Matrix(n, nev, ldv, V));
        return eig.sort();
    }

    public static Matrix.EVD eigen(IMatrix A, AsymmOption which, int nev) {
        return ARPACK.eigen(A, which, nev, Math.min(3 * nev, A.nrow()), 1.0E-6);
    }

    public static Matrix.EVD eigen(IMatrix A, AsymmOption which, int nev, int ncv, double tol) {
        if (A.nrow() != A.ncol()) {
            throw new IllegalArgumentException(String.format("Matrix is not square: %d x %d", A.nrow(), A.ncol()));
        }
        int n = A.nrow();
        if (nev <= 0 || nev >= n) {
            throw new IllegalArgumentException("Invalid NEV: " + nev);
        }
        int[] ido = new int[]{0};
        int[] info = new int[]{0};
        byte[] bmat = new byte[]{73};
        String swhich = which.name();
        byte[] bwhich = new byte[]{(byte)swhich.charAt(0), (byte)swhich.charAt(1)};
        int[] iparam = new int[11];
        iparam[0] = 1;
        iparam[2] = 10 * n;
        iparam[6] = 1;
        int[] ipntr = new int[14];
        double[] workd = new double[3 * n];
        double[] workev = new double[3 * ncv];
        double[] workl = new double[3 * ncv * ncv + 6 * ncv];
        double[] resid = new double[n];
        double[] V = new double[n * ncv];
        int ldv = n;
        do {
            arpack.dnaupd_c((int[])ido, (byte[])bmat, (int)n, (byte[])bwhich, (int)nev, (double)tol, (double[])resid, (int)ncv, (double[])V, (int)ldv, (int[])iparam, (int[])ipntr, (double[])workd, (double[])workl, (int)workl.length, (int[])info);
            if (ido[0] != -1 && ido[0] != 1) continue;
            A.mv(workd, ipntr[0] - 1, ipntr[1] - 1);
        } while (ido[0] == -1 || ido[0] == 1);
        if (info[0] < 0) {
            throw new IllegalStateException("ARPACK DNAUPD error code: " + info[0]);
        }
        info[0] = 0;
        byte[] howmny = new byte[]{65};
        double[] wr = new double[ncv * 2];
        double[] wi = new double[ncv * 2];
        int[] select = new int[ncv];
        double sigmar = 0.0;
        double sigmai = 0.0;
        int rvec = 1;
        arpack.dneupd_c((int)rvec, (byte[])howmny, (int[])select, (double[])wr, (double[])wi, (double[])V, (int)ldv, (double)sigmar, (double)sigmai, (double[])workev, (byte[])bmat, (int)n, (byte[])bwhich, (int)nev, (double)tol, (double[])resid, (int)ncv, (double[])V, (int)ldv, (int[])iparam, (int[])ipntr, (double[])workd, (double[])workl, (int)workl.length, (int[])info);
        if (info[0] != 0) {
            Object error = "ARPACK DNEUPD error code: " + info[0];
            if (info[0] == 1) {
                error = "ARPACK DNEUPD error: Maximum number of iterations reached.";
            } else if (info[0] == 3) {
                error = "ARPACK DNEUPD error: No shifts could be applied during implicit Arnoldi update, try increasing NCV.";
            }
            throw new IllegalStateException((String)error);
        }
        nev = iparam[4];
        logger.info("ARPACK dnaupd computed {} eigenvalues", (Object)nev);
        wr = Arrays.copyOfRange(wr, 0, nev);
        wi = Arrays.copyOfRange(wi, 0, nev);
        V = Arrays.copyOfRange(V, 0, n * nev);
        Matrix.EVD eig = new Matrix.EVD(wr, wi, null, new Matrix(n, nev, ldv, V));
        return eig.sort();
    }

    public static Matrix.SVD svd(IMatrix A, int k) {
        return ARPACK.svd(A, k, Math.min(3 * k, Math.min(A.nrow(), A.ncol())), 1.0E-6);
    }

    public static Matrix.SVD svd(IMatrix A, int k, int ncv, double tol) {
        int m = A.nrow();
        int n = A.ncol();
        IMatrix ata = A.square();
        Matrix.EVD eigen = ARPACK.syev(ata, SymmOption.LM, k, ncv, tol);
        double[] s = eigen.wr;
        for (int i = 0; i < s.length; ++i) {
            s[i] = Math.sqrt(s[i]);
        }
        if (m >= n) {
            Matrix V = eigen.Vr;
            double[] Av = new double[m];
            double[] v = new double[n];
            Matrix U = new Matrix(m, s.length);
            for (int j = 0; j < s.length; ++j) {
                int i;
                for (i = 0; i < n; ++i) {
                    v[i] = V.get(i, j);
                }
                A.mv(v, Av);
                for (i = 0; i < m; ++i) {
                    U.set(i, j, Av[i] / s[j]);
                }
            }
            return new Matrix.SVD(s, U, V);
        }
        Matrix U = eigen.Vr;
        double[] Atu = new double[n];
        double[] u = new double[m];
        Matrix V = new Matrix(n, s.length);
        for (int j = 0; j < s.length; ++j) {
            int i;
            for (i = 0; i < m; ++i) {
                u[i] = U.get(i, j);
            }
            A.tv(u, Atu);
            for (i = 0; i < n; ++i) {
                V.set(i, j, Atu[i] / s[j]);
            }
        }
        return new Matrix.SVD(s, U, V);
    }

    public static enum SymmOption {
        LA,
        SA,
        LM,
        SM,
        BE;

    }

    public static enum AsymmOption {
        LM,
        SM,
        LR,
        SR,
        LI,
        SI;

    }
}

