/*
 * Decompiled with CFR 0.152.
 */
package smile.neighbor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import smile.math.MathEx;
import smile.neighbor.KNNSearch;
import smile.neighbor.Neighbor;
import smile.neighbor.RNNSearch;
import smile.neighbor.lsh.Bucket;
import smile.neighbor.lsh.Hash;
import smile.sort.HeapSelect;
import smile.util.IntArrayList;

public class LSH<E>
implements KNNSearch<double[], E>,
RNNSearch<double[], E>,
Serializable {
    private static final long serialVersionUID = 2L;
    protected ArrayList<double[]> keys;
    protected ArrayList<E> data;
    protected List<Hash> hash;
    protected int H;
    protected int k;
    protected double w;

    public LSH(double[][] keys, E[] data, double w) {
        this(keys, data, w, 1017881);
    }

    public LSH(double[][] keys, E[] data, double w, int H) {
        this(keys[0].length, Math.max(50, (int)Math.pow(keys.length, 0.25)), Math.max(3, (int)Math.log10(keys.length)), w, H);
        if (keys.length != data.length) {
            throw new IllegalArgumentException("The array size of keys and data are different.");
        }
        if (H < keys.length) {
            throw new IllegalArgumentException("Hash table size is too small: " + H);
        }
        int n = keys.length;
        for (int i = 0; i < n; ++i) {
            this.put(keys[i], data[i]);
        }
    }

    public LSH(int d, int L, int k, double w) {
        this(d, L, k, w, 1017881);
    }

    public LSH(int d, int L, int k, double w, int H) {
        if (d < 2) {
            throw new IllegalArgumentException("Invalid input space dimension: " + d);
        }
        if (L < 1) {
            throw new IllegalArgumentException("Invalid number of hash tables: " + L);
        }
        if (k < 1) {
            throw new IllegalArgumentException("Invalid number of random projections per hash value: " + k);
        }
        if (w <= 0.0) {
            throw new IllegalArgumentException("Invalid width of random projections: " + w);
        }
        if (H < 1) {
            throw new IllegalArgumentException("Invalid size of hash tables: " + H);
        }
        this.k = k;
        this.w = w;
        this.H = H;
        this.keys = new ArrayList();
        this.data = new ArrayList();
        this.initHashTable(d, L, k, w, H);
    }

    protected void initHashTable(int d, int L, int k, double w, int H) {
        this.hash = new ArrayList<Hash>(L);
        for (int i = 0; i < L; ++i) {
            this.hash.add(new Hash(d, k, w, H));
        }
    }

    public String toString() {
        return String.format("LSH(L=%d, k=%d, H=%d, w=%.4f)", this.hash.size(), this.k, this.H, this.w);
    }

    public void put(double[] key, E value) {
        int index = this.keys.size();
        this.keys.add(key);
        this.data.add(value);
        for (Hash h : this.hash) {
            h.add(index, key);
        }
    }

    @Override
    public Neighbor<double[], E> nearest(double[] q) {
        int index = -1;
        double nearest = Double.MAX_VALUE;
        for (int i : this.getCandidates(q)) {
            double distance;
            double[] x = this.keys.get(i);
            if (q == x || !((distance = MathEx.distance(q, x)) < nearest)) continue;
            index = i;
            nearest = distance;
        }
        return index == -1 ? null : new Neighbor<double[], E>(this.keys.get(index), this.data.get(index), index, nearest);
    }

    @Override
    public Neighbor<double[], E>[] search(double[] q, int k) {
        if (k < 1) {
            throw new IllegalArgumentException("Invalid k: " + k);
        }
        Set<Integer> candidates = this.getCandidates(q);
        k = Math.min(k, candidates.size());
        HeapSelect heap = new HeapSelect((Comparable[])new Neighbor[k]);
        for (int index : candidates) {
            double[] key = this.keys.get(index);
            if (q == key) continue;
            double distance = MathEx.distance(q, key);
            heap.add(new Neighbor<double[], E>(key, this.data.get(index), index, distance));
        }
        heap.sort();
        return (Neighbor[])heap.toArray();
    }

    @Override
    public void search(double[] q, double radius, List<Neighbor<double[], E>> neighbors) {
        if (radius <= 0.0) {
            throw new IllegalArgumentException("Invalid radius: " + radius);
        }
        for (int index : this.getCandidates(q)) {
            double distance;
            double[] key = this.keys.get(index);
            if (q == key || !((distance = MathEx.distance(q, key)) <= radius)) continue;
            neighbors.add(new Neighbor<double[], E>(key, this.data.get(index), index, distance));
        }
    }

    private Set<Integer> getCandidates(double[] q) {
        LinkedHashSet<Integer> candidates = new LinkedHashSet<Integer>();
        for (Hash h : this.hash) {
            Bucket bucket = h.get(q);
            if (bucket == null) continue;
            IntArrayList points = bucket.points();
            int n = points.size();
            for (int i = 0; i < n; ++i) {
                candidates.add(points.get(i));
            }
        }
        return candidates;
    }
}

