/*
 * Decompiled with CFR 0.152.
 */
package smile.neighbor;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import smile.hash.SimHash;
import smile.math.distance.HammingDistance;
import smile.neighbor.Neighbor;
import smile.neighbor.RNNSearch;
import smile.util.IntArrayList;

public class SNLSH<K, V>
implements RNNSearch<K, V>,
Serializable {
    private static final long serialVersionUID = 2L;
    private final long mask;
    private static final int BITS = 64;
    private final LinkedHashMap<Long, IntArrayList>[] bands;
    private final List<V> data = new ArrayList<V>();
    private final List<K> keys = new ArrayList<K>();
    private final List<Long> signatures = new ArrayList<Long>();
    private final SimHash<K> simhash;

    public SNLSH(int L, SimHash<K> hash) {
        if (L < 2 || L > 32) {
            throw new IllegalArgumentException("Invalid band size!");
        }
        this.simhash = hash;
        this.bands = (LinkedHashMap[])Array.newInstance(LinkedHashMap.class, L);
        for (int i = 0; i < L; ++i) {
            this.bands[i] = new LinkedHashMap();
        }
        this.mask = -1 >>> 64 / L * (L - 1);
    }

    public void put(K key, V value) {
        int index = this.data.size();
        this.keys.add(key);
        this.data.add(value);
        long signature = this.simhash.hash(key);
        this.signatures.add(signature);
        for (int i = 0; i < this.bands.length; ++i) {
            long bandKey = this.bandHash(signature, i);
            IntArrayList bucket = this.bands[i].get(bandKey);
            if (bucket == null) {
                bucket = new IntArrayList();
            }
            bucket.add(index);
            this.bands[i].put(bandKey, bucket);
        }
    }

    @Override
    public void search(K q, double radius, List<Neighbor<K, V>> neighbors) {
        if (radius <= 0.0 || radius != (double)((int)radius)) {
            throw new IllegalArgumentException("The parameter radius has to be an integer: " + radius);
        }
        long fpq = this.simhash.hash(q);
        Set<Integer> candidates = this.getCandidates(q);
        for (int index : candidates) {
            int distance = HammingDistance.d(fpq, this.signatures.get(index));
            if (!((double)distance <= radius)) continue;
            neighbors.add(new Neighbor<K, V>(this.keys.get(index), this.data.get(index), index, distance));
        }
    }

    private long bandHash(long hash, int band) {
        return hash >>> band * (64 / this.bands.length) & this.mask;
    }

    private Set<Integer> getCandidates(K q) {
        LinkedHashSet<Integer> candidates = new LinkedHashSet<Integer>();
        long sign = this.simhash.hash(q);
        for (int i = 0; i < this.bands.length; ++i) {
            long bandKey = this.bandHash(sign, i);
            IntArrayList bucket = this.bands[i].get(bandKey);
            if (bucket == null) continue;
            for (int j = 0; j < bucket.size(); ++j) {
                candidates.add(bucket.get(j));
            }
        }
        return candidates;
    }
}

