/*
 * Decompiled with CFR 0.152.
 */
package smile.taxonomy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import smile.taxonomy.Concept;

public class Taxonomy {
    final HashMap<String, Concept> concepts = new HashMap();
    final Concept root = new Concept();

    public Taxonomy(String ... rootConcept) {
        this.root.taxonomy = this;
        this.root.addKeywords(rootConcept);
    }

    public Concept getRoot() {
        return this.root;
    }

    public Concept getConcept(String keyword) {
        return this.concepts.get(keyword);
    }

    public List<String> getConcepts() {
        return this.getConcepts(this.root);
    }

    private List<String> getConcepts(Concept c) {
        ArrayList<String> keywords = new ArrayList<String>();
        if (c.synset != null) {
            keywords.addAll(c.synset);
        }
        if (c.children != null) {
            for (Concept child : c.children) {
                keywords.addAll(this.getConcepts(child));
            }
        }
        return keywords;
    }

    public Concept lowestCommonAncestor(String v, String w) {
        Concept vnode = this.getConcept(v);
        Concept wnode = this.getConcept(w);
        return this.lowestCommonAncestor(vnode, wnode);
    }

    public Concept lowestCommonAncestor(Concept v, Concept w) {
        if (v.taxonomy != w.taxonomy) {
            throw new IllegalArgumentException("Concepts are not from the same taxonomy.");
        }
        List<Concept> vPath = v.getPathFromRoot();
        List<Concept> wPath = w.getPathFromRoot();
        Iterator<Concept> vIter = vPath.iterator();
        Iterator<Concept> wIter = wPath.iterator();
        Concept commonAncestor = null;
        while (vIter.hasNext() && wIter.hasNext()) {
            Concept wAncestor;
            Concept vAncestor = vIter.next();
            if (vAncestor != (wAncestor = wIter.next())) {
                return commonAncestor;
            }
            commonAncestor = vAncestor;
        }
        return commonAncestor;
    }
}

