/*
 * Copyright (c) 2010-2025 Haifeng Li. All rights reserved.
 *
 * Smile is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Smile is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Smile. If not, see <https://www.gnu.org/licenses/>.
 */

/**
 * Probability distributions. In probability theory, a probability mass,
 * probability density, or probability distribution is a function that
 * describes the probability of a random variable taking certain values.
 * <p>
 * In the discrete case, one can easily assign a probability to each possible
 * value. In contrast, when a random variable takes values from a continuum,
 * probabilities are nonzero only if they refer to finite intervals.
 * <p>
 * If total order is defined for the random variable, the cumulative
 * distribution function gives the probability that the random variable
 * is not larger than a given value; it is the integral of the non-cumulative
 * distribution.
 *
 * @author Haifeng Li
 */
package smile.stat.distribution;
