/*
 * Decompiled with CFR 0.152.
 */
package smile.data;

import java.beans.IntrospectionException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.data.CategoricalEncoder;
import smile.data.Row;
import smile.data.RowIndex;
import smile.data.Tuple;
import smile.data.measure.CategoricalMeasure;
import smile.data.measure.Measure;
import smile.data.measure.NominalScale;
import smile.data.type.DataType;
import smile.data.type.DataTypes;
import smile.data.type.Property;
import smile.data.type.StructField;
import smile.data.type.StructType;
import smile.data.vector.BooleanVector;
import smile.data.vector.ByteVector;
import smile.data.vector.CharVector;
import smile.data.vector.DoubleVector;
import smile.data.vector.FloatVector;
import smile.data.vector.IntVector;
import smile.data.vector.LongVector;
import smile.data.vector.NullableBooleanVector;
import smile.data.vector.NullableByteVector;
import smile.data.vector.NullableCharVector;
import smile.data.vector.NullableDoubleVector;
import smile.data.vector.NullableFloatVector;
import smile.data.vector.NullableIntVector;
import smile.data.vector.NullableLongVector;
import smile.data.vector.NullablePrimitiveVector;
import smile.data.vector.NullableShortVector;
import smile.data.vector.NumberVector;
import smile.data.vector.ObjectVector;
import smile.data.vector.ShortVector;
import smile.data.vector.StringVector;
import smile.data.vector.ValueVector;
import smile.math.MathEx;
import smile.math.matrix.Matrix;
import smile.util.Index;
import smile.util.Strings;

public record DataFrame(StructType schema, List<ValueVector> columns, RowIndex index) implements Iterable<Row>,
Serializable
{
    private static final Logger logger = LoggerFactory.getLogger(DataFrame.class);

    public DataFrame {
        if (columns.isEmpty()) {
            throw new IllegalArgumentException("Columns must not be empty");
        }
        int size = index != null ? index.size() : columns.getFirst().size();
        for (ValueVector column : columns) {
            if (column.size() == size) continue;
            throw new IllegalArgumentException("Columns must have the same size.");
        }
    }

    public DataFrame(ValueVector ... columns) {
        this((RowIndex)null, columns);
    }

    public DataFrame(RowIndex index, ValueVector ... columns) {
        this(StructType.of(columns), new ArrayList<ValueVector>(Arrays.asList(columns)), index);
    }

    @Override
    public String toString() {
        return this.head(10);
    }

    public String[] names() {
        return this.schema.names();
    }

    public DataType[] dtypes() {
        return this.schema.dtypes();
    }

    public Measure[] measures() {
        return this.schema.measures();
    }

    public int shape(int dim) {
        return switch (dim) {
            case 0 -> this.columns.getFirst().size();
            case 1 -> this.columns.size();
            default -> throw new IllegalArgumentException("Invalid dim: " + dim);
        };
    }

    public int size() {
        return this.columns.getFirst().size();
    }

    public int nrow() {
        return this.columns.getFirst().size();
    }

    public int ncol() {
        return this.columns.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public DataFrame setIndex(String column) {
        int n = this.size();
        ValueVector vector = this.apply(column);
        Object[] index = new Object[n];
        for (int i = 0; i < n; ++i) {
            index[i] = vector.get(i);
        }
        ValueVector[] data = (ValueVector[])this.columns.stream().filter(c -> !c.name().equals(column)).toArray(ValueVector[]::new);
        return new DataFrame(new RowIndex(index), data);
    }

    public DataFrame setIndex(Object[] index) {
        if (index.length != this.size()) {
            throw new IllegalArgumentException("Index array must have the same size as data frame.");
        }
        return new DataFrame(this.schema, this.columns, new RowIndex(index));
    }

    public ValueVector column(int j) {
        return this.columns.get(j);
    }

    public ValueVector column(String name) {
        return this.columns.get(this.schema.indexOf(name));
    }

    public ValueVector apply(String name) {
        return this.column(name);
    }

    public DataFrame apply(String ... names) {
        return this.select(names);
    }

    public Tuple get(int i) {
        return new Row(this, i);
    }

    public Tuple apply(int i) {
        return this.get(i);
    }

    public Tuple loc(Object row) {
        return new Row(this, this.index.apply(row));
    }

    public DataFrame loc(Object ... rows) {
        int n = rows.length;
        int[] index = new int[n];
        for (int i = 0; i < n; ++i) {
            index[i] = this.index.apply(rows[i]);
        }
        return this.get(Index.of(index));
    }

    public DataFrame get(Index index) {
        RowIndex rowIndex = this.index != null ? this.index.get(index) : null;
        return new DataFrame(this.schema, this.columns.stream().map(column -> column.get(index)).toList(), rowIndex);
    }

    public DataFrame apply(Index index) {
        return this.get(index);
    }

    public DataFrame get(boolean[] index) {
        Index idx = Index.of(index);
        RowIndex rowIndex = this.index != null ? this.index.get(idx) : null;
        return new DataFrame(this.schema, this.columns.stream().map(column -> column.get(idx)).toList(), rowIndex);
    }

    public DataFrame apply(boolean[] index) {
        return this.get(index);
    }

    public boolean isNullAt(int i, int j) {
        return this.columns.get(j).isNullAt(i);
    }

    public Object get(int i, int j) {
        return this.columns.get(j).get(i);
    }

    public Object apply(int i, int j) {
        return this.get(i, j);
    }

    public int getInt(int i, int j) {
        return this.columns.get(j).getInt(i);
    }

    public long getLong(int i, int j) {
        return this.columns.get(j).getLong(i);
    }

    public float getFloat(int i, int j) {
        return this.columns.get(j).getFloat(i);
    }

    public double getDouble(int i, int j) {
        return this.columns.get(j).getDouble(i);
    }

    public String getString(int i, int j) {
        return this.columns.get(j).getString(i);
    }

    public String getScale(int i, int j) {
        return this.columns.get(j).getScale(i);
    }

    public void set(int i, int j, Object value) {
        this.columns.get(j).set(i, value);
    }

    public void update(int i, int j, Object value) {
        this.set(i, j, value);
    }

    public Stream<Row> stream() {
        return IntStream.range(0, this.size()).mapToObj(i -> new Row(this, i));
    }

    @Override
    public Iterator<Row> iterator() {
        return this.stream().iterator();
    }

    public List<Row> toList() {
        return this.stream().toList();
    }

    public DataFrame dropna() {
        boolean[] nonNull = new boolean[this.size()];
        for (int i = 0; i < nonNull.length; ++i) {
            nonNull[i] = !this.get(i).anyNull();
        }
        return this.get(Index.of(nonNull));
    }

    public DataFrame fillna(double value) {
        for (ValueVector column : this.columns) {
            if (column instanceof FloatVector) {
                FloatVector vector = (FloatVector)column;
                vector.fillna((float)value);
                continue;
            }
            if (column instanceof DoubleVector) {
                DoubleVector vector = (DoubleVector)column;
                vector.fillna(value);
                continue;
            }
            if (column instanceof NullablePrimitiveVector) {
                NullablePrimitiveVector vector = (NullablePrimitiveVector)column;
                vector.fillna(value);
                continue;
            }
            if (!(column instanceof NumberVector)) continue;
            NumberVector vector = (NumberVector)column;
            vector.fillna(value);
        }
        return this;
    }

    public DataFrame select(int ... indices) {
        return new DataFrame(this.index, (ValueVector[])Arrays.stream(indices).mapToObj(j -> this.columns.get(j)).toArray(ValueVector[]::new));
    }

    public DataFrame select(String ... names) {
        return new DataFrame(this.index, (ValueVector[])Arrays.stream(names).map(this::column).toArray(ValueVector[]::new));
    }

    public DataFrame drop(int ... indices) {
        HashSet<Integer> set = new HashSet<Integer>();
        for (int index : indices) {
            set.add(index);
        }
        return new DataFrame(this.index, (ValueVector[])IntStream.range(0, this.columns.size()).filter(j -> !set.contains(j)).mapToObj(this.columns::get).toArray(ValueVector[]::new));
    }

    public DataFrame drop(String ... names) {
        HashSet set = new HashSet();
        Collections.addAll(set, names);
        return new DataFrame(this.index, (ValueVector[])this.columns.stream().filter(column -> !set.contains(column.name())).toArray(ValueVector[]::new));
    }

    public DataFrame add(ValueVector ... vectors) {
        for (ValueVector vector : vectors) {
            if (vector.size() != this.size()) {
                throw new IllegalArgumentException("Add a column with different size: " + this.size() + " vs " + vector.size());
            }
            if (!this.schema.index().containsKey(vector.name())) continue;
            throw new IllegalArgumentException("Add a column with clashing name: " + vector.name());
        }
        for (ValueVector vector : vectors) {
            this.schema.add(vector.field());
            this.columns.add(vector);
        }
        return this;
    }

    public DataFrame set(String name, ValueVector column) {
        int j;
        if (column.size() != this.size()) {
            throw new IllegalArgumentException("column size mismatch");
        }
        if (!name.equals(column.name())) {
            column = column.withName(name);
        }
        if ((j = this.schema.index().getOrDefault(name, this.ncol()).intValue()) < this.ncol()) {
            this.columns.set(j, column);
        } else {
            this.schema.add(column.field());
            this.columns.add(column);
        }
        return this;
    }

    public DataFrame update(String name, ValueVector column) {
        return this.set(name, column);
    }

    public DataFrame join(DataFrame other) {
        if (this.index == null || other.index == null) {
            return this.merge(other);
        }
        int k = 0;
        int n = this.size();
        boolean[] inner = new boolean[n];
        int[] right = new int[n];
        for (int i = 0; i < n; ++i) {
            Object id = this.index.values()[i];
            Integer j = other.index().loc().get(id);
            if (j == null) continue;
            inner[i] = true;
            right[k++] = j;
        }
        DataFrame left = this.get(Index.of(inner));
        other = other.get(Index.of(Arrays.copyOf(right, k)));
        return left.merge(other);
    }

    public DataFrame merge(DataFrame ... dataframes) {
        for (DataFrame df : dataframes) {
            if (df.size() == this.size()) continue;
            throw new IllegalArgumentException("Merge data frames with different size: " + this.size() + " vs " + df.size());
        }
        ArrayList<ValueVector> data = new ArrayList<ValueVector>(this.columns);
        HashSet<Object> names = new HashSet<Object>();
        Collections.addAll(names, this.names());
        int order = 2;
        for (DataFrame df : dataframes) {
            String suffix = "_" + order++;
            for (ValueVector column : df.columns) {
                if (!names.contains(column.name())) {
                    data.add(column);
                    names.add(column.name());
                    continue;
                }
                String name = column.name() + suffix;
                data.add(column.withName(name));
                names.add(name);
            }
        }
        return new DataFrame(this.index, (ValueVector[])data.toArray(ValueVector[]::new));
    }

    public DataFrame concat(DataFrame ... dataframes) {
        boolean hasIndex = this.index != null;
        for (DataFrame df : dataframes) {
            if (!this.schema.equals(df.schema())) {
                throw new IllegalArgumentException("Union data frames with different schema: " + String.valueOf(this.schema) + " vs " + String.valueOf(df.schema()));
            }
            hasIndex &= df.index != null;
        }
        Stream rows = Stream.concat(Stream.of(this), Stream.of(dataframes)).flatMap(DataFrame::stream);
        DataFrame df = DataFrame.of(this.schema, rows);
        if (hasIndex) {
            Object[] index = Stream.concat(Stream.of(this), Stream.of(dataframes)).flatMap(data -> Arrays.stream(data.index.values())).toArray();
            df = df.setIndex(index);
        }
        return df;
    }

    public DataFrame factorize(String ... names) {
        if (names.length == 0) {
            names = (String[])this.schema().fields().stream().filter(field -> field.dtype().isString()).map(StructField::name).toArray(String[]::new);
        }
        int n = this.size();
        HashSet set = new HashSet();
        Collections.addAll(set, names);
        ValueVector[] vectors = (ValueVector[])this.columns.stream().map(column -> {
            if (!set.contains(column.name())) {
                return column;
            }
            List<String> levels = IntStream.range(0, n).mapToObj(column::getString).distinct().sorted().toList();
            NominalScale scale = new NominalScale(levels);
            int[] data = new int[n];
            for (int i = 0; i < n; ++i) {
                String s = column.getString(i);
                data[i] = s == null ? -1 : scale.valueOf(s).intValue();
            }
            StructField field = new StructField(column.name(), DataTypes.IntType, scale);
            return new IntVector(field, data);
        }).toArray(ValueVector[]::new);
        return new DataFrame(this.index, vectors);
    }

    public double[][] toArray(String ... columns) {
        return this.toArray(false, CategoricalEncoder.LEVEL, columns);
    }

    public double[][] toArray(boolean bias, CategoricalEncoder encoder, String ... names) {
        int nrow = this.size();
        if (names.length == 0) {
            names = this.schema.names();
        }
        ArrayList<String> colNames = new ArrayList<String>();
        if (bias) {
            colNames.add("Intercept");
        }
        for (String name : names) {
            ValueVector column = this.column(name);
            StructField field = column.field();
            Measure measure = field.measure();
            if (encoder != CategoricalEncoder.LEVEL && measure instanceof CategoricalMeasure) {
                int k;
                CategoricalMeasure cat = (CategoricalMeasure)measure;
                int n = cat.size();
                if (encoder == CategoricalEncoder.DUMMY) {
                    for (k = 1; k < n; ++k) {
                        colNames.add(String.format("%s_%s", name, cat.level(k)));
                    }
                    continue;
                }
                if (encoder != CategoricalEncoder.ONE_HOT) continue;
                for (k = 0; k < n; ++k) {
                    colNames.add(String.format("%s_%s", name, cat.level(k)));
                }
                continue;
            }
            colNames.add(name);
        }
        double[][] matrix = new double[nrow][colNames.size()];
        int j = 0;
        if (bias) {
            ++j;
            for (int i = 0; i < nrow; ++i) {
                matrix[i][0] = 1.0;
            }
        }
        for (String name : names) {
            int i;
            ValueVector column = this.column(name);
            StructField field = column.field();
            Measure measure = field.measure();
            if (encoder != CategoricalEncoder.LEVEL && measure instanceof CategoricalMeasure) {
                int k;
                CategoricalMeasure cat = (CategoricalMeasure)measure;
                if (encoder == CategoricalEncoder.DUMMY) {
                    for (i = 0; i < nrow; ++i) {
                        k = cat.factor(column.getInt(i));
                        if (k <= 0) continue;
                        matrix[i][j + k - 1] = 1.0;
                    }
                    j += cat.size() - 1;
                    continue;
                }
                if (encoder != CategoricalEncoder.ONE_HOT) continue;
                for (i = 0; i < nrow; ++i) {
                    k = cat.factor(column.getInt(i));
                    matrix[i][j + k] = 1.0;
                }
                j += cat.size();
                continue;
            }
            for (i = 0; i < nrow; ++i) {
                matrix[i][j] = column.getDouble(i);
            }
            ++j;
        }
        return matrix;
    }

    public Matrix toMatrix() {
        return this.toMatrix(false, CategoricalEncoder.LEVEL, null);
    }

    public Matrix toMatrix(boolean bias, CategoricalEncoder encoder, String rowNames) {
        int nrow = this.size();
        int ncol = this.columns.size();
        ArrayList<String> colNames = new ArrayList<String>();
        if (bias) {
            colNames.add("Intercept");
        }
        for (ValueVector column : this.columns) {
            StructField field = column.field();
            if (field.name().equals(rowNames)) continue;
            Measure measure = field.measure();
            if (encoder != CategoricalEncoder.LEVEL && measure instanceof CategoricalMeasure) {
                int k;
                CategoricalMeasure cat = (CategoricalMeasure)measure;
                int n = cat.size();
                if (encoder == CategoricalEncoder.DUMMY) {
                    for (k = 1; k < n; ++k) {
                        colNames.add(String.format("%s_%s", field.name(), cat.level(k)));
                    }
                    continue;
                }
                if (encoder != CategoricalEncoder.ONE_HOT) continue;
                for (k = 0; k < n; ++k) {
                    colNames.add(String.format("%s_%s", field.name(), cat.level(k)));
                }
                continue;
            }
            colNames.add(field.name());
        }
        Matrix matrix = new Matrix(nrow, colNames.size());
        matrix.colNames(colNames.toArray(new String[0]));
        if (rowNames != null) {
            int j = this.schema.indexOf(rowNames);
            String[] rows = new String[nrow];
            for (int i = 0; i < nrow; ++i) {
                rows[i] = this.getString(i, j);
            }
            matrix.rowNames(rows);
        }
        int j = 0;
        if (bias) {
            ++j;
            for (int i = 0; i < nrow; ++i) {
                matrix.set(i, 0, 1.0);
            }
        }
        for (ValueVector column : this.columns) {
            int i;
            StructField field = column.field();
            if (field.name().equals(rowNames)) continue;
            Measure measure = field.measure();
            if (encoder != CategoricalEncoder.LEVEL && measure instanceof CategoricalMeasure) {
                int k;
                CategoricalMeasure cat = (CategoricalMeasure)measure;
                if (encoder == CategoricalEncoder.DUMMY) {
                    for (i = 0; i < nrow; ++i) {
                        k = cat.factor(column.getInt(i));
                        if (k <= 0) continue;
                        matrix.set(i, j + k - 1, 1.0);
                    }
                    j += cat.size() - 1;
                    continue;
                }
                if (encoder != CategoricalEncoder.ONE_HOT) continue;
                for (i = 0; i < nrow; ++i) {
                    k = cat.factor(column.getInt(i));
                    matrix.set(i, j + k, 1.0);
                }
                j += cat.size();
                continue;
            }
            for (i = 0; i < nrow; ++i) {
                matrix.set(i, j, column.getDouble(i));
            }
            ++j;
        }
        return matrix;
    }

    public DataFrame describe() {
        int ncol = this.columns.size();
        DataType[] dtypes = this.dtypes();
        Measure[] measures = this.measures();
        int[] count = new int[ncol];
        Object[] mode = new Object[ncol];
        double[] mean = new double[ncol];
        double[] std = new double[ncol];
        double[] min = new double[ncol];
        double[] q1 = new double[ncol];
        double[] median = new double[ncol];
        double[] q3 = new double[ncol];
        double[] max = new double[ncol];
        Arrays.fill(mean, Double.NaN);
        Arrays.fill(std, Double.NaN);
        Arrays.fill(min, Double.NaN);
        Arrays.fill(q1, Double.NaN);
        Arrays.fill(median, Double.NaN);
        Arrays.fill(q3, Double.NaN);
        Arrays.fill(max, Double.NaN);
        for (int j = 0; j < ncol; ++j) {
            Object[] data;
            DataType dtype = dtypes[j];
            Measure measure = measures[j];
            if (measure instanceof CategoricalMeasure) {
                CategoricalMeasure measure2 = (CategoricalMeasure)measure;
                data = this.columns.get(j).intStream().filter(x -> x != Integer.MIN_VALUE).toArray();
                count[j] = data.length;
                mode[j] = measure2.toString(MathEx.mode(data));
                min[j] = MathEx.min(data);
                q1[j] = MathEx.q1(data);
                median[j] = MathEx.median(data);
                q3[j] = MathEx.q3(data);
                max[j] = MathEx.max(data);
                continue;
            }
            if (dtype.isLong()) {
                data = this.columns.get(j).longStream().filter(x -> x != Long.MIN_VALUE).mapToDouble(x -> x).toArray();
                count[j] = data.length;
                mode[j] = Double.NaN;
                mean[j] = MathEx.mean((double[])data);
                std[j] = MathEx.stdev((double[])data);
                min[j] = MathEx.min((double[])data);
                q1[j] = MathEx.q1((double[])data);
                median[j] = MathEx.median((double[])data);
                q3[j] = MathEx.q3((double[])data);
                max[j] = MathEx.max((double[])data);
                continue;
            }
            if (dtype.isIntegral()) {
                data = this.columns.get(j).intStream().filter(x -> x != Integer.MIN_VALUE).toArray();
                count[j] = data.length;
                mode[j] = MathEx.mode(data);
                mean[j] = MathEx.mean(data);
                std[j] = MathEx.stdev(data);
                min[j] = MathEx.min(data);
                q1[j] = MathEx.q1(data);
                median[j] = MathEx.median(data);
                q3[j] = MathEx.q3(data);
                max[j] = MathEx.max(data);
                continue;
            }
            if (dtype.isFloating() || dtype.isDecimal()) {
                data = this.columns.get(j).doubleStream().filter(Double::isFinite).toArray();
                count[j] = data.length;
                mode[j] = Double.NaN;
                mean[j] = MathEx.mean((double[])data);
                std[j] = MathEx.stdev((double[])data);
                min[j] = MathEx.min((double[])data);
                q1[j] = MathEx.q1((double[])data);
                median[j] = MathEx.median((double[])data);
                q3[j] = MathEx.q3((double[])data);
                max[j] = MathEx.max((double[])data);
                continue;
            }
            count[j] = (int)this.columns.get(j).stream().filter(Objects::nonNull).count();
            mode[j] = this.columns.get(j).stream().filter(Objects::nonNull).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElse(null);
        }
        return new DataFrame(new StringVector("column", this.names()), new ObjectVector<DataType>("type", dtypes), new ObjectVector<Measure>("measure", measures), new IntVector("count", count), new ObjectVector<Object>("mode", mode), new DoubleVector("mean", mean), new DoubleVector("std", std), new DoubleVector("min", min), new DoubleVector("25%", q1), new DoubleVector("50%", median), new DoubleVector("75%", q3), new DoubleVector("max", max));
    }

    public String head(int numRows) {
        return this.toString(0, numRows, true);
    }

    public String tail(int numRows) {
        return this.toString(Math.max(0, this.size() - numRows), this.size(), true);
    }

    public String toString(int from, int to, boolean truncate) {
        int rest;
        if (from < 0 || from >= this.size()) {
            throw new IllegalArgumentException("from: " + from + ", size: " + this.size());
        }
        if (to <= from) {
            throw new IllegalArgumentException("'to' must be greater than 'from'");
        }
        to = Math.min(to, this.size());
        StringBuilder sb = new StringBuilder();
        boolean hasMoreData = from == 0 && this.size() > to;
        int numCols = this.ncol() + 1;
        String[] names = new String[numCols];
        names[0] = "";
        System.arraycopy(this.names(), 0, names, 1, this.ncol());
        int maxColWidth = switch (numCols) {
            case 1 -> 78;
            case 2 -> 38;
            default -> 20;
        };
        int[] colWidths = new int[numCols];
        for (int i = 0; i < numCols; ++i) {
            colWidths[i] = Math.max(names[i].length(), 3);
        }
        int numRows = to - from;
        String[][] rows = new String[numRows][numCols];
        for (int i = 0; i < numRows; ++i) {
            int row = from + i;
            String[] cells = rows[i];
            cells[0] = this.index == null ? Integer.toString(row) : this.index.values()[row].toString();
            for (int j = 1; j < numCols; ++j) {
                String str = this.columns.get(j - 1).getString(row);
                cells[j] = truncate && str.length() > maxColWidth ? str.substring(0, maxColWidth - 3) + "..." : str;
            }
        }
        for (String[] row : rows) {
            for (int i = 0; i < numCols; ++i) {
                colWidths[i] = Math.max(colWidths[i], row[i].length());
            }
        }
        String sep = IntStream.of(colWidths).mapToObj(w -> Strings.fill('-', w)).collect(Collectors.joining("+", "+", "+\n"));
        sb.append(sep);
        sb.append((CharSequence)this.line(names, colWidths, truncate));
        sb.append(sep);
        for (String[] row : rows) {
            sb.append((CharSequence)this.line(row, colWidths, truncate));
        }
        sb.append(sep);
        if (hasMoreData && (rest = this.size() - to) > 0) {
            String rowsString = rest == 1 ? "row" : "rows";
            sb.append(String.format("%d more %s...\n", rest, rowsString));
        }
        return sb.toString();
    }

    private StringBuilder line(String[] row, int[] colWidths, boolean truncate) {
        StringBuilder line = new StringBuilder();
        line.append('|');
        line.append(Strings.leftPad(row[0], colWidths[0], ' '));
        line.append('|');
        for (int i = 1; i < colWidths.length; ++i) {
            if (truncate) {
                line.append(Strings.leftPad(row[i], colWidths[i], ' '));
            } else {
                line.append(Strings.rightPad(row[i], colWidths[i], ' '));
            }
            line.append('|');
        }
        line.append('\n');
        return line;
    }

    public static DataFrame of(double[][] data, String ... names) {
        int p = data[0].length;
        if (names == null || names.length == 0) {
            names = (String[])IntStream.range(1, p + 1).mapToObj(i -> "V" + i).toArray(String[]::new);
        }
        ValueVector[] columns = new DoubleVector[p];
        for (int j = 0; j < p; ++j) {
            double[] x = new double[data.length];
            for (int i2 = 0; i2 < x.length; ++i2) {
                x[i2] = data[i2][j];
            }
            columns[j] = new DoubleVector(names[j], x);
        }
        return new DataFrame(columns);
    }

    public static DataFrame of(float[][] data, String ... names) {
        int p = data[0].length;
        if (names == null || names.length == 0) {
            names = (String[])IntStream.range(1, p + 1).mapToObj(i -> "V" + i).toArray(String[]::new);
        }
        ValueVector[] columns = new FloatVector[p];
        for (int j = 0; j < p; ++j) {
            float[] x = new float[data.length];
            for (int i2 = 0; i2 < x.length; ++i2) {
                x[i2] = data[i2][j];
            }
            columns[j] = new FloatVector(names[j], x);
        }
        return new DataFrame(columns);
    }

    public static DataFrame of(int[][] data, String ... names) {
        int p = data[0].length;
        if (names == null || names.length == 0) {
            names = (String[])IntStream.range(1, p + 1).mapToObj(i -> "V" + i).toArray(String[]::new);
        }
        ValueVector[] columns = new IntVector[p];
        for (int j = 0; j < p; ++j) {
            int[] x = new int[data.length];
            for (int i2 = 0; i2 < x.length; ++i2) {
                x[i2] = data[i2][j];
            }
            columns[j] = new IntVector(names[j], x);
        }
        return new DataFrame(columns);
    }

    public static <T> DataFrame of(Class<T> clazz, List<T> data) {
        try {
            int n = data.size();
            Property[] props = Property.of(clazz);
            ArrayList<ValueVector> columns = new ArrayList<ValueVector>();
            for (Property prop : props) {
                Object values;
                ObjectVector<int> vector;
                Object datum2;
                Object[] values2;
                StructField field = prop.field();
                Method read = prop.accessor();
                Class<?> type = prop.type();
                int i = 0;
                if (type == Integer.TYPE) {
                    values2 = new int[n];
                    for (Object datum2 : data) {
                        values2[i++] = (Integer)read.invoke(datum2, new Object[0]);
                    }
                    vector = new IntVector(field, (int[])values2);
                    columns.add(vector);
                    continue;
                }
                if (type == Double.TYPE) {
                    values2 = new double[n];
                    for (Object datum2 : data) {
                        values2[i++] = (int)((Double)read.invoke(datum2, new Object[0])).doubleValue();
                    }
                    vector = new DoubleVector(field, (double[])values2);
                    columns.add(vector);
                    continue;
                }
                if (type == Boolean.TYPE) {
                    values2 = new boolean[n];
                    for (Object datum2 : data) {
                        values2[i++] = ((Boolean)read.invoke(datum2, new Object[0])).booleanValue() ? 1 : 0;
                    }
                    vector = new BooleanVector(field, (boolean[])values2);
                    columns.add(vector);
                    continue;
                }
                if (type == Short.TYPE) {
                    values2 = new short[n];
                    for (Object datum2 : data) {
                        values2[i++] = ((Short)read.invoke(datum2, new Object[0])).shortValue();
                    }
                    vector = new ShortVector(field, (short[])values2);
                    columns.add(vector);
                    continue;
                }
                if (type == Long.TYPE) {
                    values2 = new long[n];
                    for (Object datum2 : data) {
                        values2[i++] = (int)((Long)read.invoke(datum2, new Object[0])).longValue();
                    }
                    vector = new LongVector(field, (long[])values2);
                    columns.add(vector);
                    continue;
                }
                if (type == Float.TYPE) {
                    values2 = new float[n];
                    for (Object datum2 : data) {
                        values2[i++] = (int)((Float)read.invoke(datum2, new Object[0])).floatValue();
                    }
                    vector = new FloatVector(field, (float[])values2);
                    columns.add(vector);
                    continue;
                }
                if (type == Byte.TYPE) {
                    values2 = new byte[n];
                    for (Object datum2 : data) {
                        values2[i++] = ((Byte)read.invoke(datum2, new Object[0])).byteValue();
                    }
                    vector = new ByteVector(field, (byte[])values2);
                    columns.add(vector);
                    continue;
                }
                if (type == Character.TYPE) {
                    values2 = new char[n];
                    for (Object datum2 : data) {
                        values2[i++] = ((Character)read.invoke(datum2, new Object[0])).charValue();
                    }
                    vector = new CharVector(field, (char[])values2);
                    columns.add(vector);
                    continue;
                }
                if (type == String.class) {
                    values2 = new String[n];
                    for (Object datum2 : data) {
                        values2[i++] = (int)((String)read.invoke(datum2, new Object[0]));
                    }
                    vector = new StringVector(field, (String[])values2);
                    columns.add(vector);
                    continue;
                }
                if (type.isEnum()) {
                    Object vector2;
                    ?[] levels = type.getEnumConstants();
                    if (levels.length < 128) {
                        values = new byte[n];
                        datum2 = data.iterator();
                        while (datum2.hasNext()) {
                            Object datum3 = datum2.next();
                            values[i++] = (byte)((Enum)read.invoke(datum3, new Object[0])).ordinal();
                        }
                        vector2 = new ByteVector(field, (byte[])values);
                        columns.add((ValueVector)vector2);
                        continue;
                    }
                    if (levels.length < 32768) {
                        values = new short[n];
                        for (Object datum3 : data) {
                            values[i++] = (short)((Enum)read.invoke(datum3, new Object[0])).ordinal();
                        }
                        vector2 = new ShortVector(field, (short[])values);
                        columns.add((ValueVector)vector2);
                        continue;
                    }
                    values = new int[n];
                    for (Object datum3 : data) {
                        values[i++] = ((Enum)read.invoke(datum3, new Object[0])).ordinal();
                    }
                    vector2 = new IntVector(field, (int[])values);
                    columns.add((ValueVector)vector2);
                    continue;
                }
                if (Number.class.isAssignableFrom(type)) {
                    values2 = new Number[n];
                    values = data.iterator();
                    while (values.hasNext()) {
                        datum2 = values.next();
                        values2[i++] = (int)((Number)read.invoke(datum2, new Object[0]));
                    }
                    vector = new NumberVector(field, (Number[])values2);
                    columns.add(vector);
                    continue;
                }
                values2 = new Object[n];
                for (Object datum2 : data) {
                    values2[i++] = (int)read.invoke(datum2, new Object[0]);
                }
                vector = new ObjectVector<int>(field, values2);
                columns.add(vector);
            }
            return new DataFrame(StructType.of(props), columns, null);
        }
        catch (IntrospectionException ex) {
            logger.error("Failed to introspect a bean: ", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        catch (ReflectiveOperationException ex) {
            logger.error("Failed to call property read method: ", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public static DataFrame of(StructType schema, Stream<? extends Tuple> data) {
        return DataFrame.of(schema, data.toList());
    }

    public static DataFrame of(StructType schema, List<? extends Tuple> data) {
        if (data.isEmpty()) {
            throw new IllegalArgumentException("Empty tuple collections");
        }
        int n = data.size();
        List<StructField> fields = schema.fields();
        ArrayList<ValueVector> columns = new ArrayList<ValueVector>(fields.size());
        for (int j = 0; j < fields.size(); ++j) {
            BitSet nullMask = new BitSet(n);
            StructField field = fields.get(j);
            columns.add(switch (field.dtype().id()) {
                case DataType.ID.Int -> {
                    Tuple datum;
                    int i;
                    Object[] values = new int[n];
                    for (i = 0; i < n; ++i) {
                        datum = data.get(i);
                        if (datum.isNullAt(j)) {
                            nullMask.set(i);
                            values[i] = Integer.MIN_VALUE;
                            continue;
                        }
                        values[i] = datum.getInt(j);
                    }
                    if (field.dtype().isNullable()) {
                        yield new NullableIntVector(field, (int[])values, nullMask);
                    }
                    yield new IntVector(field, (int[])values);
                }
                case DataType.ID.Long -> {
                    Tuple datum;
                    int i;
                    Object[] values = new long[n];
                    for (i = 0; i < n; ++i) {
                        datum = data.get(i);
                        if (datum.isNullAt(j)) {
                            nullMask.set(i);
                            values[i] = (int)Long.MIN_VALUE;
                            continue;
                        }
                        values[i] = (int)datum.getLong(j);
                    }
                    if (field.dtype().isNullable()) {
                        yield new NullableLongVector(field, (long[])values, nullMask);
                    }
                    yield new LongVector(field, (long[])values);
                }
                case DataType.ID.Double -> {
                    Tuple datum;
                    int i;
                    Object[] values = new double[n];
                    for (i = 0; i < n; ++i) {
                        datum = data.get(i);
                        if (datum.isNullAt(j)) {
                            nullMask.set(i);
                            values[i] = (int)Double.NaN;
                            continue;
                        }
                        values[i] = (int)datum.getDouble(j);
                    }
                    if (field.dtype().isNullable()) {
                        yield new NullableDoubleVector(field, (double[])values, nullMask);
                    }
                    yield new DoubleVector(field, (double[])values);
                }
                case DataType.ID.Float -> {
                    Tuple datum;
                    int i;
                    Object[] values = new float[n];
                    for (i = 0; i < n; ++i) {
                        datum = data.get(i);
                        if (datum.isNullAt(j)) {
                            nullMask.set(i);
                            values[i] = (int)Float.NaN;
                            continue;
                        }
                        values[i] = (int)datum.getFloat(j);
                    }
                    if (field.dtype().isNullable()) {
                        yield new NullableFloatVector(field, (float[])values, nullMask);
                    }
                    yield new FloatVector(field, (float[])values);
                }
                case DataType.ID.Boolean -> {
                    Tuple datum;
                    int i;
                    Object[] values = new boolean[n];
                    for (i = 0; i < n; ++i) {
                        datum = data.get(i);
                        if (datum.isNullAt(j)) {
                            nullMask.set(i);
                            continue;
                        }
                        values[i] = datum.getBoolean(j) ? 1 : 0;
                    }
                    if (field.dtype().isNullable()) {
                        yield new NullableBooleanVector(field, (boolean[])values, nullMask);
                    }
                    yield new BooleanVector(field, (boolean[])values);
                }
                case DataType.ID.Byte -> {
                    Tuple datum;
                    int i;
                    Object[] values = new byte[n];
                    for (i = 0; i < n; ++i) {
                        datum = data.get(i);
                        if (datum.isNullAt(j)) {
                            nullMask.set(i);
                            values[i] = -128;
                            continue;
                        }
                        values[i] = datum.getByte(j);
                    }
                    if (field.dtype().isNullable()) {
                        yield new NullableByteVector(field, (byte[])values, nullMask);
                    }
                    yield new ByteVector(field, (byte[])values);
                }
                case DataType.ID.Short -> {
                    Tuple datum;
                    int i;
                    Object[] values = new short[n];
                    for (i = 0; i < n; ++i) {
                        datum = data.get(i);
                        if (datum.isNullAt(j)) {
                            nullMask.set(i);
                            values[i] = Short.MIN_VALUE;
                            continue;
                        }
                        values[i] = datum.getShort(j);
                    }
                    if (field.dtype().isNullable()) {
                        yield new NullableShortVector(field, (short[])values, nullMask);
                    }
                    yield new ShortVector(field, (short[])values);
                }
                case DataType.ID.Char -> {
                    Tuple datum;
                    int i;
                    Object[] values = new char[n];
                    for (i = 0; i < n; ++i) {
                        datum = data.get(i);
                        if (datum.isNullAt(j)) {
                            nullMask.set(i);
                            values[i] = 0;
                            continue;
                        }
                        values[i] = datum.getChar(j);
                    }
                    if (field.dtype().isNullable()) {
                        yield new NullableCharVector(field, (char[])values, nullMask);
                    }
                    yield new CharVector(field, (char[])values);
                }
                case DataType.ID.String -> {
                    int i;
                    Object[] values = new String[n];
                    for (i = 0; i < n; ++i) {
                        values[i] = (int)data.get(i).getString(j);
                    }
                    yield new StringVector(field, (String[])values);
                }
                case DataType.ID.Decimal -> {
                    int i;
                    Object[] values = new BigDecimal[n];
                    for (i = 0; i < n; ++i) {
                        values[i] = (int)((BigDecimal)data.get(i).get(j));
                    }
                    yield new NumberVector(field, (Number[])values);
                }
                default -> {
                    int i;
                    Object[] values = new Object[n];
                    for (i = 0; i < n; ++i) {
                        values[i] = (int)data.get(i).get(j);
                    }
                    yield new ObjectVector<int>(field, values);
                }
            });
        }
        return new DataFrame(schema, columns, null);
    }

    public static DataFrame of(ResultSet rs) throws SQLException {
        StructType schema = StructType.of(rs);
        ArrayList<Tuple> rows = new ArrayList<Tuple>();
        while (rs.next()) {
            rows.add(Tuple.of(schema, rs));
        }
        return DataFrame.of(schema, rows);
    }
}

